Rem
Rem $Header: ordahtsp.sql 30-sep-2004.09:31:28 rabbott Exp $
Rem
Rem ordahtsp.sql
Rem
Rem Copyright (c) 1998, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ordahtsp.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      ORD source extension for HTtp ... package SPec
Rem
Rem    NOTES
Rem      This package provides access to HTTP (currently
Rem      only within the firewall) server as a viable source 
Rem      for any object using this. This package uses UTL_HTTP
Rem      to make connections to an external web site and
Rem      get data from it. All the interfaces (required by
Rem      ORDSYS.ORDSource) are not implemented in this package.
Rem
Rem      IMPLEMENTED Interfaces:
Rem            import
Rem            importFrom
Rem            getSourceAddress
Rem      ALL OTHER METHODS CURRENTLY RAISE 
Rem          ORDSourceExceptions.METHOD_NOT_IMPLEMENTED
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rabbott     09/30/04 - bug 1058722 
Rem    smavris     04/11/01 - Update copyright
Rem    rabbott     07/20/00 - Add TRUST to getContentLength
Rem    dmullen     03/03/00 - Add simplified import to fix bug 949833
Rem    rchatter    11/16/98 - rework context parameter
Rem    alsrivas    11/02/98 - fixing arg ordering in ctx and obj
Rem    alsrivas    08/27/98 - adding NOCOPY
Rem    alsrivas    08/05/98 - updating apis
Rem    alsrivas    06/12/98 - updating interfaces
Rem    alsrivas    06/08/98 - adding pragma
Rem    alsrivas    05/27/98 - adding authorization
Rem    alsrivas    05/25/98 - changes made per code review findings
Rem    alsrivas    05/11/98 - updating
Rem    alsrivas    04/27/98 - updating code for user-defined sources
Rem    alsrivas    04/27/98 - ORD Audio HTtp SPecification
Rem    alsrivas    04/27/98 - Created
Rem

Rem
Rem ORD eXtension for HTTP server as a SOURCE
Rem


CREATE OR REPLACE PACKAGE ORDX_HTTP_SOURCE 
authid current_user
AS

  -- functions/procedures
  FUNCTION processCommand(
                    obj  IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx  IN OUT RAW,
                    cmd  IN VARCHAR2,
                    arglist IN VARCHAR2,
                    result  OUT RAW)
           RETURN RAW;
 
  PROCEDURE import( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx      IN OUT RAW,
                    mimetype OUT VARCHAR2,
                    format   OUT VARCHAR2);

  PROCEDURE import( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx      IN OUT RAW,
                    dlob     IN OUT NOCOPY BLOB,
                    mimetype OUT VARCHAR2,
                    format   OUT VARCHAR2);

  PROCEDURE importFrom( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                        ctx      IN OUT RAW,
                        mimetype OUT VARCHAR2,
                        format   OUT VARCHAR2,
                        loc      IN VARCHAR2,
                        name     IN VARCHAR2);

  PROCEDURE importFrom( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                        ctx      IN OUT RAW,
                        dlob     IN OUT NOCOPY BLOB,
                        mimetype OUT VARCHAR2,
                        format   OUT VARCHAR2,
                        loc      IN VARCHAR2,
                        name     IN VARCHAR2);
 
  PROCEDURE export( obj  IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx  IN OUT RAW,
                    dlob IN OUT NOCOPY BLOB,
                    loc  IN VARCHAR2,
                    name IN VARCHAR2);
 
  FUNCTION  getContentLength(obj  IN ORDSYS.ORDSource,
                             ctx  IN OUT RAW) 
            RETURN INTEGER;
  -- TRUST added to enable use of new UTL_HTTP API
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS, TRUST);
 
  FUNCTION  getSourceAddress(obj  IN ORDSYS.ORDSource,
                             ctx  IN OUT RAW,
                             userData IN VARCHAR2) 
            RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES(getSourceAddress, WNDS, WNPS, RNDS, RNPS);

  FUNCTION open(obj IN OUT NOCOPY ORDSYS.ORDSource,
                userArg IN RAW,
                ctx OUT RAW) RETURN INTEGER;
  FUNCTION close(obj IN OUT NOCOPY ORDSYS.ORDSource,
                 ctx IN OUT RAW) RETURN INTEGER;
  FUNCTION trim(obj    IN OUT NOCOPY ORDSYS.ORDSource,
                       ctx IN OUT RAW,
                       newlen IN INTEGER) RETURN INTEGER;
 
  PROCEDURE read(obj      IN OUT NOCOPY ORDSYS.ORDSource,
                 ctx      IN OUT RAW,
                 startPos IN INTEGER,
                 numBytes IN OUT INTEGER,
                 buffer   OUT RAW);
 
  PROCEDURE write(obj      IN OUT NOCOPY ORDSYS.ORDSource,
                  ctx      IN OUT RAW,
                  startPos IN INTEGER,
                  numBytes IN OUT INTEGER,
                  buffer   IN RAW);

END ORDX_HTTP_SOURCE;
/
show errors;
