Rem
Rem $Header: ordcpksp.sql 11-sep-2007.09:54:14 smavris Exp $
Rem
Rem ordcpksp.sql
Rem
Rem Copyright (c) 2006, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ordcpksp.sql - ORD_DICOM Package Specification 
Rem      
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem    
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smavris     09/11/07 - Change interMedia to Oracle Multimedia
Rem    myalavar    04/11/07 - update namespace
Rem    fechen      06/30/06 - rename from ConstraintName to constraintName 
Rem    dolin       06/12/06 - remove conformanceValidate procedure 
Rem    myalavar    06/07/06 - tagName -> attributeName 
Rem    fechen      04/24/06 - change from named to mapped 
Rem    fechen      04/19/06 - Created
Rem

Rem **************************************************************************
Rem THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL
Rem INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE 
Rem RELEASES.
Rem THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
Rem COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.
Rem **************************************************************************


CREATE OR REPLACE PACKAGE ORD_DICOM 
authid current_user
AS

  -- 
  -- public constants
  --
  DEFAULT_ANONYMITY_DOC CONSTANT VARCHAR2(64):='ordcman.xml';
  DEFAULT_MAPPING_DOC CONSTANT VARCHAR2(64):='ordcmmp.xml';
  DEFAULT_METADATA_NS CONSTANT VARCHAR2(64):=
                        'http://xmlns.oracle.com/ord/dicom/metadata_1_0'; 
  DATATYPE_NS CONSTANT VARCHAR2(64):=
                        'http://xmlns.oracle.com/ord/dicom/datatype_1_0'; 
  DEFAULT_EXTRACT_OPTION VARCHAR2(32):= 'ALL';

  --
  -- public functions/procedures
  --


  --
  -- Description:    Import DICOM binary data from a given source into BLOB.
  -- Input:     
  --   dest: Destination storage of the imported DICOM file.
  --   source_type: The type of the source(FILE)
  --   source_location: The source location. (File directory object)
  --   source_name: The name of the source file.
  -- Exception: None.
  --
  PROCEDURE importFrom(
      dest            IN OUT NOCOPY BLOB,
      source_type     IN     VARCHAR2,
      source_location IN     VARCHAR2,
      source_name     IN     VARCHAR2);

  --
  -- Description:   Export DICOM binary data in a BLOB to the specified 
  --                destination. 
  --   src: The source location of the DICOM binary data.
  --   dest_type: The type of the destination. (FILE)
  --   dest_location: The destination location . (File directory object)
  --   dest_name: The name of the destination file.
  -- Exception:  None.
  --
  PROCEDURE export(
      src             IN     BLOB,
      dest_type       IN     VARCHAR2,
      dest_location   IN     VARCHAR2,
      dest_name       IN     VARCHAR2);

  --
  -- Description:  Get DICOM metadata in XML for a given XML metadata schema. 
  -- Input:   
  --   data: The input DICOM binary data stored in BLOB.
  --   extractOption: 
  --    'ALL': Default. Extract all attributes from the DICOM binary data.
  --    'MAPPED': Extract only mapped attributes. 
  --    'STANDARD': Extract only DICOM Standard attributes and mapped 
  --                attributes.
  --   docName: The name  of the mapping document. The default mapping document
  --     ordcmmp.xml is loaded during installation and refers to the default 
  --     metadata namespace of "http://xmlns.oracle.com/ord/dicom/metadata_1_0"  
  -- Return: Metadata encoded in XML (not schema-validated)
  -- Exception: None.
  --
  FUNCTION extractMetadata (
      data          IN BLOB, 
      extractOption IN VARCHAR2 DEFAULT DEFAULT_EXTRACT_OPTION,
      docName       IN VARCHAR2 DEFAULT DEFAULT_MAPPING_DOC) 
      RETURN SYS.XMLTYPE;

  --
  -- Description:  Get DICOM metadata in XML for a given XML metadata schema. 
  -- Input:   
  --   data: The input DICOM binary data stored in BFILE.
  --   extractOption: 
  --    'ALL': Default. Extract all attributes from the DICOM binary data.
  --    'MAPPED': Extract only mapped attributes. 
  --    'STANDARD': Extract only DICOM Standard attributes and mapped 
  --                attributes.
  --   docName: The name  of the mapping document. The default mapping document
  --     ordcmmp.xml is loaded during installation and refers to the default 
  --     metadata namespace of "http://xmlns.oracle.com/ord/dicom/metadata_1_0"  
  -- Return: Metadata encoded in XML (not schema-validated)
  -- Exception:  None.
  --
  FUNCTION extractMetadata (
      data          IN BFILE, 
      extractOption IN VARCHAR2 DEFAULT DEFAULT_EXTRACT_OPTION,
      docName       IN VARCHAR2 DEFAULT DEFAULT_MAPPING_DOC) 
      RETURN SYS.XMLTYPE;

  --
  -- Description:  Get DICOM metadata in XML for a given XML metadata schema. 
  -- Input:   
  --   data: The input DICOM binary data stored in ORDSYS.ORDImage object.
  --   extractOption: 
  --    'ALL': Default. Extract all attributes from the DICOM binary data.
  --    'MAPPED': Extract only mapped attributes. 
  --    'STANDARD': Extract only DICOM Standard attributes and mapped 
  --                attributes.
  --   docName: The name  of the mapping document. The default mapping document
  --     ordcmmp.xml is loaded during installation and refers to the default 
  --     metadata namespace of "http://xmlns.oracle.com/ord/dicom/metadata_1_0"  
  -- Return: Metadata encoded in XML (not schema-validated)
  -- Exception:  None.
  --
  FUNCTION extractMetadata (
      data          IN ORDSYS.ORDImage, 
      extractOption IN VARCHAR2 DEFAULT DEFAULT_EXTRACT_OPTION,
      docName       IN VARCHAR2 DEFAULT DEFAULT_MAPPING_DOC) 
      RETURN SYS.XMLTYPE;

  --
  -- Description: Write/modify the current DICOM binary data with the provided 
  -- metadata by making a copy of the existing DICOM binary data and creating a 
  -- new DICOM binary data. The original DICOM binary data is not changed. 
  -- The destination DICOM binary data's attributes will be from the input XML 
  -- metadata.
  -- Input:  
  --   src: The input DICOM binary data stored in BLOB.
  --   metadata: The DICOM metadata in XMLTYPE. It should have all the 
  --             standard attributes and private attributes. The SOP instance 
  --             UID in the metadata must ensure the global uniqueness for the 
  --             destination DICOM binary data.
  --   dest: BLOB to store the new DICOM binary data with the new metadata.
  -- Exception: None.
  --
  PROCEDURE writeMetadata (
      src       IN BLOB, 
      metadata  IN SYS.XMLTYPE, 
      dest      IN OUT NOCOPY BLOB); 

  --
  -- Description: Write/modify the current DICOM binary data with the provided 
  -- metadata by making a copy of the existing DICOM binary data and creating a 
  -- new DICOM binary data. The original DICOM binary data is not changed. 
  -- The destination DICOM binary data's attributes will be from the input XML 
  -- metadata.
  -- Input:  
  --   src: The input DICOM binary data stored in BFILE.
  --   metadata: The DICOM metadata in XMLTYPE. It should have all the 
  --             standard attributes and private attributes. The SOP instance 
  --             UID in the metadata must ensure the global uniqueness for the 
  --             destination DICOM binary data.
  --   dest: BLOB to store the new DICOM binary data with the new metadata.
  -- Exception: None.
  --
  PROCEDURE writeMetadata (
      src       IN BFILE, 
      metadata  IN SYS.XMLTYPE, 
      dest      IN OUT NOCOPY BLOB); 

  --
  -- Description: Write/modify the current DICOM binary data with the provided 
  -- metadata by making a copy of the existing DICOM binary data and creating a 
  -- new DICOM binary data. The original DICOM binary data is not changed. 
  -- The destination DICOM binary data's attributes will be from the input XML 
  -- metadata.
  -- Input:  
  --   src: The input DICOM binary data stored in ORDSYS.ORDImage object.
  --   metadata: The DICOM metadata in XMLTYPE. It should have all the 
  --             standard attributes and private attributes. The SOP instance 
  --             UID in the metadata must ensure the global uniqueness for the 
  --             destination DICOM binary data.
  --   dest: BLOB to store the new DICOM binary data with the new metadata.
  -- Exception:  None.
  --
  PROCEDURE writeMetadata (
      src       IN ORDSYS.ORDImage, 
      metadata  IN SYS.XMLTYPE, 
      dest      IN OUT NOCOPY BLOB); 

  -- 
  -- Description: Process and copy the input DICOM image data into a raster 
  -- image. The input DICOM image is not changed.
  -- Input: 
  --   src: The input DICOM image data stored in the source BLOB.
  --   command: The command could have following verbs: 
  --            fileformat, frameNumber (default 0), contentformat, 
  --            compressionformat, cut, scale, rotate, etc. 
  --            Refer to "Oracle Multimedia Reference Guide" process command 
  --            for details on each verb.
  --   dest: The destination image stored in the destination BLOB.
  -- Exception: None.
  --
  PROCEDURE processCopy (
      src       IN BLOB, 
      command   IN VARCHAR2, 
      dest IN OUT NOCOPY BLOB);

  -- 
  -- Description: Process and copy the input DICOM image data into a raster 
  -- image. The input DICOM image is not changed.
  -- Input: 
  --   src: The input DICOM image data stored in the source BFILE.
  --   command: The command could have following verbs: 
  --            fileformat, frameNumber (default 0), contentformat, 
  --            compressionformat, cut, scale, rotate, etc. 
  --            Refer to "Oracle Multimedia Reference Guide" process command 
  --            for details on each verb.
  --   dest: The destination image stored in the destination BLOB.
  -- Exception: None.
  --
  PROCEDURE processCopy (
      src       IN BFILE, 
      command   IN VARCHAR2, 
      dest      IN OUT NOCOPY BLOB);

  -- 
  -- Description: Process and copy the input DICOM image data into a raster 
  -- image. The input DICOM image is not changed.
  -- Input: 
  --   src: The input DICOM image data stored in the source ORDImage object.
  --   command: The command could have following verbs: 
  --            fileformat, frameNumber (default 0), contentformat, 
  --            compressionformat, cut, scale, rotate, etc. 
  --            Refer to "Oracle Multimedia Reference Guide" process command 
  --            for details on each verb.
  --   dest: The destination image stored in the destination BLOB.
  -- Exception: None.
  --
  PROCEDURE processCopy (
      src       IN ORDSYS.ORDImage, 
      command   IN VARCHAR2, 
      dest IN OUT NOCOPY BLOB);

  --
  -- Description: Process and copy the input DICOM image into a 
  -- new DICOM image/raster image. The input DICOM image is not changed.
  -- Input: 
  --   src: The input DICOM image stored in the source BLOB.
  --   command: The command could have following verbs: 
  --            frameNumber (default 0), 
  --            contentformat, compressionformat, cut, scale, rotate. 
  --            Refer to "Oracle Multimedia Reference Guide" process command 
  --            for details on each verb.
  --   dest_SOP_INSTANCE_UID: The SOP instance UID of the destination 
  --                          DICOM image.       
  --   dest: The destination image stored in the destination BLOB.
  --   metadata: The new metadata to be written into the new DICOM 
  --             image.
  -- Exception: None.
  --
  PROCEDURE processCopy (
      src                   IN BLOB, 
      command               IN VARCHAR2, 
      dest_SOP_INSTANCE_UID IN VARCHAR2, 
      dest                  IN OUT NOCOPY BLOB,
      metadata              IN SYS.XMLTYPE DEFAULT NULL);

  --
  -- Description: Process and copy the input DICOM image into a 
  -- new DICOM image/raster image. The input DICOM image is not changed.
  -- Input: 
  --   src: The input DICOM image stored in the source BFILE.
  --   command: The command could have following verbs: 
  --            frameNumber (default 0), 
  --            contentformat, compressionformat, cut, scale, rotate. 
  --            Refer to "Oracle Multimedia Reference Guide" process command 
  --            for details on each verb.
  --   dest_SOP_INSTANCE_UID: The SOP instance UID of the destination 
  --                          DICOM image.       
  --   dest: The destination image stored in the destination BLOB.
  --   metadata: The new metadata to be written into the new DICOM 
  --             image.
  -- Exception: None.
  --
  PROCEDURE processCopy (
      src                   IN BFILE, 
      command               IN VARCHAR2, 
      dest_SOP_INSTANCE_UID IN VARCHAR2, 
      dest                  IN OUT NOCOPY BLOB,
      metadata              IN SYS.XMLTYPE DEFAULT NULL);

  --
  -- Description: Process and copy the input DICOM image into a 
  -- new DICOM image/raster image. The input DICOM image is not changed.
  -- Input: 
  --   src: The input DICOM image stored in the source ORDImage object.
  --   command: The command could have following verbs: 
  --            frameNumber (default 0), 
  --            contentformat, compressionformat, cut, scale, rotate. 
  --            Refer to "Oracle Multimedia Reference Guide" process command 
  --            for details on each verb.
  --   dest_SOP_INSTANCE_UID: The SOP instance UID of the destination 
  --                          DICOM image.
  --   dest: The destination image stored in the destination BLOB.
  --   metadata: The new metadata to be written into the new DICOM 
  --             image.
  -- Exception: None.
  --
  PROCEDURE processCopy (
      src                   IN ORDSYS.ORDImage, 
      command               IN VARCHAR2, 
      dest_SOP_INSTANCE_UID IN VARCHAR2, 
      dest                  IN OUT NOCOPY BLOB,
      metadata              IN SYS.XMLTYPE DEFAULT NULL);

  -- 
  -- Description: Create a DICOM image from a source raster image and 
  -- DICOM metadata.
  -- Input:   
  --   src: The source raster image stored in BLOB.
  --   metadata: DICOM metadata in XMLTYPE. It should have all the standard 
  --             and private attributes. It should have a new SOP instance 
  --             UID for the destination DICOM image.
  --   dest: A DICOM image created from the source image and metadata.
  -- Exception: None.
  --
  PROCEDURE createDICOMImage (
      src       IN BLOB, 
      metadata  IN SYS.XMLTYPE, 
      dest      IN OUT NOCOPY BLOB);

  -- 
  -- Description: Create a DICOM image from a source raster image and 
  -- DICOM metadata.
  -- Input:   
  --   src: The source raster image stored in BFILE.
  --   metadata: DICOM metadata in XMLTYPE. It should have all the standard 
  --             and private attributes. It should have a new SOP instance 
  --             UID for the destination DICOM image.
  --   dest: A DICOM image created from the source image and metadata.
  -- Exception:  None.
  --
  PROCEDURE createDICOMImage (
      src       IN BFILE, 
      metadata  IN SYS.XMLTYPE, 
      dest      IN OUT NOCOPY BLOB);

  -- 
  -- Description: Create a DICOM image from a source raster image and 
  -- DICOM metadata.
  -- Input:   
  --   src: The source raster image stored in ORDImage object.
  --   metadata: DICOM metadata in XMLTYPE. It should have all the standard 
  --             and private attributes. It should have a new SOP instance 
  --             UID for the destination DICOM image.
  --   dest: A DICOM image created from the source image and metadata.
  -- Exception:  None.
  --
  PROCEDURE createDICOMImage (
      src       IN ORDSYS.ORDImage, 
      metadata  IN SYS.XMLTYPE, 
      dest      IN OUT NOCOPY BLOB);

  -- 
  -- Description:    Make the source DICOM binary data anonymous after copying 
  -- into another DICOM binary data. How to make the DICOM binary data 
  -- anonymous is determined by the parameter anonymityDocName.  
  -- Input:   
  --   src: The input DICOM binary data in the source BLOB.
  --   dest_SOP_INSTANCE_UID: The SOP instance UID of the destination 
  --                          DICOM binary data.       
  --   dest: The anonymous DICOM binary data in the destination BLOB.
  --   anonymityDocName: The name of the anonymity definition document.
  -- Exception:  None.
  --
  PROCEDURE makeAnonymous (
      src                   IN BLOB, 
      dest_SOP_INSTANCE_UID IN VARCHAR2, 
      dest                  IN OUT NOCOPY BLOB, 
      anonymityDocName  IN VARCHAR2 DEFAULT DEFAULT_ANONYMITY_DOC);

  --
  -- Description:    Make the source DICOM binary data anonymous after copying 
  -- into another DICOM binary data. How to make the DICOM binary data 
  -- anonymous is determined by the parameter anonymityDocName.  
  -- Input:   
  --   src: The input DICOM binary data in the source BFILE.
  --   dest_SOP_INSTANCE_UID: The SOP instance UID of the destination 
  --                          DICOM binary data.       
  --   dest: The anonymous DICOM binary data in the destination BLOB.
  --   anonymityDocName: The name of the anonymity definition document.
  -- Exception:  None.
  --
  PROCEDURE makeAnonymous (
      src                   IN BFILE, 
      dest_SOP_INSTANCE_UID IN VARCHAR2, 
      dest                  IN OUT NOCOPY BLOB, 
      anonymityDocName  IN VARCHAR2 DEFAULT DEFAULT_ANONYMITY_DOC);

  --
  -- Description:    Make the source DICOM binary data anonymous after copying 
  -- into another DICOM binary data. How to make the DICOM binary data 
  -- anonymous is determined by the parameter anonymityDocName.  
  -- Input:   
  --   src: The input DICOM binary data in the source ORDImage object.
  --   dest_SOP_INSTANCE_UID: The SOP instance UID of the destination 
  --                          DICOM binary data.       
  --   dest: The anonymous DICOM binary data in the destination BLOB.
  --   anonymityDocName: The name of the anonymity definition document.
  -- Exception:  None.
  --
  PROCEDURE makeAnonymous (
      src                   IN ORDSYS.ORDImage, 
      dest_SOP_INSTANCE_UID IN VARCHAR2, 
      dest                  IN OUT NOCOPY BLOB, 
      anonymityDocName  IN VARCHAR2 DEFAULT DEFAULT_ANONYMITY_DOC);

  --
  -- Description:    Check if a DICOM binary data is anonymous according to the 
  -- anonymity definition document. 
  -- Input:   
  --   src: The input DICOM binary data in the source BLOB.
  --   anonymityDocName: The name of the anonymity definition document.
  -- Return: 0: not anonymous, 
  --         1: anonymous.
  -- Exception:  None.
  --
  FUNCTION isAnonymous(
     src                    IN BLOB, 
     anonymityDocName   IN VARCHAR2 DEFAULT DEFAULT_ANONYMITY_DOC) 
  RETURN INTEGER;

  --
  -- Description:    Check if a DICOM binary data is anonymous according to the 
  -- anonymity definition document. 
  -- Input:   
  --   src: The input DICOM binary data in the source BFILE.
  --   anonymityDocName: The name of the anonymity definition document.
  -- Return: 0: not anonymous, 
  --         1: anonymous.
  -- Exception:  None.
  --
  FUNCTION isAnonymous(
     src                    IN BFILE, 
     anonymityDocName   IN VARCHAR2 DEFAULT DEFAULT_ANONYMITY_DOC) 
  RETURN INTEGER;

  --
  -- Description:    Check if a DICOM binary data is anonymous according to the 
  -- anonymity definition document. 
  -- Input:   
  --   src: The input DICOM binary data in the source ORDImage object.
  --   anonymityDocName: The name of the anonymity definition document.
  -- Return: 0: not anonymous, 
  --         1: anonymous.
  -- Exception:  None.
  --
  FUNCTION isAnonymous(
     src                    IN ORDSYS.ORDImage, 
     anonymityDocName   IN VARCHAR2 DEFAULT DEFAULT_ANONYMITY_DOC) 
  RETURN INTEGER;

  -- 
  -- Description:    Check if a DICOM binary data conforms to a certain set of 
  -- constraint rules identified by the parameter constraintDocName.
  -- Input:   
  --   src: The input DICOM binary data in the source BLOB.
  --   constraintDocName: The name of the constraint. 
  -- Return: 0: invalid, 
  --         1: valid.
  -- Exception:  None.
  --
  FUNCTION isConformanceValid (
     src                IN BLOB,
     constraintName     IN VARCHAR2 
  ) RETURN INTEGER;
 
  -- 
  -- Description:    Check if a DICOM binary data conforms to a certain set of 
  -- constraint rules identified by the parameter constraintName.
  -- Input:   
  --   src: The input DICOM binary data in the source BFILE.
  --   constraintName: The name of the constraint. 
  -- Return: 0: invalid, 
  --         1: valid.
  -- Exception:  None.
  --
  FUNCTION isConformanceValid (
     src                IN BFILE,
     constraintName     IN VARCHAR2 
  ) RETURN INTEGER;

  -- 
  -- Description:    Check if a DICOM binary data conforms to a certain set of 
  -- constraint rules identified by the parameter constraintDocName.
  -- Input:   
  --   src: The input DICOM binary data in the source ORDImage object.
  --   constraintDocName: The name of the constraint. 
  -- Return: 0: invalid, 
  --         1: valid.
  -- Exception:  None.
  --
  FUNCTION isConformanceValid (
     src                IN ORDSYS.ORDImage,
     constraintName     IN VARCHAR2 
  ) RETURN INTEGER;

   --Name: getMappingXPath
   --Desc:  Returns the absolute xpath from the specified mapping document
   --Input: 
   --      tag     :  specifies a tag of the mapping document . 
   --                 This tag is a hexadecimal string  eg: '00110001'. 
   --                 The tag must be a simple tag  and not a wild card tag like 6011xx01
   --      docName :  specifies the name of a mapping document. 
   --                The default value is 'ordcmmp.xml'
   --      definerName: specifies the definer name of the tag in the mapping document. 
   --                  The default value is 'DICOM' which refers to the DICOM standard.
   -- Returns: The absolute xpath associated with the tag and definer in the 
   --          specified mapping document. 
   --          Null  - if the tag  is not associated with a path. 
  FUNCTION getMappingXpath(
           tag IN VARCHAR2, 
           docName IN VARCHAR2  DEFAULT 'ordcmmp.xml', 
           definerName IN VARCHAR2 DEFAULT 'DICOM') 
  RETURN VARCHAR2 DETERMINISTIC;                     

   --Name: getDictionaryTag
   --Desc: :  Lookup the standard and/or private dictionaries for the given tag name 
   --         and definer name and return a hexadecimal tag string. 
   --Input: 
   -- attributeName:  specifies the name of tag in the standard or private dictionary .
   --            eg: 'Patient's Name'
   -- definerName: specifies the definer name of the tag  in the standard 
   --              or private dictionary. The default value is 'DICOM' 
   --Returns: The hexadecimal tag string for the given tag name and definer name  
   --           The returned string will always be a  simple tag like 60116011.   
  FUNCTION  getDictionaryTag(  
               attributeName IN VARCHAR2, 
               definerName   IN VARCHAR2  DEFAULT 'DICOM' ) 
   return varchar2 DETERMINISTIC;

  --Name: setDataModel
  --Desc: Loads the default repository data model into sql and java  
  --Input: modelName - Only DEFAULT is supported in this release
  --Returns: None
  PROCEDURE  setDataModel(modelName IN VARCHAR2 DEFAULT 'DEFAULT');

  --Name: setDataModel with force option ( Not recommended)
 -- Desc: unconditionally refreshes the datamodel if force = 1.
  --Returns: None
  PROCEDURE  setDataModel(modelName IN VARCHAR2 DEFAULT 'DEFAULT'
                         , force in NUMBER);

 
END ORD_DICOM;
/
show errors;

