--
-- THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL
-- INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE
-- RELEASES.
-- THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
-- COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.
--

Rem
Rem $Header: ordim/src/server/sql/dcm/ordcrpsp.sql /main/7 2009/03/30 18:32:43 myalavar Exp $
Rem
Rem ordcrpsp.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      ordcrpsp.sql - Ord c(Dicom) r(repository) p (package) sp(spec)
Rem
Rem    DESCRIPTION
Rem      Defines an invoker rights package ORDSYS.ORD_DICOM_ADMIN
Rem      This package provide the admin interface for the dicom repository.
Rem    NOTES
Rem     
Rem    MODIFIED   (MM/DD/YY)
Rem    myalavar    03/25/09 - remove csid from importdatamodel
Rem    myalavar    02/23/09 - add zip file to import/exportDataModel
Rem    myalavar    02/05/09 - schema qualify names
Rem    myalavar    01/06/08 - add exportDataModel
Rem    myalavar    01/06/08 - add importDataModel
Rem    myalavar    09/11/08 - add generateTagListDoc()
Rem    myalavar    09/20/06 - abortDataModel -> rollbackDataModel
Rem    myalavar    07/11/06 - remove updateDocument 
Rem    myalavar    07/11/06 - add abortDataModel 
Rem    myalavar    04/04/06 - dicom repos package spec 
Rem    myalavar    04/04/06 - Created
Rem

create or replace package ORDSYS.ORD_DICOM_ADMIN
authid current_user
AS
  --
  -- public constants
  --
  DT_URL CONSTANT VARCHAR2(700) := 'xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0"';
 
  STORED_TAGLIST_DOC_SET CONSTANT VARCHAR2(64) :='USER';
  DMDL_DOC_SET           CONSTANT VARCHAR2(64) :='USER';

--==============================================================================
--loads a single document of the specified docType into repos
-- docName must be unique
--==============================================================================
 PROCEDURE insertDocument(
                docName IN VARCHAR2, 
                docType IN VARCHAR2, 
                xmlDoc XMLTYPE
           );


--==============================================================================
-- return the configuration document as an XMLType.
--docName uniquely identfies the document
--==============================================================================
 FUNCTION  getDocumentContent(docName IN VARCHAR2) return XMLTYPE;

 --==============================================================================
-- export the document to a file specfied by fileName in the location specfied 
-- by dirName is the directory object created  by 
-- create or replace directory command
-- the dirName must match the name listed in all_directories
 --==============================================================================
 PROCEDURE exportDocument(
             docName IN VARCHAR2, 
             dirName IN VARCHAR2, 
             fileName IN VARCHAR2
           );

--==============================================================================
-- Documents installed by Oracle cannot be removed
--delete of dictionary documents is not supported in this release
--==============================================================================
 PROCEDURE deleteDocument(docName IN VARCHAR2 ) ;

--==============================================================================
--   Starts the data model edits , locks the data model
--==============================================================================
 PROCEDURE editDataModel;

--==============================================================================
--    Commits changes and publishes the new data model
--    unlocks the data model
--==============================================================================
 PROCEDURE publishDataModel;

--==============================================================================
--    aborts the changes to the data model
--    unlocks the data model
--==============================================================================
 PROCEDURE rollbackDataModel;

--==============================================================================
--   Generates the STORED_TAG_LIST document as an XMLType
--   for the specified set of constraint and mapping documents in the repository
--   Useful for keeping the STORED_TAG_LIST in sync with the repos docs
--   args: docSet: the allowed values are 'ALL', 'ORACLE' 'USER'
--                The default value 'USER' is represented by the constant
--                 STORED_TAGLIST_DOC_SET
--
--==============================================================================
 FUNCTION generateTagListDocument(docSet in varchar2 default STORED_TAGLIST_DOC_SET) 
 return XMLType;

--==============================================================================
-- importDataModel: Imports the documents from a ZIP archive file in a
--                  specified Oracle directory into the repository. Use this 
--                  procedure to install OTN releases and updates. 
--                  This procedure can also be used to import a set of 
--                  documents that was exported using the exportDataModel()
--                  procedure. 
-- The OTN downloads contain a complete set of Oracle-defined documents and 
--  manifest document ordcmmft.xml. 
--
-- Note: All user-defined documents must be deleted from the repository
--      before calling this procedure this otherwise the procedures fails
--      with an ORA-53068 error.
--
-- The input document set can contain either complete set of Oracle-defined
-- documents or user defined documents or both.
--
-- Parameters: 
--  dirName   - The directory location of the ZIP archive file containing the
--             set of documents to be imported into the repository. 
--             This string is an Oracle directory object name, which is
--             case-sensitive. The default is uppercase. 
--             The write privilege must be granted to the administrator for
--             this directory object.
--  zipFileName - The name of the ZIP archive file containing the set of 
--                documents to be imported. This archive file can be downloaded
--                from OTN or generated by the exportDataModel() procedure.
--
--
-- Privileges:
--    The repository administrator must be granted read/write privileges on the 
--    directory object specified by dirName. 
--    For example:
--     grant read, write on directory EXAMPLEDIR to REPOSADMIN;
--
--    Java security: The repository administrator must be granted  
--    read, write, and delete FilePermissions on the directory containing the
--    zip file. These permissions must also be granted to ORDSYS. 
--    For example:
--      dbms_java.grant_permission( 'REPOSADMIN', 'SYS:java.io.FilePermission',
--                                  '/EXAMPLEDIR/*' , 'read,write,delete');
--      dbms_java.grant_permission( 'ORDSYS', 'SYS:java.io.FilePermission',
--                                  '/EXAMPLEDIR/*' , 'read,write,delete');
--    
--==============================================================================
 PROCEDURE importDataModel(dirName          in VARCHAR2,
                           zipFileName      in VARCHAR2); 

--==============================================================================
-- exportDataModel 
-- Description:
--  Exports the specified set of documents in the repository as a zip file
--  to the specified directory. The zip file  name is system generated
--  and has the format ordcm_reposdocs_<exportOption>_timestamp.zip
--
-- Params:
--   dirName - the name of the directory object that will contain the zip 
--             file.  
--   exportOption - specifies the set the documents to be exported.
--                  The default value is :'USER'.
--           USER   - only user-defined documents are exported. 
--           ALL    - all repository documents are exported.
--           ORACLE - only oracle-defined documents are exported.
--
-- Privileges:
--    The repository administrator must be granted read/write privileges on the 
--    directory object specified by dirName. 
--    For example:
--     grant read, write on directory EXAMPLEDIR to REPOSADMIN;
--
--    Java security: The repository administrator must be granted  
--    read, write, and delete FilePermissions on the directory containing the
--    zip file. These permissions must also be granted to ORDSYS. 
--    For example:
--      dbms_java.grant_permission( 'REPOSADMIN', 'SYS:java.io.FilePermission',
--                                  '/EXAMPLEDIR/*' , 'read,write,delete');
--      dbms_java.grant_permission( 'ORDSYS', 'SYS:java.io.FilePermission',
--                                  '/EXAMPLEDIR/*' , 'read,write,delete');
--    
--==============================================================================
 PROCEDURE exportDataModel(dirName          IN VARCHAR2, 
                           exportOption     IN VARCHAR2 default DMDL_DOC_SET);


END ORD_DICOM_ADMIN;
/
show errors;



