Rem
Rem $Header: ordcscsp.sql 28-jun-2006.12:12:59 fechen Exp $
Rem
Rem ordcscsp.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ordcscsp.sql - ORDDataSource object type specification 
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem     This object keeps itself consistent and is used just for DICOM for now.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    fechen      06/28/06 - add parallel_enable 
Rem    fechen      04/19/06 - Created
Rem

Rem **************************************************************************
Rem THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL
Rem INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE 
Rem RELEASES.
Rem THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
Rem COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.
Rem **************************************************************************


CREATE TYPE ORDDataSource 
TIMESTAMP '2006-04-19:10:56:00'
OID '11D050EC23AADB62E040578C750405AE'
AUTHID CURRENT_USER
AS OBJECT 
(
  --------------
  -- Attributes
  --------------
  --
  -- storage for data within oracle. Every operation 
  -- for the data stored in this field will be under
  -- the control of transaction within which the
  -- methods are called. This means that all the changes can
  -- either be commited or rolled back as desired by the
  -- user
  localData   BLOB,
  --
  --
  -- srcType, srcLocation and srcName are limited to 4K
  -- due to system limitation on the size of varchar2 field
  --
  -- srcType possible values: local or file. We don't support http for 
  -- this release.
  -- if srcType=local, data access should be through localData attribute
  --
  srcType     VARCHAR2(4000),
  srcLocation VARCHAR2(4000),
  srcName     VARCHAR2(4000),
  --
  -- updateTime maintains the time when the users update/change the object 
  --
  updateTime  DATE,
  ---------------
  -- Constructors
  ---------------
  --
  -- Constructor that creates the object from a specified source.
  -- By default an object of local source with empty lob is created. 
  --
  CONSTRUCTOR FUNCTION ORDDataSource(SELF IN OUT NOCOPY ORDDataSource,
                                     source_type IN VARCHAR2 DEFAULT 'local',
                                     source_location IN VARCHAR2 DEFAULT null,
                                     source_name IN VARCHAR2 DEFAULT null)
  RETURN SELF AS Result DETERMINISTIC,
  --
  -- Constructor that creates the object from a blob.
  --
  CONSTRUCTOR FUNCTION ORDDataSource(SELF IN OUT NOCOPY ORDDataSource,
                                     data IN BLOB)
  RETURN SELF AS Result DETERMINISTIC,
  ---------- 
  -- Methods 
  ----------
  --
  -- Return if the data is stored in the localData BLOB. This is determined by 
  -- looking srcType attribute if it is "local"
  --
  MEMBER FUNCTION  isLocal RETURN INTEGER DETERMINISTIC PARALLEL_ENABLE,
  --
  -- DATE RELATED METHODS
  --
  MEMBER FUNCTION  getUpdateTime RETURN DATE DETERMINISTIC PARALLEL_ENABLE,
  --
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDDataSource,
                                 current_time IN DATE DEFAULT SYSDATE),
  --
  -- SOURCE INFORMATION
  --
  -- Redefine the source, this will set the new updateTime.
  --
  MEMBER PROCEDURE setSourceInformation(SELF IN OUT NOCOPY ORDDataSource,
                                        source_type   IN VARCHAR2,
                                        source_location IN VARCHAR2,
                                        source_name     IN VARCHAR2),
  -- 
  -- Return the source information in the format of:
  -- srcType://srcLocation/srcName
  --
  MEMBER FUNCTION  getSourceInformation 
                   RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE,
  --
  -- Return the srcType attribute
  --
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE,
  --
  -- Return the srcLocation attribute. 
  --
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE,
  --
  -- Return the srcSourceName attribute. 
  --
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2 DETERMINISTIC PARALLEL_ENABLE,
  --
  -- Return BFILE. Throw error if srcType is not 'FILE'
  --
  MEMBER FUNCTION  getBFile RETURN BFILE DETERMINISTIC,
  --
  -- Return localData attribute 
  --
  MEMBER FUNCTION  getBLob RETURN BLOB DETERMINISTIC,
  --
  -- SOURCE CONTENT RELATED OPERATIONS
  --
  MEMBER FUNCTION  getContentLength RETURN INTEGER DETERMINISTIC PARALLEL_ENABLE,
  --
  -- SOURCE IMPORT/EXPORT OPERATIONS
  -- 
  -- Import data from an external source. If srcType is "local", throw error, 
  -- To avoid this error, user can call setSourceInfomation first. 
  -- After a successful import, srcType is set as "local" and updateTime
  -- is updated.
  --
  MEMBER PROCEDURE import( SELF     IN OUT NOCOPY ORDDataSource),
  --
  -- Export the data from database BLOB to an external source. 
  -- If srcType is not "local", throw error. 
  -- None of the object attributes will be affected by this method 
  -- so the SELF parameter is only IN.
  --
  MEMBER PROCEDURE export(SELF            IN ORDDataSource,
                          dest_type     IN VARCHAR2,
                          dest_location IN VARCHAR2,
                          dest_name     IN VARCHAR2)
) NOT FINAL;
/

show errors;
-- End ORDDataSource data and methods declaration

