Rem
Rem $Header: ordim/src/server/sql/doc/orddspec.sql /main/18 2009/03/17 11:19:11 fechen Exp $
Rem
Rem orddspec.sql
Rem
Rem Copyright (c) 2000, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      orddspec.sql - ORDDoc type specification
Rem
Rem    DESCRIPTION
Rem      this file describes the type ORDDoc. Should not be modified by 
REm      external customers.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    fechen      04/08/08 - add constructors
Rem    fechen      12/11/06 - remove pragma for getcontentlength 
Rem    smavris     01/30/03 - Change to create type
Rem    alandeck    01/31/01 - Removing openSource/closeSource due to overloadin
Rem    smavris     01/30/01 - Fix VARCHAR
Rem    alandeck    01/09/01 - Re-adding the openSource closeSource functions
Rem    smavris     01/05/01 - Fix setProperties
Rem    alandeck    10/18/00 - Adding open and close Source static functions
Rem    alandeck    10/12/00 - Fixing parameters for getProperties
Rem    smavris     10/11/00 - Replace missing methods
Rem    rchatter    07/14/00 - code review changes
Rem    rchatter    07/03/00 - Created
Rem


CREATE TYPE ORDSYS.ORDDoc
  TIMESTAMP '2001-01-08:11:44:00'
  OID '7A5EC5A0133253ABE034080020E5E21C'
  authid current_user
  AS OBJECT
(

   source   ORDSYS.ORDSource,
   format   VARCHAR2(80),
   mimeType VARCHAR2(80),
   contentLength integer,
   -- a place holder for annotations stored in the above attributes +
   -- anything which is not covered by the above fields, in a XML format.
   comments CLOB,

  -- USER-DEFINED CONSTRUCTORS
--
-- Description:  Construct an ORDDoc object from a BLOB
-- Parameters:
--   data:      BLOB
--   setProperties: integer of value 0 or 1, determines if setProperties
--                  method is called in the constructor.  
--
  CONSTRUCTOR FUNCTION ORDDoc(SELF IN OUT NOCOPY ORDSYS.ORDDoc, 
    data             IN BLOB, 
    setProperties IN INTEGER DEFAULT 0
  ) RETURN SELF AS RESULT,
--
--
-- Description: Construct an ORDDoc object from a specified source.
-- By default, an empty local ORDDoc object is created. 
-- Parameters:
--   source_type: the type of the source. 
--                Allowed value: LOCAL(default), FILE, HTTP
--   source_location: the location of the source.
--   source_name: the name of the source.
--   setProperties: integer of value 0 or 1, determines if setProperties
--                  method is called in the constructor.  
--
  CONSTRUCTOR FUNCTION ORDDoc(SELF IN OUT NOCOPY ORDSYS.ORDDoc, 
    source_type       IN VARCHAR2 DEFAULT 'LOCAL',
    source_location   IN VARCHAR2 DEFAULT NULL,
    source_name       IN VARCHAR2 DEFAULT NULL,
    setProperties  IN INTEGER DEFAULT 0
  ) RETURN SELF AS RESULT,
  --
  -- CONSTRUCTORS
  STATIC FUNCTION init RETURN ORDDoc,
  STATIC FUNCTION init( srcType IN VARCHAR2,
                        srcLocation IN VARCHAR2,
                        srcName IN VARCHAR2 ) RETURN ORDDoc,

  -- MIMETYPE RELATED METHODS
  MEMBER FUNCTION  getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setMimeType(mime IN VARCHAR2),



  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDDoc,
                                 current_time DATE),

  -- FORMAT RELATED METHODS
  MEMBER FUNCTION  getFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setFormat(knownFormat IN VARCHAR2),



  -- SOURCE RELATED METHODS
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDDoc),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDDoc),

  MEMBER PROCEDURE setSource(source_type     IN VARCHAR2,
                             source_location IN VARCHAR2,
                             source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSource RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSource, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),

  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),

  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDDoc, ctx IN OUT RAW,
				 setComments IN BOOLEAN),

  MEMBER FUNCTION getBFILE RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFILE, WNDS, WNPS, RNDS, RNPS),

  MEMBER PROCEDURE import(SELF IN OUT NOCOPY ORDDoc,
			  ctx IN OUT RAW, set_prop IN BOOLEAN),
  MEMBER PROCEDURE importFrom(SELF IN OUT NOCOPY ORDDoc,
			      ctx IN OUT RAW,
			      source_type IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name IN VARCHAR2,
			      set_prop IN BOOLEAN),

  MEMBER PROCEDURE export( SELF IN OUT NOCOPY ORDDoc,
                          ctx      IN OUT RAW,
			  source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),

  MEMBER FUNCTION openSource(SELF IN OUT NOCOPY ORDDoc,
                             userArg IN RAW,
			     ctx OUT RAW) RETURN INTEGER,

  MEMBER FUNCTION closeSource(SELF IN OUT NOCOPY ORDDoc,
		      	      ctx IN OUT RAW)
  RETURN INTEGER,

  MEMBER FUNCTION trimSource(SELF IN OUT NOCOPY ORDDoc, ctx IN OUT RAW,
                             newlen IN INTEGER) RETURN INTEGER,

  MEMBER PROCEDURE readFromSource(SELF IN OUT NOCOPY ORDDoc,
				  ctx IN OUT RAW,
                                  startPos IN INTEGER,
                                  numBytes IN OUT INTEGER,
                                  buffer OUT RAW),

  MEMBER PROCEDURE writeToSource(SELF IN OUT NOCOPY ORDDoc,
				 ctx IN OUT RAW,
                                 startPos IN INTEGER,
                                 numBytes IN OUT INTEGER,
                                 buffer IN RAW),



  MEMBER FUNCTION  getContentLength RETURN INTEGER,

  -- This method will copy data in the LOB provided, if the data is not
  -- stored in internal LOB it will be imported and returned in the LOB
  -- provided
  MEMBER PROCEDURE getContentInLob(SELF IN OUT NOCOPY ORDDoc,
                                   ctx IN OUT RAW,
                                   dest_lob IN OUT NOCOPY BLOB,
                                   mimeType OUT VARCHAR2,
                                   format OUT VARCHAR2),

  MEMBER FUNCTION  getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),

  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDDoc),

 -- source related methods
  MEMBER FUNCTION  processSourceCommand(
                            SELF      IN OUT NOCOPY ORDDoc,
                            ctx       IN OUT RAW,
                            cmd       IN VARCHAR2,
                            arguments IN VARCHAR2,
                            result    OUT RAW)
                   RETURN RAW,
  --
  --
  -- Static Methods for the relational functional interface
  STATIC PROCEDURE export(ctx             IN OUT RAW,
                          local_data      IN BLOB,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2,
                              format          OUT VARCHAR2,
                              mime_type       OUT VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 docBlob        IN BLOB,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format         IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx              IN OUT RAW,
                                 docBlob          IN BLOB,
                                 attributes       IN OUT NOCOPY CLOB,
                                 mimeType         OUT VARCHAR2,
                                 format           IN OUT VARCHAR2,
                                 contentLength    OUT INTEGER),
 --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 docBfile       IN OUT NOCOPY BFILE,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format         IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx                IN OUT RAW,
                                 docBfile           IN OUT NOCOPY BFILE,
                                 attributes         IN OUT NOCOPY CLOB,
                                 mimeType           OUT VARCHAR2,
                                 format             IN OUT VARCHAR2,
                                 contentLength      OUT INTEGER)
);
/
show errors;
