Rem
Rem $Header: ordimssp.sql 12-may-2006.12:12:08 smavris Exp $
Rem
Rem ordimssp.sql
Rem
Rem Copyright (c) 2003, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ordimssp.sql - ORDIM Signature Spec.
Rem
Rem    DESCRIPTION
Rem      This is the type specification for ORDImageSignature and specification
Rem      of package ORDImgSig_Pkg
Rem
Rem    NOTES
Rem      Till 10G production this code resided in ordispec.sql, along with the
Rem      type specification of ORDImage.  In 10G, an OID was added
Rem      to ORDImageSignature, and it was moved to separate file so
Rem      that type creation of ORDImageSignature can be called independently
Rem      of type creation of ORDImage.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smavris     05/12/06 - Remove grant to public with grant option (bug 
Rem                           5153275) 
Rem    mannamal    01/20/05 - Split type and package definition so latter can 
Rem                           be wrapped, clean up VIR stuff 
Rem    smavris     12/05/03 - Remove set echo 
Rem    mannamal    10/29/03 - mannamal_2305344_2 
Rem    mannamal    10/22/03 - Remove VIR compatible stuff 
Rem    mannamal    10/22/03 - Created
Rem

-- BEGIN ORDImageSignature data and method declaration

CREATE TYPE ORDImageSignature
TIMESTAMP '2003-06-10:13:37:00'
OID 'BFB197C6E9920382E034080020C8FA16'
authid current_user
AS OBJECT
(
  -- Signature of the image.  Contains color, texture
  -- and shape information of the image.  It is stored
  -- in a BLOB.

  signature BLOB,

-----------------------
-- METHOD DECLARATION

-- Makes the callout

STATIC FUNCTION init RETURN ORDImageSignature,

STATIC FUNCTION evaluateScore(sig1 IN ORDImageSignature,
                              sig2 IN ORDImageSignature,
			      weights IN VARCHAR2)
  RETURN FLOAT,

STATIC FUNCTION isSimilar(sig1 IN ORDImageSignature,
                          sig2 IN ORDImageSignature,
			  weights IN VARCHAR2,
			  threshold IN FLOAT)
  RETURN PLS_INTEGER,

MEMBER PROCEDURE generateSignature(SELF      IN OUT NOCOPY ORDImageSignature,
				   image     IN ORDImage)
);
/
show errors;

-- grant necessary permissions

grant execute on ORDImageSignature to public;


-- END ORDImageSignature data and method declaration


-- END ORDImageSignature DECLARATION SECTION

