Rem
Rem $Header: ordisits.sql 12-may-2006.12:00:14 smavris Exp $
Rem
Rem ordisits.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ordisits.sql - ORD Image STill Image Type Specification
Rem
Rem    DESCRIPTION
Rem      creates SI_stillImage type specifications.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smavris     05/12/06 - Remove public grant from ORDIMERRORCODES (bug 
Rem                           5153275) 
Rem    myalavar    03/31/03 - ora_clearFeatures -> SI_ClearFeatures
Rem                         - ora_initFeatures -> SI_InitFeatures
Rem                         - featuresExtracted_ora -> retainFeatures_SI
Rem                         - ora_featuresExtracted -> SI_retainFeatures
Rem    mannamal    11/26/02 - Change float to double precision
Rem    mannamal    11/08/02 - Add colorsList attribute to SI_StillIamge
Rem    myalavar    10/31/02 - myalavar_stillimage_fix_tkidisif_diff
Rem    myalavar    10/31/02 - Created
Rem


  ---------------------------------------------
-- SI_Color
-- Building block type for SI_Stillimage features
---------------------------------------------  
CREATE OR REPLACE TYPE SI_Color
  TIMESTAMP '2002-07-18:08:04:00'
  OID 'AD8992CB855C1EFAE0340003BA0F2AC7'
  AUTHID CURRENT_USER
  AS OBJECT
    (
      ---SI_Color Type attributes
     redValue   INTEGER,
     greenValue INTEGER,
     blueValue  INTEGER,
     --
     MEMBER PROCEDURE SI_RGBColor
     (SELF       IN OUT NOCOPY SI_Color,
      redValue   IN INTEGER,
      greenValue IN INTEGER,
      blueValue  IN INTEGER)
) INSTANTIABLE
NOT FINAL;
/
show errors;    
--End create type SI_Color

-- internal datatypes

-- Data Types used by object SI_ColorHistogram
-- The colorsList varray must be equal in size to colorFrequencyList  varray
-- The varray size is 108 and is represented by the constant
-- ORDSYS.ORDImageConstants.SI_MAXHISTOGRAMLENGTH.
-- 
  
CREATE or REPLACE TYPE colorsList AS VARRAY(100) of SI_Color;    
/
show errors;

create or replace type colorFrequenciesList as VARRAY(100) of DOUBLE PRECISION;
/
show errors;

create or replace type colorPositions as VARRAY(9) of SI_Color;
/
show errors;

create or replace type textureEncoding as VARRAY(5) of DOUBLE PRECISION;
/
show errors;


create or replace type flat_averageColor as VARRAY(3) of integer;
/
show errors;

create or replace type flat_colorPositions as VARRAY(27) of DOUBLE PRECISION;
/
show errors;





  
-- Type Declaration Section
--
-- The following types are declared in this file:
--SI_StillImage
--SI_Color
--SI_AverageColor
--SI_PositionalColor
--SI_ColorHistogram
--SI_Texture
--SI_FeatureList
--
--SI_Color type must be declared prior to all the other types
--All the other type use SI_Color type

 
CREATE OR REPLACE TYPE SI_StillImage
  TIMESTAMP '2002-07-18:08:04:00'
  OID 'AD8992CB855D1EFAE0340003BA0F2AC7'
  AUTHID CURRENT_USER
  AS OBJECT     
    (
     -- THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND
     --ITS EXTERNAL
     -- INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE
     -- RELEASES. THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
     -- COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.
     
     --Type attributes
     content_si           ORDSYS.ORDSOURCE,
     contentLength_si     INTEGER,
     format_si            VARCHAR2(4000),
     height_si            INTEGER,
     width_si             INTEGER,

     --ora attribute extensions
     mimeType_ora          VARCHAR2(4000),
     contentFormat_ora     VARCHAR2(4000),
     compressionFormat_ora VARCHAR2(4000),

     --Flag to
     retainFeatures_SI  INTEGER,

     --ora extension attributes to cache image features
     --use internal of image features to avoid circular reference
     --issues
     averageColorSpec_ora   SI_Color,
     colorsList_ora         colorsList,
     frequenciesList_ora    colorFrequenciesList,
     colorPositions_ora     colorPositions,
     textureEncoding_ora    textureEncoding,
     
    --
    --Constructors methods
    CONSTRUCTOR FUNCTION
    SI_StillImage(content IN BLOB) return SELF as RESULT DETERMINISTIC,
    --
    CONSTRUCTOR FUNCTION
    SI_StillImage( content IN BLOB, 
                   explicitFormat IN VARCHAR2  
                   ) return SELF as RESULT DETERMINISTIC,
    --
    CONSTRUCTOR FUNCTION
    SI_StillImage(content IN BLOB, 
                  explicitFormat IN VARCHAR2, 
                  height IN INTEGER, 
                  width IN INTEGER)  return SELF as RESULT DETERMINISTIC,
                     
                    
     --
     --Accessor methods for SI_ attributes
     MEMBER FUNCTION SI_height return INTEGER DETERMINISTIC,
     PRAGMA RESTRICT_REFERENCES(SI_height, WNDS, WNPS, RNDS, RNPS),

     MEMBER FUNCTION SI_width return INTEGER DETERMINISTIC,
     PRAGMA RESTRICT_REFERENCES(SI_width, WNDS, WNPS, RNDS, RNPS),

     MEMBER FUNCTION SI_format return VARCHAR2 DETERMINISTIC,
     PRAGMA RESTRICT_REFERENCES(SI_format, WNDS, WNPS, RNDS, RNPS),

     MEMBER FUNCTION SI_content return BLOB DETERMINISTIC,
     PRAGMA RESTRICT_REFERENCES(SI_content, WNDS, WNPS, RNDS, RNPS),

     MEMBER FUNCTION SI_contentLength return INTEGER DETERMINISTIC,
     PRAGMA RESTRICT_REFERENCES(SI_contentLength, WNDS, WNPS, RNDS, RNPS),

     --Accessor method of for retainFeatures_SI attribute
     MEMBER FUNCTION SI_retainFeatures return BOOLEAN DETERMINISTIC,
     PRAGMA RESTRICT_REFERENCES(SI_retainFeatures, WNDS, WNPS, RNDS, RNPS),

     --Image processing methods
     MEMBER PROCEDURE SI_setContent(SELF IN OUT NOCOPY SI_StillImage,
                                    content IN BLOB),
     MEMBER PROCEDURE SI_changeFormat(SELF IN OUT NOCOPY SI_StillImage, 
                                      targetFormat IN VARCHAR2),
     MEMBER FUNCTION SI_Thumbnail(SELF IN SI_StillImage)
                     return SI_StillImage DETERMINISTIC ,
                     
     MEMBER FUNCTION SI_Thumbnail(SELF IN SI_StillImage, 
                                  height IN INTEGER, 
                                  width IN INTEGER)
                     return SI_StillImage DETERMINISTIC,

     --Oracle extension for image feature caching
     --Extract image features and turn on image feature caching
     MEMBER PROCEDURE   SI_InitFeatures,

     --Resets image features attributes to null and stop
     --image feature caching
     MEMBER PROCEDURE   SI_ClearFeatures                     
                     
) INSTANTIABLE
NOT FINAL;
/
show errors;

--end create SI_StillImage type



--   ==========
--   SI_AverageColor SI_StillImage feature
--  ============
CREATE OR REPLACE TYPE SI_AverageColor
  TIMESTAMP '2002-07-18:08:04:00'
  OID 'AD8992CB855E1EFAE0340003BA0F2AC7'
  AUTHID CURRENT_USER
  AS OBJECT
    (
     --attributes
     SI_AverageColorSpec SI_Color,
     --
     --Methods
     CONSTRUCTOR FUNCTION SI_AverageColor
     (sourceImage IN SI_StillImage)
     return SELF AS RESULT DETERMINISTIC,

     --NOTE This constructor function OVERRIDE and HIDES the system DEFAULT
     --constructor.
     --The functions arguments names MUST match the attribute names
     CONSTRUCTOR FUNCTION SI_AverageColor
     (SI_AverageColorSpec IN SI_Color)
     return SELF AS RESULT DETERMINISTIC,
     --
     MEMBER FUNCTION SI_Score
     (SELF IN SI_AverageColor, image in SI_StillImage)
     RETURN DOUBLE PRECISION DETERMINISTIC
) INSTANTIABLE
  NOT FINAL;
/
show errors;    
     
--End create type SI_AverageColor



--   ==========
--   SI_ColorHistogram SI_StillImage feature
--  ============


CREATE OR REPLACE TYPE SI_ColorHistogram
  TIMESTAMP '2002-07-18:08:04:00'
  OID 'AD8992CB855F1EFAE0340003BA0F2AC7'
  AUTHID CURRENT_USER
  AS OBJECT
    (


   --IMPORTANT NOTE!!!!
   -- DO NOT change the order of the attributes
   -- DO NOT change the attribute names
   -- The third constructor function OVERRIDES and HIDES the SYSTEM DEFAULT
   -- constructor. This is done so that we can perform the necessary error
   -- checking to raise the appropriate error messages in the constructor
   -- 
   -- To do this the attribute names
   -- and order of the attributes must be exactly like it is defined here
     
     --attributes
     SI_ColorsList colorsList,
     --
     SI_frequenciesList colorFrequenciesList,
     --

   
     --Methods
     CONSTRUCTOR FUNCTION SI_ColorHistogram
     (sourceImage IN SI_StillImage)
     return SELF AS RESULT DETERMINISTIC ,
     --
      CONSTRUCTOR FUNCTION SI_ColorHistogram
       (firstColor IN SI_Color,
        frequency  IN DOUBLE PRECISION)
     return SELF AS RESULT DETERMINISTIC,

    
     --NOTE: This constructor OVERRIDES AND HIDES the system DEFAULT
     --constructor. The argument names MUST exactly match the attribute names 
      CONSTRUCTOR FUNCTION SI_ColorHistogram
       (SI_ColorsList       IN  colorsList,
        SI_frequenciesList  IN  colorFrequenciesList)
      return SELF AS RESULT DETERMINISTIC,
      
      MEMBER PROCEDURE SI_Append
      (SELF      IN OUT NOCOPY SI_ColorHistogram,
       color     IN SI_Color,
       frequency IN DOUBLE PRECISION),
      --
      MEMBER FUNCTION SI_Score
      (SELF  IN SI_ColorHistogram ,
       image IN SI_StillImage)
      RETURN DOUBLE PRECISION DETERMINISTIC
) INSTANTIABLE
  NOT FINAL;
/
show errors; 
   
-- End create type SI_ColorHistogram     

--===========
--   SI_PositionalColor SI_StillImage feature
--===============
CREATE OR REPLACE TYPE SI_PositionalColor
  TIMESTAMP '2002-07-18:08:04:00'
  OID 'AD8992CB85601EFAE0340003BA0F2AC7'
  AUTHID CURRENT_USER
  AS OBJECT
  (
     --attributes
     SI_ColorPositions  colorPositions,
     --
     --Methods
     CONSTRUCTOR FUNCTION SI_PositionalColor
     (sourceImage IN SI_StillImage)
     return SELF AS RESULT DETERMINISTIC,
     --
     MEMBER FUNCTION SI_Score
     (SELF  IN SI_PositionalColor,
      image IN SI_StillImage)
     RETURN DOUBLE PRECISION DETERMINISTIC
) INSTANTIABLE
  NOT FINAL;
/
show errors;

-- End create type SI_PositionalColor

--   ==========
--   SI_Texture SI_StillImage feature
--  ============
CREATE OR REPLACE TYPE SI_Texture
  TIMESTAMP '2002-07-18:08:04:00'
  OID 'AD8992CB85611EFAE0340003BA0F2AC7'
  AUTHID CURRENT_USER
  AS OBJECT
  (
     --attributes
     SI_TextureEncoding  textureEncoding,

     --Methods
     CONSTRUCTOR FUNCTION SI_Texture
     (sourceImage IN SI_StillImage)
     return SELF AS RESULT DETERMINISTIC,
     --
     MEMBER FUNCTION SI_Score
     (SELF  IN SI_Texture,
      image IN SI_StillImage)
     RETURN DOUBLE PRECISION DETERMINISTIC
) INSTANTIABLE
  NOT FINAL;
/
show errors;
--End create type SI_Texture


--   ==========
--   SI_FeatureList SI_StillImage feature
--  ============
CREATE OR REPLACE TYPE SI_FeatureList
  TIMESTAMP '2002-07-18:08:04:00'
  OID 'AD8992CB85621EFAE0340003BA0F2AC7'
  AUTHID CURRENT_USER
  AS OBJECT
  (
   --attributes
   --The attribute names have a _SI suffix instead of SI_ prefix
   --because RDBMS does not allows attributes name and function
   --name to be the same.
   --IMPORTANT NOTE!!!!
   -- DO NOT change the order of the attributes
   -- DO NOT change the attribute names
   -- This constructor functions OVERRIDES and HIDES the SYSTEM DEFAULT
   -- constructor. This is done so that we can perform the necessary error
   -- checking to raise the appropriate error message in the constructor
   -- 
   --  To do this the attribute names
   -- and order of the attributes must be exactly like it is defined here
   AvgClrFtr_SI         SI_AverageColor,
   AvgClrFtrWght_SI     DOUBLE PRECISION,
   ClrHstgrFtr_SI       SI_ColorHistogram,
   ClrHstgrFtrWght_SI   DOUBLE PRECISION,
   PstnlClrFtr_SI       SI_PositionalColor,
   PstnlClrFtrWght_SI   DOUBLE PRECISION,
   TextureFtr_SI        SI_Texture,
   TextureFtrWght_SI    DOUBLE PRECISION,
   --
   --NOTE: The arguments of this constructor function name MUST
   -- match the attribute names defined above to be able to OVERRIDE the
   --SYSTEM DEFAULT constructor.
   CONSTRUCTOR FUNCTION SI_FeatureList
     (AvgClrFtr_SI             IN  SI_AverageColor,
      AvgClrFtrWght_SI         IN  DOUBLE PRECISION,
      ClrHstgrFtr_SI           IN  SI_ColorHistogram,
      ClrHstgrFtrWght_SI       IN  DOUBLE PRECISION,
      PstnlClrFtr_SI           IN  SI_PositionalColor,
      PstnlClrFtrWght_SI       IN  DOUBLE PRECISION,
      TextureFtr_SI            IN  SI_Texture,
      TextureFtrWght_SI        IN  DOUBLE PRECISION)
     return SELF AS RESULT DETERMINISTIC,
     
     --
     MEMBER PROCEDURE SI_setFeature
     (SELF IN OUT NOCOPY SI_FeatureList,
     averageColorFeature         IN  SI_AverageColor,
     averageColorFeatureWeight    IN  DOUBLE PRECISION),
     --
     MEMBER PROCEDURE SI_setFeature
     (SELF IN OUT NOCOPY SI_FeatureList ,
     colorHistogramFeature        IN  SI_ColorHistogram,
     colorHistogramFeatureWeight  IN  DOUBLE PRECISION),
     --
     MEMBER PROCEDURE SI_setFeature
     (SELF IN OUT NOCOPY SI_FeatureList ,
     positionalColorFeature       IN  SI_PositionalColor,
     positionalColorFeatureWeight IN  DOUBLE PRECISION),
     --
     MEMBER PROCEDURE SI_setFeature
     (SELF IN OUT NOCOPY SI_FeatureList,
     textureFeature               IN  SI_Texture,
     textureFeatureWeight         IN  DOUBLE PRECISION),
     --
     MEMBER FUNCTION SI_Score
     (SELF  IN SI_FeatureList,
      image IN SI_StillImage)
       RETURN DOUBLE PRECISION DETERMINISTIC,
     --
     MEMBER FUNCTION SI_AvgClrFtr(SELF IN SI_FeatureList)
     RETURN SI_AverageColor DETERMINISTIC,
       PRAGMA RESTRICT_REFERENCES(SI_AvgClrFtr, WNDS, WNPS, RNDS, RNPS),
     --
     MEMBER FUNCTION SI_AvgClrFtrWght(SELF IN SI_FeatureList)
     RETURN DOUBLE PRECISION DETERMINISTIC,
       PRAGMA RESTRICT_REFERENCES(SI_AvgClrFtrWght, WNDS, WNPS, RNDS, RNPS),
     --
     MEMBER FUNCTION SI_ClrHstgrFtr(SELF IN SI_FeatureList)
     RETURN SI_ColorHistogram DETERMINISTIC,
       PRAGMA RESTRICT_REFERENCES(SI_ClrHstgrFtr, WNDS, WNPS, RNDS, RNPS),
     --
     MEMBER FUNCTION SI_ClrHstgrFtrWght(SELF IN SI_FeatureList)
     RETURN DOUBLE PRECISION DETERMINISTIC,
       PRAGMA RESTRICT_REFERENCES(SI_ClrHstgrFtrWght, WNDS, WNPS, RNDS, RNPS),
     --
     MEMBER FUNCTION SI_PstnlClrFtr(SELF IN SI_FeatureList)
     RETURN SI_PositionalColor DETERMINISTIC,
       PRAGMA RESTRICT_REFERENCES(SI_PstnlClrFtr, WNDS, WNPS, RNDS, RNPS),
     --
     MEMBER FUNCTION SI_PstnlClrFtrWght(SELF IN SI_FeatureList)
     RETURN DOUBLE PRECISION DETERMINISTIC,
       PRAGMA RESTRICT_REFERENCES(SI_PstnlClrFtrWght, WNDS, WNPS, RNDS, RNPS),
     --
     MEMBER FUNCTION SI_TextureFtr(SELF IN SI_FeatureList)
     RETURN SI_Texture DETERMINISTIC,
       PRAGMA RESTRICT_REFERENCES(SI_TextureFtr, WNDS, WNPS, RNDS, RNPS),
     --
     MEMBER FUNCTION SI_TextureFtrWght(SELF IN SI_FeatureList)
     RETURN DOUBLE PRECISION DETERMINISTIC,
       PRAGMA RESTRICT_REFERENCES(SI_TextureFtrWght, WNDS, WNPS, RNDS, RNPS)
     --  
) INSTANTIABLE
  NOT FINAL;
/
show errors;

-- End create type SI_FeatureList

---------------- GRANTS and PUBLIC SYNONYMS--------

-- make necessary grants to object types,  varray types
grant execute on SI_StillImage to public;
grant execute on SI_Color to public;
grant execute on SI_AverageColor to public;
grant execute on SI_ColorHistogram to public;
grant execute on SI_PositionalColor to public;
grant execute on SI_Texture to public;
grant execute on SI_FeatureList to public;
--varray types
grant execute on colorsList to public;
grant execute on colorFrequenciesList to public;
grant execute on textureEncoding to public;
grant execute on colorPositions to public;
grant execute on flat_averageColor to public;
grant execute on flat_colorPositions to public;

  --========== Create public synonyms for public object types
 CREATE OR REPLACE PUBLIC SYNONYM SI_Color
   for ORDSYS.SI_Color;

 CREATE OR REPLACE PUBLIC SYNONYM SI_StillImage
   for ORDSYS.SI_StillImage;
 
 CREATE OR REPLACE PUBLIC SYNONYM SI_AverageColor
   for ORDSYS.SI_AverageColor;
 
 CREATE OR REPLACE PUBLIC SYNONYM SI_ColorHistogram
   for ORDSYS.SI_ColorHistogram;
 
 CREATE OR REPLACE PUBLIC SYNONYM SI_PositionalColor
   for ORDSYS.SI_PositionalColor;
 
 CREATE OR REPLACE PUBLIC SYNONYM SI_Texture
   for ORDSYS.SI_Texture;

 CREATE OR REPLACE PUBLIC SYNONYM SI_FeatureList
   for ORDSYS.SI_FeatureList;
