CREATE OR REPLACE VIEW si_image_formats AS
  SELECT SI_FORMAT
  FROM ORDSYS.SI_image_formats_tab
  where read_flg = 'Y';
CREATE OR REPLACE VIEW si_image_format_conversions AS
SELECT a.SI_format SI_source_format, b.si_format SI_target_format
  FROM ORDSYS.SI_image_formats_tab a , ORDSYS.SI_image_formats_tab b
  where a.read_flg = 'Y'
  and b.write_flg = 'Y'
  and a.si_format <> b.si_format;
CREATE OR REPLACE VIEW si_thumbnail_formats AS
SELECT a.SI_format
  from ORDSYS.si_image_formats_tab a
  where a.write_flg = 'Y';
CREATE OR REPLACE view si_image_format_features as
SELECT a.si_format, b.si_feature_name
  from ORDSYS.si_image_formats_tab a, ORDSYS.si_features_tab b
  where a.read_flg = 'Y';
CREATE OR REPLACE view si_values as
select SI_value, SI_supported_Value
  from ordsys.SI_Values_tab;
  grant SELECT on ordsys.si_image_formats
    to public;
  grant SELECT on ordsys.si_image_format_conversions
    to public;
  grant SELECT on ordsys.si_thumbnail_formats
    to public;
  grant SELECT on ordsys.si_image_format_features
    to public;
  grant SELECT on ordsys.si_values
    to public;
alter session set current_schema="SI_INFORMTN_SCHEMA";
CREATE OR REPLACE  SYNONYM si_image_formats
  for ordsys.si_image_formats;
CREATE OR REPLACE  SYNONYM si_image_format_conversions
  for ordsys.si_image_format_conversions;
CREATE OR REPLACE  SYNONYM si_image_format_features
  for ordsys.si_image_format_features;
CREATE OR REPLACE  SYNONYM si_thumbnail_formats
  for ordsys.si_thumbnail_formats;
CREATE OR REPLACE  SYNONYM si_values
  for ordsys.si_values;
CREATE OR REPLACE  SYNONYM si_format_convrsns
  for ordsys.si_image_format_conversions;
CREATE OR REPLACE  SYNONYM si_image_frmt_ftrs
  for ordsys.si_image_format_features;
CREATE OR REPLACE  SYNONYM si_thumbnail_frmts
  for ordsys.si_thumbnail_formats;
alter session set current_schema="ORDSYS";
