--
-- THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL
-- INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE
-- RELEASES.  
-- THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
-- COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.
--
-- Copyright (c) 1996, 2009, Oracle and/or its affiliates.All rights reserved. 
--
-- NAME
-- ordispec.sql - ORDImage user-visible Specifications and packages
--
-- DESCRIPTION
-- MODIFIED (MM/DD/YY)
-- jiezhan   02/20/09 - schema qualified in applyWatermark methods
-- jiezhan   06/18/08 - add applyWatermark
-- fechen    04/08/08 - add constructors
-- rabbott   08/27/07 - merge alter into create clause
-- rabbott   08/27/07 - Compile spec only
-- rabbott   08/28/07 - compile specification only
-- dguo      08/30/04 - fix function naming 
-- mannamal  08/30/04 - remove migrate methods from ORDImgB and ORDImgF (part 
--                      of deprecation) 
-- rabbott   07/20/04 - Drop OUT from SELF in getMetadata 
-- dguo      05/14/04 - grabtrans 'mannamal_dicom_plsql_stub' 
-- mannamal  05/14/04 - Add PL/SQL wrappers for DICOM 
-- smavris   05/11/04 - Remove all but user-visible object types and packages
-- rabbott   05/03/04 - Add metadata functions 
-- mannamal  10/22/03 - Add OID to ORDImageSignature and seperate into a 
--                      different file 
-- smavris   01/30/03 - Change to create type
-- myalavar  09/26/02 - Remove public StillImage constants
-- myalavar  07/29/02 - Add SI_StillImage constants
-- mannamal  06/21/02 - Move grant privileges to create script
-- trowell   04/13/01 - Adding extra message text to Java calls
-- mannamal  03/22/01 - make indicator variables in sync
-- smavris   03/02/01 - Remove / after alter
-- mannamal  02/13/01 - Add indicator for VIR score sigs
-- smavris   02/12/01 - Remove blank line
-- alandeck  01/31/01 - Removing openSource/closeSource due to overloading prob
-- smavris   01/23/01 - Fix inconsistencies with i,a,d
-- alandeck  01/09/01 - Re-adding the openSource closeSource functions
-- smavris   01/05/01 - Make methods match documentation
-- mannamal  12/27/00 - update VIR_NUM_ATTR constant
-- alandeck  11/09/00 - adding missing NOCOPY for process
-- mannamal  11/09/00 - Add image constant for VIR
-- alandeck  10/18/00 - Adding open and close Source static functions
-- fechen    09/25/00 - Rename ExtCodec_Pkg to ORDImgExtCodec_Pkg.
-- fechen    09/07/00 - Add package ExtCodec_Pkg and methods in ORDImg_Pkg 
-- mannamal  10/30/00 - Add score to internal interface
-- mannamal  09/28/00 - Add PL/SQL internal interface for VIR compatibility
-- mannamal  09/21/00 - Add image matching constants
-- alandeck  08/25/00 - Adding relational interface
-- smavris   04/28/00 - Fix upgrade bug
-- dmullen   11/02/99 - Add static funtions to act as constructors
-- smavris   09/30/99 - Make it work with sqlplus
-- dmullen   08/17/99 - Fix alter type problem
-- dmullen   08/13/99 - Add alter type syntax for upgrade scenarios
-- dmullen   08/06/99 - set mimeType for headerless
-- dmullen   07/19/99 - More work with temp lobs
-- dmullen   07/15/99 - Add nocopy to ORDImage IN OUT params
-- rchatter  11/16/98 - ORDSource plugin changes
-- smavris   10/22/98 - Reorganize so we can invoke ordispec from upgrade scrip
-- smavris   10/09/98 - Add exception
-- smavris   10/07/98 - Add constants package
-- smavris   10/01/98 - Add invokers rights to package
-- smavris   09/30/98 - Add new exceptions
-- smavris   09/28/98 - Minor bug fixes
-- smavris   09/18/98 - Add exceptions
-- smavris   08/11/98 - Update for new api
-- smavris   08/11/98 - Update for new api
-- smavris   08/03/98 - Fix merged api
-- smavris   07/30/98 - Merge audio, video, image apis
-- smavris   07/30/98 - Converge audio,video,image apis
-- smavris   07/01/98 - Fix package
-- smavris   06/29/98 - Add pragmas so methods can be called in query
-- dbrown    05/27/98 - temp lob support
-- smavris   05/19/98 - Add accessor and check functions
-- smavris   05/14/98 - Add getMimeType, etc.
-- dmullen   04/17/98 - Add headerless image support
-- mannamal  01/14/98 - Updating version numbers to 8.0.5
-- dmullen   10/30/97 - Add OID to CREATE TYPE
-- ctrezza   08/22/97 - Adding disclaimer
-- trowell   07/09/97 - Update version
-- svivian   04/11/97 - remove ordimgF_copyContent in lieu of LOADFROMFILE
-- dmullen   04/07/97 - cosmetic version number change
-- dmullen   03/24/97 - Use new object type syntax
-- ctrezza   01/14/97 - Take out funarg
-- ctrezza   01/08/97 - Rewrap types using calls to package
-- bmichon   01/02/97 - change funarg to command
-- jsharma   12/26/96 - Incorporating ctrezza's changes to attribute and 
--                      function names
-- bmichon   11/03/96 - Added new methods for data i/o
-- bmichon   10/24/96 - Added compression attribute to type 
--                      Changed naming to reflect new packaging standard

-- bmichon   10/09/96 - Added BFILE support
-- bmichon   10/02/96 - Creation

--
-- The following types are declared in this file:
--    ORDImage
--
-- 
--

CREATE TYPE ORDSYS.ORDImage
  TIMESTAMP '1998-07-30:08:14:00'
  OID '34327E50C6C314AAE03400400B4066F3'
  authid current_user
  AS OBJECT
(
  -------------------
  -- TYPE ATTRIBUTES
  -------------------
  -- source
  --   Image source (ORDSource)
  -- height
  --   Height of the image in pixels 
  -- width
  --   Width of image in pixels
  -- contentLength
  --   Size of the on-disk image in bytes
  -- fileFormat
  --   File type of image (e.g., TIFF, JFIF) 
  -- contentFormat
  --   Type of image (e.g., monochrome, 8-bit Grayscale)
  -- compressionFormat
  --   Compression used in image
  -- mimeType
  --   Mime type of the image

  source              ORDSource,
  height              INTEGER,
  width               INTEGER,
  contentLength       INTEGER,
  fileFormat          VARCHAR2(4000),
  contentFormat       VARCHAR2(4000),
  compressionFormat   VARCHAR2(4000),
  mimeType            VARCHAR2(4000),
--
---------------------
-- METHOD DECLARATION
---------------------
--
  -- USER-DEFINED CONSTRUCTORS
--
-- Description:  Construct an ORDImage object from a BLOB
-- Parameters:
--   data:      BLOB
--   setProperties: integer of value 0 or 1, determines if setProperties
--                  method is called in the constructor.  
--
  CONSTRUCTOR FUNCTION ORDImage(SELF IN OUT NOCOPY ORDSYS.ORDImage, 
    data             IN BLOB, 
    setProperties IN INTEGER DEFAULT 0
  ) RETURN SELF AS RESULT,
--
--
-- Description: Construct an ORDImage object from a specified source.
-- By default, an empty local ORDImage object is created. 
-- Parameters:
--   source_type: the type of the source. 
--                Allowed value: LOCAL(default), FILE, HTTP
--   source_location: the location of the source.
--   source_name: the name of the source.
--   setProperties: integer of value 0 or 1, determines if setProperties
--                  method is called in the constructor.  
--
  CONSTRUCTOR FUNCTION ORDImage(SELF IN OUT NOCOPY ORDSYS.ORDImage, 
    source_type       IN VARCHAR2 DEFAULT 'LOCAL',
    source_location   IN VARCHAR2 DEFAULT NULL,
    source_name       IN VARCHAR2 DEFAULT NULL,
    setProperties  IN INTEGER DEFAULT 0
  ) RETURN SELF AS RESULT,
  --
  -- OLD CONSTRUCTORS
  STATIC FUNCTION init RETURN ORDImage,
  STATIC FUNCTION init( srcType IN VARCHAR2,
            srcLocation IN VARCHAR2,
            srcName IN VARCHAR2 ) RETURN ORDImage,
--
  -- IMAGE COPY METHOD
  MEMBER PROCEDURE copy(SELF IN OUT NOCOPY ORDImage,
                        dest IN OUT NOCOPY ORDImage),
--
  -- IMAGE PROCESSING RELATED METHODS
  MEMBER PROCEDURE process(SELF    IN OUT NOCOPY ORDImage,
                           command IN            VARCHAR2),
  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImage,
                               command IN            VARCHAR2, 
                               dest    IN OUT NOCOPY ORDImage),
-- 
  -- ADD WATERMARK
  MEMBER PROCEDURE applyWatermark(SELF    IN OUT NOCOPY ORDSYS.ORDImage,
                               added_text IN    VARCHAR2, 
                               dest    IN OUT NOCOPY ORDSYS.ORDImage,
                               logging OUT VARCHAR2,
                               watermark_properties IN ORDSYS.ORD_STR_LIST default null),

  MEMBER PROCEDURE applyWatermark(SELF     IN OUT NOCOPY ORDSYS.ORDImage,
                               added_image IN OUT NOCOPY ORDSYS.ORDImage,
                               dest    IN OUT NOCOPY ORDSYS.ORDImage,
                               logging OUT VARCHAR2,
                               watermark_properties IN ORDSYS.ORD_STR_LIST default null),

--
  -- IMAGE PROPERTY SET AND CHECK METHODS
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImage),
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImage,
                                 description IN VARCHAR2),
  MEMBER FUNCTION checkProperties RETURN BOOLEAN,
--
  -- IMAGE ATTRIBUTE ACCESSOR METHODS
  MEMBER FUNCTION getHeight RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getHeight, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getWidth RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getWidth, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getFileFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFileFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getContentFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getContentFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getCompressionFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionFormat, WNDS, WNPS, RNDS, RNPS), 
--
  -- METADATA RELATED METHODS
  MEMBER FUNCTION getMetadata(SELF          IN ORDImage,
                              metadataType  IN VARCHAR2 DEFAULT 'ALL') 
  RETURN SYS.XMLSEQUENCETYPE,
--
  MEMBER PROCEDURE putMetadata(SELF         IN OUT NOCOPY ORDImage,
                               xmlData      IN SYS.XMLType,
                               metadataType IN VARCHAR2 DEFAULT 'XMP',
                               encoding     IN VARCHAR2 DEFAULT 'UTF-8'),
--                    
  -- LOCAL RELATED METHODS
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDImage),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDImage),
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  --
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setUpdateTime(SELF         IN OUT NOCOPY ORDImage,
                                 current_time               DATE),
--
  -- MIMETYPE RELATED METHODS
  MEMBER FUNCTION  getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setMimeType(SELF IN OUT NOCOPY ORDImage,
                               mime IN            VARCHAR2),
--
  -- SOURCE/CONTENT RELATED METHODS
  MEMBER FUNCTION  getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION  getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getBFILE RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFILE, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDImage),
--
  MEMBER FUNCTION getDicomMetadata(SELF IN ORDImage,
                                    optionString  IN VARCHAR2) RETURN XMLType,
--
  MEMBER PROCEDURE setSource(SELF IN OUT NOCOPY ORDImage,
                             source_type     IN VARCHAR2,
                             source_location IN VARCHAR2,
                             source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSource RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSource, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER PROCEDURE import(SELF IN OUT NOCOPY ORDImage,
                          ctx IN OUT RAW),
  MEMBER PROCEDURE importFrom(
                          SELF IN OUT NOCOPY     ORDImage,
                          ctx             IN OUT RAW,
                          source_type     IN     VARCHAR2,
                          source_location IN     VARCHAR2,
                          source_name     IN     VARCHAR2),
  MEMBER PROCEDURE export(
                          SELF IN OUT NOCOPY     ORDImage,
                          ctx             IN OUT RAW,
                          source_type     IN     VARCHAR2,
                          source_location IN     VARCHAR2,
                          source_name     IN     VARCHAR2),
  --
  MEMBER FUNCTION  processSourceCommand(
                            SELF      IN OUT NOCOPY ORDImage,
                            ctx       IN OUT RAW,
                            cmd       IN VARCHAR2,
                            arguments IN VARCHAR2,
                            result    OUT RAW)
                   RETURN RAW,
  -- FILE OPERATIONS on the source
  MEMBER FUNCTION openSource(SELF IN OUT NOCOPY ORDImage, 
                             userArg IN RAW,
                             ctx  OUT RAW) RETURN INTEGER,
  --
  MEMBER FUNCTION closeSource(SELF IN OUT NOCOPY ORDImage, ctx IN OUT RAW) 
  RETURN INTEGER,
  --
  MEMBER FUNCTION trimSource(SELF IN OUT NOCOPY ORDImage, ctx IN OUT RAW, 
                             newlen IN INTEGER) RETURN INTEGER,
  --
  MEMBER PROCEDURE readFromSource(SELF IN OUT NOCOPY ORDImage,
                                  ctx IN OUT RAW,
                                  startPos IN INTEGER,
                                  numBytes IN OUT INTEGER,
                                  buffer OUT RAW),
  --
  MEMBER PROCEDURE writeToSource(SELF IN OUT NOCOPY ORDImage,
                                 ctx IN OUT RAW,
                                 startPos IN INTEGER,
                                 numBytes IN OUT INTEGER,
                                 buffer IN RAW),
  --
  -- Static Methods for the relational functional interface
  STATIC PROCEDURE export(ctx             IN OUT RAW,
                          local_data      IN BLOB,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2,
                              format          OUT VARCHAR2,
                              mime_type       OUT VARCHAR2),
  --
  STATIC PROCEDURE getProperties(imageBlob         IN BLOB,
                                 attributes        IN OUT NOCOPY CLOB,
                                 mimeType          OUT VARCHAR2,
                                 width             OUT INTEGER,
                                 height            OUT INTEGER,
                                 fileFormat        IN OUT VARCHAR2,
                                 contentFormat     OUT VARCHAR2,
                                 compressionFormat OUT VARCHAR2,
                                 contentLength     OUT INTEGER),
  --
  STATIC PROCEDURE getProperties(imageBlob         IN BLOB,
                                 attributes        IN OUT NOCOPY CLOB),
  --
  STATIC PROCEDURE getProperties(imageBfile       IN OUT NOCOPY BFILE,
                                 attributes        IN OUT NOCOPY CLOB,
                                 mimeType          OUT VARCHAR2,
                                 width             OUT INTEGER,
                                 height            OUT INTEGER,
                                 fileFormat        IN OUT VARCHAR2,
                                 contentFormat     OUT VARCHAR2,
                                 compressionFormat OUT VARCHAR2,
                                 contentLength     OUT INTEGER),
  --
  STATIC PROCEDURE getProperties(imageBfile       IN OUT NOCOPY BFILE,
                                 attributes        IN OUT NOCOPY CLOB),
  --
  STATIC FUNCTION getMetadata(imageBlob    IN BLOB,
                              metadataType IN VARCHAR2 DEFAULT 'ALL')
                  RETURN SYS.XMLSEQUENCETYPE,
  --
  STATIC FUNCTION getMetadata(imageBfile   IN BFILE,
                              metadataType IN VARCHAR2 DEFAULT 'ALL')
                  RETURN SYS.XMLSEQUENCETYPE,
  --
  STATIC PROCEDURE putMetadata(imageBlob    IN BLOB,
                               dest         IN OUT NOCOPY BLOB,
                               xmlData      IN SYS.XMLType,
                               metadataType IN VARCHAR2 DEFAULT 'XMP',
                               encoding     IN VARCHAR2 DEFAULT 'UTF-8'),
  --                      
  STATIC PROCEDURE putMetadata(imageBfile   IN BFILE,
                               dest         IN OUT NOCOPY BLOB,
                               xmlData      IN SYS.XMLType,
                               metadataType IN VARCHAR2 DEFAULT 'XMP',
                               encoding     IN VARCHAR2 DEFAULT 'UTF-8'),
  --                      
  STATIC PROCEDURE process(imageBlob IN OUT NOCOPY BLOB,
                           command IN VARCHAR2),
  --
  STATIC PROCEDURE processCopy(imageBlob IN BLOB,
                               command IN     VARCHAR2, 
                               dest    IN OUT NOCOPY BLOB),
  --
  STATIC PROCEDURE processCopy(imageBfile IN OUT BFILE,
                               command IN     VARCHAR2, 
                               dest    IN OUT NOCOPY BLOB),
  --
  STATIC PROCEDURE process(imageBlob     IN OUT NOCOPY BLOB,
                           command       IN VARCHAR2,
                           width         IN INTEGER,
                           height        IN INTEGER,
                           fileFormat    IN VARCHAR2,
                           contentFormat IN VARCHAR2,
                           compressionFormat IN VARCHAR2),
  --
  STATIC PROCEDURE processCopy(imageBlob IN BLOB,
                               command       IN VARCHAR2, 
                               dest          IN OUT NOCOPY BLOB,
                               width         IN INTEGER,
                               height        IN INTEGER,
                               fileFormat    IN VARCHAR2,
                               contentFormat IN VARCHAR2,
                               compressionFormat IN VARCHAR2),
  --
  STATIC PROCEDURE processCopy(imageBfile    IN OUT NOCOPY BFILE,
                               command       IN VARCHAR2, 
                               dest          IN OUT NOCOPY BLOB,
                               width         IN INTEGER,
                               height        IN INTEGER,
                               fileFormat    IN VARCHAR2,
                               contentFormat IN VARCHAR2,
                               compressionFormat IN VARCHAR2),
  --
  STATIC FUNCTION getDicomMetadata(imageBlob      IN BLOB,
                                   optionString IN VARCHAR2) RETURN XMLType,
  --
  STATIC FUNCTION getDicomMetadata(imageBfile     IN BFILE,
                                   optionString IN VARCHAR2) RETURN XMLType,
  --
  STATIC PROCEDURE applyWatermark(imageBlob     IN BLOB,
                               added_text       IN VARCHAR2, 
                               dest          IN OUT NOCOPY BLOB,
                               logging OUT VARCHAR2,
                               watermark_properties IN ordsys.ord_str_list default null),

  STATIC PROCEDURE applyWatermark(imageBlob     IN BLOB,
                               added_image      IN BLOB, 
                               dest          IN OUT NOCOPY BLOB,
                               logging OUT VARCHAR2,
                               watermark_properties IN ordsys.ord_str_list default null),

  STATIC PROCEDURE applyWatermark(imageBfile    IN OUT NOCOPY BFILE,
                               added_text       IN VARCHAR2, 
                               dest          IN OUT NOCOPY BLOB,
                               logging OUT VARCHAR2,
                               watermark_properties IN ordsys.ord_str_list default null),

  STATIC PROCEDURE applyWatermark(imageBfile    IN OUT NOCOPY BFILE,
                               added_image      IN OUT NOCOPY BFILE, 
                               dest          IN OUT NOCOPY BLOB,
                               logging OUT VARCHAR2,
                               watermark_properties IN ordsys.ord_str_list default null)

);
/
show errors;
-- END ORDImage type declaration

--
-- The ORDImageExceptions package is used to raise more meaningful
-- exception messages.
-- 

CREATE OR REPLACE PACKAGE ORDImageExceptions AS

  NULL_CONTENT                          EXCEPTION;
  NULL_PROPERTIES_DESCRIPTION           EXCEPTION;
  NULL_LOCAL_DATA                       EXCEPTION;
  NULL_DESTINATION                      EXCEPTION;
  DATA_NOT_LOCAL                        EXCEPTION;
  NULL_SOURCE                           EXCEPTION;
  INDEX_CREATE_STR_PARSE_ERR            EXCEPTION;
  DUPL_PARAM_STR                        EXCEPTION;
  THRESHOLD_OUT_OF_RANGE                EXCEPTION;
  INVALID_MIME_TYPE                     EXCEPTION;

END ORDImageExceptions;
/
show errors;
