Rem
Rem $Header: ordsrcsp.sql 28-aug-2007.06:15:48 rabbott Exp $
Rem
Rem ordsrcsp.sql
Rem
Rem Copyright (c) 1998, 2007, Oracle. All rights reserved.  
Rem  All Rights Reserved.
Rem
Rem    NAME
Rem      ordsrcsp.sql - ORD SouRCe SPecification
Rem
Rem    DESCRIPTION
Rem      ORD SouRCe SPecification
Rem          This object is a low level object, designed to be used
Rem          by other objects such as ORDAudio, ORDVideo etc. This 
Rem          object requires the users to maintain this in a consistent
Rem          state. e.g. if the data is imported into localData field
Rem          the user must set "local" field to indicate that.
Rem
Rem    NOTES
Rem      Being a low level object designed to help other objects, there
Rem      is no protocol imposed on users. Users must pick an appropriate
Rem      protocol for their applications and implement that with the
Rem      help of this object.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rabbott     08/27/07 - merge alter to create clause
Rem    fechen      11/16/06 - remove pragma restriction.
Rem    smavris     01/30/03 - Change to create type
Rem    smavris     04/11/01 - Update copyright
Rem    smavris     03/02/01 - Remove / after alter
Rem    dmullen     03/03/00 - Add simplified import to fix bug 949833
Rem    smavris     09/30/99 - Make it work with sqlplus
Rem    dmullen     08/17/99 - Add alter type for upgrade scripts
Rem    dmullen     07/20/99 - Fix temp lob leaks
Rem    rchatter    11/16/98 - rework source plugin context
Rem    alsrivas    08/26/98 - fixing attribute names
Rem    rchatter    08/12/98 - fixing interfaces
Rem    alsrivas    07/29/98 - adding new methods to make api more file like
Rem    rchatter    07/09/98 - fixing importFrom interface
Rem    alsrivas    06/11/98 - adding date field
Rem    alsrivas    06/08/98 - adding pragma
Rem    alsrivas    05/26/98 - adding timestamp and oid
Rem    alsrivas    05/25/98 - changes made per code review findings
Rem    alsrivas    05/11/98 - updating
Rem    alsrivas    04/27/98 - updating code for user-defined sources
Rem    alsrivas    03/27/98 - updating signatures per new spec
Rem    alsrivas    03/11/98 - updating ORDSource spec
Rem    alsrivas    01/14/98 - ORD SouRCe SPecification
Rem    alsrivas    01/14/98 - Created
Rem

CREATE TYPE ORDSource
TIMESTAMP '1998-06-25:12:08:00'
OID '2F1B4210A0E33FFEE03400400B4066F3'
authid current_user
AS OBJECT
(
-------------
-- Attributes
-------------

  -- storage for data within oracle. Every operation 
  -- for the data stored in this field will be under
  -- the control of transaction within which the
  -- methods are called. This means that all the changes can
  -- either be commited or rolled back as desired by the
  -- user
  localData   BLOB,

  --
  -- srcType, srcLocation and srcName are limited to 4K
  -- due to system limitation on the size of varchar2 field
  --
  srcType     VARCHAR2(4000),
  srcLocation VARCHAR2(4000),
  srcName     VARCHAR2(4000),

  -- updateTime maintains the time when the users updated either
  -- source or the object containing the source last. This attribute
  -- is not updated when import is called, but importFrom updates
  -- this method since the source information is changed.
  --
  -- For recoding updates when the top level objevt changes, users
  -- must call set method at appropriate time.
  updateTime  DATE,

  -- 1 or NULL means data is in LOB
  -- 0 means that the data is in external sources
  local       NUMBER,
  --
---------- 
-- Methods 
----------
  --
  -- METHODS RELATED TO 'local' FIELD 
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDSource),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDSource),
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  --
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDSource,
                                 current_time DATE),
  --
  -- SOURCE INFORMATION
  MEMBER PROCEDURE setSourceInformation(SELF IN OUT NOCOPY ORDSource,
                                        source_type   IN VARCHAR2,
                                        source_location IN VARCHAR2,
                                        source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSourceInformation 
                   RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceInformation, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getBFile RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFile, WNDS, WNPS, RNDS, RNPS),
  --
  -- SOURCE IMPORT/EXPORT OPERATIONS
  MEMBER PROCEDURE import(
                          SELF     IN OUT NOCOPY ORDSource,
                          ctx      IN OUT RAW,
                          mimetype OUT VARCHAR2,
                          format   OUT VARCHAR2),
  MEMBER PROCEDURE import(
                          SELF     IN OUT NOCOPY ORDSource,
                          ctx      IN OUT RAW,
                          dlob     IN OUT NOCOPY BLOB,
                          mimetype OUT VARCHAR2,
                          format   OUT VARCHAR2),
  MEMBER PROCEDURE importFrom( SELF            IN OUT NOCOPY ORDSource,
                               ctx             IN OUT RAW,
                               mimetype        OUT VARCHAR2,
                               format          OUT VARCHAR2,
                               source_type     IN VARCHAR2,
                               source_location IN VARCHAR2,
			       source_name     IN VARCHAR2),
  MEMBER PROCEDURE importFrom( SELF            IN OUT NOCOPY ORDSource,
                               ctx             IN OUT RAW,
                               dlob            IN OUT NOCOPY BLOB,
                               mimetype        OUT VARCHAR2,
                               format          OUT VARCHAR2,
                               source_type     IN VARCHAR2,
                               source_location IN VARCHAR2,
			       source_name     IN VARCHAR2),
  MEMBER PROCEDURE export(SELF            IN OUT NOCOPY ORDSource,
                          ctx             IN OUT RAW,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  -- SOURCE CONTENT RELATED OPERATIONS
  MEMBER FUNCTION  getContentLength(ctx IN OUT RAW) RETURN INTEGER,
  --
  MEMBER FUNCTION  getSourceAddress(ctx IN OUT RAW, 
                                    userData IN VARCHAR2) RETURN VARCHAR2,
  --
  MEMBER FUNCTION  getLocalContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getLocalContent, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE getContentInTempLob(
                                       SELF IN OUT NOCOPY ORDSource,
                                       ctx      IN OUT RAW,
                                       tempLob  IN OUT NOCOPY BLOB,
                                       mimetype OUT VARCHAR2,
                                       format   OUT  VARCHAR2,
                                       duration IN PLS_INTEGER := 10,
                                       cache    IN BOOLEAN := TRUE),
  MEMBER PROCEDURE deleteLocalContent,
  --
  -- SOURCE ACCESS METHODS
  MEMBER FUNCTION open(
                       SELF IN OUT NOCOPY ORDSource,
                       userArg IN RAW,
                       ctx OUT RAW) RETURN INTEGER,
  MEMBER FUNCTION close(
                       SELF IN OUT NOCOPY ORDSource,
                       ctx IN OUT RAW) RETURN INTEGER,
  MEMBER FUNCTION trim(SELF    IN OUT NOCOPY ORDSource,
                       ctx     IN OUT RAW, 
                       newlen  IN INTEGER) RETURN INTEGER,
  --
  -- CONTENT READ/WRITE OPERATIONS
  MEMBER PROCEDURE read(SELF     IN OUT NOCOPY ORDSource,
                        ctx      IN OUT RAW,
                        startPos IN     INTEGER,
                        numBytes IN OUT INTEGER,
                        buffer   OUT    RAW),
  MEMBER PROCEDURE write(SELF IN OUT NOCOPY ORDSource,
                         ctx      IN OUT RAW,
                         startPos IN INTEGER,
                         numBytes IN OUT INTEGER,
                         buffer   IN RAW),
  --
  -- SEND OFF ANY COMMAND TO THE EXTERNAL SOURCE PLUGIN
  MEMBER FUNCTION processCommand(
                      SELF    IN OUT NOCOPY ORDSource,
                      ctx     IN OUT RAW,
                      command IN VARCHAR2,
                      arglist IN VARCHAR2,
                      result  OUT RAW) RETURN RAW
  --
);
/
show errors;

