@echo off
REM
REM WINDOWS file
REM
REM $Header: opsm/cvutl/cluvfyrac.sbs /nt/6 2008/10/09 12:05:47 kfgriffi Exp $
REM
REM cluvfyrac.sbs
REM
REM Copyright (c) 2004, 2008, Oracle and/or its affiliates. All rights reserved.
REM
REM    NAME
REM      cluvfyrac.sbs 
REM
REM    DESCRIPTION
REM      This file gets copied into OH/bin as cluvfyrac.bat
REM
REM    NOTES
REM      This is a WINDOWS file
REM
REM

setlocal

REM Note: Because of the way windows sets exit status (i.e. ERRORLEVEL the
REM 'getcrshome.exe' command must be the last command within the 'if' 
REM statement. Because of this the status actually has to be in a second 
REM 'if' statement...

@set OHOME=%s_OracleHome%

if exist %OHOME%\opsm\admin\getcrshome.exe (

  %OHOME%\opsm\admin\getcrshome.exe>nul
)
if exist %OHOME%\opsm\admin\getcrshome.exe (
  REM If we did NOT encounter an error (i.e. status equal to 0) while getting
  REM the CRSHOME then use the CRSHOME found.

  if "%ERRORLEVEL%" EQU "0" (
    REM Assign the output of the getcrshome.exe image to CRSHOME

    for /f "tokens=1* delims=#" %%a in ('%OHOME%\opsm\admin\getcrshome.exe') do set CRSHOME=%%a

  )
)

if (%CRSHOME%)==() (
  @echo Unable to determine location of CRSHOME. Exiting...
  goto ERROR
)


CALL %CRSHOME%\bin\cluvfy %*
goto done

:ERROR
exit /B 1

:done

endlocal

