# 
# $Header: datapump_util.pl 23-may-2005.09:50:14 rgiroux Exp $
#
# datapump_util.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      datapump_util.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rgiroux     05/23/05 - update with MAINSA version
#    npamnani    04/14/05 - fix for bug 4115003; use tns connector and agent 
#    rgiroux     03/21/05 - fix for bug 4193463; use tns connector and agent 
#                           oracle home/sid when using DBI on NT 
#    ngade       04/28/04 - ngade_tts_0428
#    ngade       04/04/04 - tts support and cleanup
#    ngade       03/30/04 - Creation
# 

use strict;
use DBI qw(:sql_types);
use DBD::Oracle qw(:ora_types);
use vars qw($tns_connect);

## Set to debug DBI.
## DBI->trace(4);

#####################################
##   CONNECT DATABASE
#####################################
sub connect_database()
{
  $| = 1; # Flush Buffers 

  my($user, $password, $role, $job_name) = @_;
  my $mode = 0;

  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

  my $dbh;
  print_debug("Data Pump: Connecting to database with : user: $user role: $role\n");

  if(!$tns_connect)
  {
    $dbh = DBI->connect('dbi:Oracle:', "$user", "$password", 
                              {ora_session_mode => $mode,
                               PrintError => 0,
                               RaiseError => 0}) || &handle_db_error("C", $dbh, $job_name); 
  }
  else
  {
    $dbh = DBI->connect('dbi:Oracle:', "$user@".$tns_connect, "$password", 
                              {ora_session_mode => $mode,
                               PrintError => 0,
                               RaiseError => 0}) || &handle_db_error("C", $dbh, $job_name); 
  }

  print_debug("Data Pump: Database Connection Success\n");
  return $dbh;
}

#####################################
##   PREPARE STATEMENT
#####################################
sub prepare_statement()
{
  my ($dbh, $sql_stmt, $job_name) = @_;
  my $dbcur = $dbh->prepare($sql_stmt) || &handle_db_error("P", $dbh, $job_name);
  return $dbcur;
}

#####################################
##   EXECUTE STATEMENT
#####################################
sub execute_statement()
{
  my ($dbh, $dbcur, $job_name) = @_;
  $dbcur->execute || &handle_db_error("E", $dbh, $job_name, $dbcur);  
}

#####################################
##   DISCONNECT
#####################################
sub disconnect_database()
{
  my ($dbh) = @_;
  
  if(defined $dbh)
  {
    $dbh->disconnect();
  }
}

#####################################
##   HANDLE DATABASE ERRORS
#####################################
sub handle_db_error
{
  my($source,$dbh, $job_name, $dbcur) = @_;
  
  if ($source eq "E") 
  {
    my $erst = $dbh->errstr;
    print_debug("$job_name: $erst\n Database State: $DBI::state\n");  
    print STDOUT "Execute Failed: $erst\n";  
    $dbcur->finish();
    $dbh->disconnect();
     exit(1);
  } 
  elsif ($source eq "P") 
  {
    my $erst = $dbh->errstr;
    print_debug("$job_name: Prepare Failed: $erst\n");  
     print STDOUT "Prepare Failed: $erst\n";
    $dbh->disconnect();
     exit(1);
  } 
  elsif ($source eq "C") 
  {
    my $erst = "$DBI::errstr";  
    print_debug("$job_name: Connect Failed:$erst\n");  
     print STDOUT "Connect Failed: $erst\n";
     exit(1);
  }
}

#####################################
##   PRINTING STDOUT/STDERR
#####################################

sub print_debug
{  
  if(EMAGENT_isPerlDebugEnabled())
  {
     EMD_PERL_DEBUG(@_);
  }
  ## For perl testing Uncomment this line
  ## print STDOUT @_;
}

sub print_error
{
  EMD_PERL_ERROR(@_);
  ## For perl testing Uncomment this line
  ## print STDERR @_;  
}
1;
