# $Header: emdb/sysman/admin/scripts/db/dataUtilities/import.pl /st_emdbsa_11.2/1 2009/03/21 05:46:43 rasundar Exp $
#
# import.pl
#
# Copyright (c) 2002, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      import.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rasundar    03/18/09 - remove hardcoded password in test code
#    rgiroux     01/19/06 - fix for bug 4723890; re-read first foreign 
#                           language schema 
#    rgiroux     07/19/05 - 
#    rgiroux     07/08/05 - 
#    rgiroux     06/10/05 - make repeat_job a large parameter 
#    rgiroux     06/03/05 - add error messages 
#    rgiroux     05/27/05 - implement repeat_jobs 
#    rgiroux     05/04/05 - fix for bug 4345325; don't allow nonprived users 
#                           to turn on tracing 
#    ngade       04/07/05 - fix for 9i imp
#    rgiroux     02/28/05 - fix for bug 4193463; use tns connector and agent 
#                           oracle home/sid when using DBI on NT 
#    ngade       06/16/04 - add set_env_var for impdp 
#    ngade       04/01/04 - tts support and cleanup
#    ngade       09/19/03 - nt fix -bug 3134969 
#    npamnani    09/18/03 - fix for bug 3134969 
#    rgiroux     04/20/03 - fixes for bugs 2800243, 2842012, 2901592, 2889763, 2867716, 2867730, 2806861
#    ngade       02/21/03 - remove using perl from /usr/local/bin
#    ngade       01/31/03 - call set_env_vaset_env_var before doing import
#    ngade       01/17/03 - add support for db_10_or_higher
#    ngade       01/02/03 - remove read_datapump_output
#    ngade       11/13/02 - add 10i functionality
#    ngade       10/23/02 - remove checking for fileExecute permissions
#    ngade       09/23/02 - change support for lower-case users/tables
#    ngade       09/11/02 - update 10i jobsubmission
#    ngade       09/04/02 - support lower-case users/tables
#    ngade       08/29/02 - fix bug 2463124
#    ngade       08/08/02 - cleanup tempfiles
#    rgiroux     08/02/02 - rgiroux_start_10i_support
#    rgiroux     08/02/02 - Creation
#    ngade       06/26/02 - ngade_change_job_submission
#    ngade       06/26/02 - Creation
#

require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/dataUtilities/datapump_job.pl";

use strict;

## global variables.
use vars qw($oracle_home $oracle_sid $parse_errors $script $generate_log $use_english $log_file_name $smp_ignore $tns_connect $is_prived $repeat_job_script);

###################################################
##  MAIN SCRIPT TO CALL IMPORT JOB.
###################################################
sub import()
{
  print_debug("Data Pump Import: Started..........\n");
  my($user, $password, $role, $db_10_or_higher, $job_name) = @_;

  if(!defined($db_10_or_higher))
  {
    $db_10_or_higher = "FALSE";
  }

  &set_env_var($oracle_home, $oracle_sid, $db_10_or_higher);

  if($db_10_or_higher =~ /TRUE/i)
  {
    ## do 10i Import
    if($repeat_job_script)
    {
      my $SQLPID = open(SQL, "|$ENV{ORACLE_HOME}/bin/sqlplus -s /nolog");
      if(!$SQLPID)
      {
        print_error("ERROR: could not run SQLPLUS\n");
        exit (1);
      }
      print_debug("SQLPID = $SQLPID");
      my $userid = &set_userid($user, $password, $role);
      print SQL "connect $userid\n";
      print SQL "$repeat_job_script\n";
      print SQL "exit\n";
      close(SQL); 

      ## fall through here and start the datapump job
      ##  the repeat_job_script defines the job but doesn't start it (abort_step => -1)
      ##  in exactly the same was as a regular, one-time only job. that way we can use
      ##  all the same logging and error handling as we always have.
    }
  
    ## fix for bug 4193463; for tns connect use agent home/sid or DBI will fail
    if($tns_connect)
    {
      $oracle_home = $ENV{ORACLE_HOME};
      $oracle_sid = $ENV{ORACLE_SID};
      &set_env_var($oracle_home, $oracle_sid, $db_10_or_higher);
    }
    &start_datapump_job($user, $password, $role, $job_name);
  }
  else
  {    
    my $log_file = run_import(&set_userid($user, $password, $role));
    if($parse_errors =~ /TRUE/i)
    {
      &parse_log($log_file);
    }
  }
}


###################################################
##  SET DATABASE USERID
###################################################
sub set_userid()
{
  my($user, $password, $role) = @_;
  my $userid = $user."/".$password;
  my $userid = ($role =~ /NORMAL/i)? $userid: "$userid as $role";
  return $userid;
}

###################################################
##  PERFORM IMPORT OPERATION.
###################################################
sub run_import
{
  my ($userid) = @_;
  # Create a temporary File
  (my $param_fh, my $param_filename) =  create_temp_file();
  
  open(PARAM_FILE, ">$param_filename");
  print PARAM_FILE $script;
  close PARAM_FILE; 

  my $imp_exe = "$ENV{ORACLE_HOME}/bin/imp";
  my $command = "|$imp_exe PARFILE='$param_filename'";

  if($generate_log =~ /FALSE/i)
  {
    my ($log_fh, $log_file) = create_temp_file(".log");
    $command = $command." "."LOG=$log_file_name";
    close $log_fh;    
    $log_file_name = $log_file;
  }

  if($use_english =~ /TRUE/i)
  {
    $ENV{'NLS_LANG'} = "american_america.us7ascii";
  }

  print_debug("Data Pump Import: Command: $command\n");
  print_debug("Data Pump Import: generate_log:  $generate_log\n");
  print_debug("Data Pump Import: use_english:  $use_english\n");
  print_debug("Data Pump Import: log_file_name: $log_file_name\n");

  open(DATA_MGMT, $command)|| die "Couldn't execute $imp_exe";
  print DATA_MGMT "$userid\n"; 
  print DATA_MGMT "exit";
  close DATA_MGMT;

  close $param_fh;
  return $log_file_name;
}


###################################################
##  PARSE LOG FILE FOR ERRORS.
###################################################
sub parse_log()
{
  print_debug("Data Pump Import: Parsing logfile: $_[0]\n");

  if (-e $_[0])
  {
    open(LOGFILE, $_[0]) || die "Can't open :$!\n";
    my @cont_arr = <LOGFILE>;
    close LOGFILE;
    my $cont = "@cont_arr";

    if(($cont !~ /ORA-[0-9]/) && ($cont !~ /IMP-[0-9]/))
    {
      print_debug("Data Pump Import: No Errors\n");
    }
    elsif($cont =~ /IMP-00000/)
    {
      print_error("Data Pump Import: IMPORT ERROR[00000]\n");
      exit(1);
    }
    elsif($smp_ignore =~ /TRUE/i)
    {
      print_debug("Data Pump Import: SMP_IGNORE=TRUE\n");
    }
    else
    {
      print_debug("Data Pump Import: SMP_IGNORE = $smp_ignore\n");
      exit(1);
    }
  }
  else
  {
    print_error("Data Pump Import: File does not exist: $_[0].........");
    exit(1);
  }
}

###################################################
##  cli IMPORT TO CREATE A IMPORT JOB.
###################################################
sub impdp
{
  my $user;
  my $password;
  my $role;
  my $db_10_or_higher;
  my $dmpfile_format10g;
  
  ($db_10_or_higher, $script, $oracle_home, $oracle_sid, $user, $password, $role, $smp_ignore, $generate_log, $parse_errors, $log_file_name, $dmpfile_format10g) = @_;
  
  &set_env_var($oracle_home, $oracle_sid, $db_10_or_higher);
  print_debug("parse_errors: $parse_errors\n");
  if($db_10_or_higher =~ /TRUE/i && $dmpfile_format10g =~ /TRUE/i)
  {
    ## do 10g cli import
    print_debug("Data Pump Import: Running impdp Command Line\n");   
    my $userid = &set_userid($user, $password, $role);
      
    my $imp_exe = "$ENV{ORACLE_HOME}/bin/impdp";
    my $command = "|$imp_exe ". $script;
  
    open(DATA_MGMT, $command)|| die "Couldn't execute: $imp_exe";
    print DATA_MGMT "$userid\n"; 
    print DATA_MGMT "exit";
    close DATA_MGMT;

    if($parse_errors =~ /TRUE/i)
    {
      ## parse_log needs actual log file name.
      &parse_log($log_file_name);
    }
  }
  else
  {  
    ## call pre-10g import.
    &import($user, $password, $role);  
  }  
}

###################################################
##  TEST CASE FOR IMPORT.
## 1. Uncomment imptest(), modify any parameters.
## 2. set EMDROOT and run command
## 3. runperl import.pl
###################################################
##&imptest();
sub imptest()
{
  $oracle_home = $ENV{ORACLE_HOME};
  $oracle_sid = $ENV{ORACLE_SID};
  $script = " full=y, file=/tmp/expdat.dmp";
  $smp_ignore="true";
  $generate_log="false";
  $parse_errors="true";
  $log_file_name="/tmp/exp.log";
  
  my $db_user="SYSTEM";
  ### fill in your password here
  my $db_passwd="";
  my $db_role="NORMAL";
  
  &import($db_user, $db_passwd, $db_role);  
}

1;
