Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/emdowngrade.sql /st_emdbsa_11.2/2 2008/12/05 20:46:20 ysun Exp $
Rem
Rem emdowngrade.sql
Rem
Rem Copyright (c) 2006, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      emdowngrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ysun        11/17/08 - adding the CELL component
Rem    chyu        05/27/08 - adding the version matrix for 11.1 and 11.2
Rem    kvsingh     02/26/07 - 
Rem    chyu        01/23/07 - 
Rem    kvsingh     11/13/06 - Created
Rem

rem Parameters
define EMDW_HOME                       = "?"
define EM_REPOS_USER                   = "SYSMAN"
define EM_REPOS_MODE                   = "SYSAUX"
Rem derived variables
define EM_SQL_ROOT                     = "&EMDW_HOME/sysman/admin/emdrep/sql"

-- Contine on SQL errors
WHENEVER SQLERROR CONTINUE;

-- Mark the dbms_registry for EM component as downgrading.
DECLARE
  l_comp_name VARCHAR2(256);
BEGIN
  l_comp_name := 'EM';
  IF NOT ('&EM_REPOS_MODE' = 'CENTRAL') THEN
    EXECUTE IMMEDIATE 'BEGIN dbms_registry.downgrading(:1); END;' USING l_comp_name;
  END IF;
END;
/

ALTER SESSION SET CURRENT_SCHEMA=SYS;

variable pp_db_curr_version VARCHAR2(16);
variable  core_curr_version VARCHAR2(16);
variable  db_curr_version VARCHAR2(16);
variable  pp_curr_version VARCHAR2(16);
variable cell_curr_version VARCHAR2(16);

variable  core_prev_version  VARCHAR2(16);
variable  db_prev_version  VARCHAR2(16);
variable  pp_prev_version  VARCHAR2(16);
variable pp_db_prev_version  VARCHAR2(16);
variable cell_prev_version VARCHAR2(16);

DECLARE
  prev_ver VARCHAR2(16);
BEGIN
  BEGIN
    SELECT version INTO :core_curr_version 
      FROM &&EM_REPOS_USER..MGMT_VERSIONS
     WHERE component_name = 'CORE';
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      :core_curr_version := '0.0.0.0.0';
  END;
  BEGIN
    SELECT version INTO :db_curr_version 
      FROM &&EM_REPOS_USER..MGMT_VERSIONS
     WHERE component_name = 'DB';
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      :db_curr_version := '0.0.0.0.0';
  END;
  BEGIN
    SELECT version INTO :pp_curr_version 
      FROM &&EM_REPOS_USER..MGMT_VERSIONS
     WHERE component_name = 'PP';
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      :pp_curr_version := '0.0.0.0.0';
  END;
  BEGIN
    SELECT version INTO :pp_db_curr_version 
      FROM &&EM_REPOS_USER..MGMT_VERSIONS
     WHERE component_name = 'PP_DB';
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      :pp_db_curr_version := '0.0.0.0.0';
  END;
  BEGIN
    SELECT version INTO :cell_curr_version
      FROM &&EM_REPOS_USER..MGMT_VERSIONS
     WHERE component_name = 'CELL';
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      :cell_curr_version := '0.0.0.0.0';
  END;
  BEGIN
    SELECT prv_version INTO prev_ver
      FROM REGISTRY$
     WHERE cname = 'Oracle Enterprise Manager';
  END;
  IF substr(prev_ver, 1, 8) = '11.2.0.0' THEN
     :core_prev_version := '10.2.0.4.2';
     :db_prev_version   := '11.2.0.0.0';
     :pp_prev_version   := '10.2.0.4.2';
     :pp_db_prev_version:= '11.2.0.0.0';
     :cell_prev_version := '11.2.0.0.0';
  ELSIF prev_ver = '11.1.0.7.0' THEN
     :core_prev_version := '10.2.0.4.0';
     :db_prev_version   := '11.1.0.7.0';
     :pp_prev_version   := '10.2.0.4.0';
     :pp_db_prev_version:= '11.0.0.0.0';
     :cell_prev_version := '0.0.0.0.0';
  ELSE
     :core_prev_version := '0.0.0.0.0';
     :db_prev_version   := '0.0.0.0.0';
     :pp_prev_version   := '0.0.0.0.0';
     :pp_db_prev_version:= '0.0.0.0.0';
     :cell_prev_version := '0.0.0.0.0';
  END IF;
END;
/

col cell_curr_version new_v cell_curr_version;
select :cell_curr_version cell_curr_version from dual;
col cell_prev_version new_v cell_prev_version;
select :cell_prev_version cell_prev_version from dual;
col pp_db_curr_version new_v pp_db_curr_version;
select :pp_db_curr_version pp_db_curr_version from dual;
col pp_db_prev_version new_v pp_db_prev_version;
select :pp_db_prev_version pp_db_prev_version from dual;
col pp_curr_version new_v pp_curr_version;
select :pp_curr_version pp_curr_version from dual;
col pp_prev_version new_v pp_prev_version;
select :pp_prev_version pp_prev_version from dual;
col db_curr_version new_v db_curr_version;
select :db_curr_version db_curr_version from dual;
col db_prev_version new_v db_prev_version;
select :db_prev_version db_prev_version from dual;
col core_curr_version new_v core_curr_version;
select :core_curr_version core_curr_version from dual;
col core_prev_version new_v core_prev_version;
select :core_prev_version core_prev_version from dual;

ALTER SESSION SET CURRENT_SCHEMA=&&EM_REPOS_USER;

@&EM_SQL_ROOT/db/downgrade/cell_data_downgrade.sql &cell_curr_version &cell_prev_version

@&EM_SQL_ROOT/db/downgrade/pp_db_data_downgrade.sql &pp_db_curr_version &pp_db_prev_version

@&EM_SQL_ROOT/db/downgrade/pp_data_downgrade.sql &pp_curr_version &pp_prev_version

@&EM_SQL_ROOT/db/downgrade/db_data_downgrade.sql &db_curr_version &db_prev_version

@&EM_SQL_ROOT/db/downgrade/core_data_downgrade.sql &core_curr_version &core_prev_version

@&EM_SQL_ROOT/db/downgrade/cell_schema_downgrade.sql &cell_curr_version &cell_prev_version

@&EM_SQL_ROOT/db/downgrade/pp_db_schema_downgrade.sql &pp_db_curr_version &pp_db_prev_version

@&EM_SQL_ROOT/db/downgrade/pp_schema_downgrade.sql &pp_curr_version &pp_prev_version

@&EM_SQL_ROOT/db/downgrade/db_schema_downgrade.sql &db_curr_version &db_prev_version

@&EM_SQL_ROOT/db/downgrade/core_schema_downgrade.sql &core_curr_version &core_prev_version

DECLARE
  l_comp_name VARCHAR2(256);
  l_comp_ver  VARCHAR2(16);
BEGIN
  l_comp_name := 'EM';
  l_comp_ver  := '11.1.0.7.0';
  IF NOT ('&EM_REPOS_MODE' = 'CENTRAL') THEN
    EXECUTE IMMEDIATE 'BEGIN dbms_registry.downgraded(:1, :2); END;' USING l_comp_name, l_comp_ver;
  END IF;
END;
/

-- Reset the session back to SYS
ALTER SESSION SET CURRENT_SCHEMA=SYS;




