Rem
Rem $Header: empatch.sql 25-apr-2008.09:23:41 chyu Exp $
Rem
Rem empatch.sql
Rem
Rem Copyright (c) 2004, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      empatch.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Driver scripts for EM upgrade
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        04/11/08 - upping the version for RDBMS 11.2
Rem    chyu        04/04/07 - lrg 2908794: opting out the upgrade when the core
Rem                           version is at 10.2.0.3
Rem    gsbhatia    03/15/07 - bug 4069024
Rem    chyu        01/23/07 - adding additional versions
Rem    chyu        11/28/06 - adding the pre_upgrade_heuristics
Rem    gmanglik    10/20/06 - add pp_db component
Rem    kvsingh     08/06/06 - changing path from /pp/ to /db/
Rem    kvsingh     08/01/06 - bug 5405237
Rem    kvsingh     08/01/06 - bug 5405237
Rem    chyu        07/21/06 - modifying the version to 10.2.0.3 for dbcontrol 
Rem    chyu        07/13/06 - adding the 10.2.0.2 version to the upgrade path 
Rem    bmallipe    08/14/06 - chaging CORE version from 10.2.0.2.0 to
Rem                           10.2.0.3.0
Rem    bmallipe    08/11/06 - adding the patching scripts
Rem    chyu        08/03/06 - moving the derived files directory
Rem    chyu        06/26/06 - adding pre_data_upgrade and post_data_upgrade 
Rem                           scripts 
Rem    chyu        05/22/06 - this would only be appropriate for DBControl
Rem    rzazueta    07/27/04 - Set the status of EM component as VALID
Rem                           after upgrade
Rem    rpinnama    05/24/04 - Update the dbms_registry version of EM 
Rem    rpinnama    05/05/04 - Default user to SYSMAN 
Rem    rpinnama    04/23/04 - rpinnama_backport_10.1.0.2.0_3535007 
Rem    rpinnama    04/15/04 - Created
Rem

rem Parameters
define EMDW_HOME                       = "?"
define EM_REPOS_USER                   = "SYSMAN"

define EM_TABLESPACE_NAME              = "SYSAUX"
define EM_ECM_DEPOT_TABLESPACE         = "SYSAUX"
define EM_ECM_CSA_TABLESPACE_NAME      = "SYSAUX"
define EM_REPOS_MODE                   = "SYSAUX"

-- the following are no-op
-- needs to be here for compatibility issues
define EM_ECM_CSA_DATAFILE_NAME       = "NA"
define EM_ECM_CSA_DATAFILE_SIZE       = "NA"
define EM_ECM_CSA_DATAFILE_EXT_SIZE   = "NA"

Rem derived variables
define EM_SQL_ROOT                     = "&EMDW_HOME/sysman/admin/emdrep/sql"


-- Contine on SQL errors
WHENEVER SQLERROR CONTINUE;

-- The current Schema version for DBSA 11.2.0.0.0 in accordance to the
-- vob/component.xml is the following
-- CORE  : 10.2.0.4.2
--   PP  : 10.2.0.4.2
--   DB  : 11.2.0.0.0
-- PP_DB : 11.2.0.0.0
-- If any of the versions were changed, then, this piece of logic would need to be accordingly modified
-- Similarly to emupgrade.sql as well

COLUMN :script_name NEW_VALUE upgrade_script NOPRINT
 VARIABLE script_name VARCHAR2(256)
 DECLARE
  l_count number(16);
  BEGIN
    :script_name := '&EM_SQL_ROOT/emupgrade.sql';
    BEGIN
       select count(*) INTO l_count from all_users where upper(username)='&&EM_REPOS_USER';
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        l_count := 0;
    END;
    IF l_count = 0 THEN
      :script_name := '&EM_SQL_ROOT/core/latest/admin/admin_do_nothing.sql';
    ELSE
      BEGIN
        select count(*) INTO l_count from &&EM_REPOS_USER..MGMT_VERSIONS 
         where upper(COMPONENT_MODE)='&EM_REPOS_MODE' and 
               ((upper(COMPONENT_NAME)='CORE' and substr(version, 1,10) < '10.2.0.4.2')
                or
                (upper(COMPONENT_NAME)='PP' and substr(version, 1,10) < '10.2.0.4.2')
                or
                (upper(COMPONENT_NAME)='DB' and substr(version, 1,10) < '11.2.0.0.0')
                or
                (upper(COMPONENT_NAME)='PP_DB' and substr(version, 1,10) < '11.2.0.0.0')
               );
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
        l_count:=0;
      END;
      IF l_count = 0 THEN
        :script_name := '&EM_SQL_ROOT/core/latest/admin/admin_do_nothing.sql';
      END IF;
    END IF;
 END;
 /

SELECT :script_name FROM DUAL;
@&upgrade_script
