Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/emreposcre.sql /st_emdbsa_11.2/5 2009/08/09 21:18:14 spramani Exp $
Rem
Rem emreposcre.sql
Rem
Rem Copyright (c) 2003, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      emreposcre.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    spramani    08/08/09 - roll back the workaround merged in 8539394 for
Rem                           RDBMS bug 8489119
Rem    spramani    05/22/09 - incorporating changes required as in 8539394
Rem    ysun        11/17/08 - adding the CELL component
Rem    chyu        04/11/08 - upping the version for RDBMS 11.2
Rem    chyu        01/07/08 - upping the CORE and PP component version
Rem    gmanglik    10/20/06 - add pp_db component
Rem    kvsingh     08/07/06 - changing path from /pp/ to /db/
Rem    kvsingh     08/01/06 - bug 5405237
Rem    chyu        07/21/06 - modifying the version to 10.2.0.3 for dbcontrol 
Rem    chyu        07/18/06 - Backport chyu_bug-5305174 from 
Rem                           st_emcore_10.2.0.1.0 
Rem    bmallipe    08/14/06 - chaging CORE version from 10.2.0.2.0 to
Rem                           10.2.0.3.0
Rem    chyu        08/03/06 - moving the derived files directory
Rem    chyu        06/26/06 - making it component dependent 
Rem    chyu        05/15/06 - DBControl SA modification for 10.2 RepManager 
Rem    asaraswa    07/24/05 - adding csa tablespace 
Rem    rzazueta    12/10/04 - Pass EM_REPOS_USER to user_create_view_user.sql 
Rem    rzazueta    11/01/04 - Pass EM_REPOS_USER to core_sysaux_cre.sql 
Rem    rpinnama    09/24/04 - Donot connect during creation. 
Rem    rpinnama    09/23/04 - Remove references to version 
Rem    lhan        09/14/04 - add CM support
Rem    ajdsouza    08/09/04 - Moved component storage under core
Rem    ajdsouza    07/28/04 - Add storage component
Rem    ajere       01/19/04 - Call core_sysaux_init.sql instead of core_init.sql
Rem    rpinnama    12/12/03 - Fix bug 3296613: Dont call outofbox scripts here 
Rem    dsahrawa    12/07/03 - Grant execute on dbms_crypto package 
Rem    rzazueta    12/05/03 - Add calls to DBMS_REGISTRY package 
Rem    gan         11/14/03 - Avoid log passwd 
Rem    rpinnama    10/15/03 - No need to check for javavm 
Rem    rpinnama    07/26/03 - Remove exit at the end
Rem    rpinnama    07/25/03 - Use repos mode while creating repos user 
Rem    skini       07/25/03 - Disable java
Rem    rpinnama    07/11/03 - Create version details at the end
Rem    rpinnama    07/08/03 - Create only SYSAUX components in core
Rem    rpinnama    07/02/03 - Remove unnecessary checks
Rem    rpinnama    07/01/03 - Reduce the number of parameters
Rem    rpinnama    03/27/03 - Enable/Disable feedback/verify based on echo
Rem    rpinnama    03/27/03 - Check for non_existance of repos user
Rem    rpinnama    03/13/03 - rpinnama_createrep_updates
Rem    rpinnama    03/12/03 - Check for DBMS_SPOOL, LDAP, RLS and JAVAVM
Rem    rpinnama    03/11/03 - Load the java into repos user schema
Rem    rpinnama    02/27/03 - Created
Rem

rem Parameters
define EMDW_HOME                       = "&1"
define EM_REPOS_USER                   = "&2"
define EM_REPOS_PWD                    = "&3"
define EM_TEMP_TABLESPACE_NAME         = "&4"
define EM_ECHO_SQL                     = "&5"

define EM_TABLESPACE_NAME              = "SYSAUX"
define EM_ECM_DEPOT_TABLESPACE         = "SYSAUX"
define EM_ECM_CSA_TABLESPACE_NAME      = "SYSAUX"
define EM_REPOS_MODE                   = "SYSAUX"

Rem derived variables
define EM_SQL_ROOT                     = "&EMDW_HOME/sysman/admin/emdrep/sql"
define EM_LOADJAVA_ROOT                = "&EMDW_HOME/sysman/admin/emdrep/lib"
define EM_LOADER_JARFILE               = "emdloader.jar"


PROMPT
PROMPT Check if repos user already exists.
PROMPT
@&EM_SQL_ROOT/core/latest/admin/admin_check_repos_user.sql &EM_REPOS_USER NOT_EXISTS

PROMPT
PROMPT Create SYSMAN user.
PROMPT
@&EM_SQL_ROOT/core/latest/admin/admin_create_repos_user.sql &EM_REPOS_USER &EM_REPOS_PWD &EM_TABLESPACE_NAME &EM_TEMP_TABLESPACE_NAME &EM_REPOS_MODE &EM_ECHO_SQL 

PROMPT
PROMPT  Script to revoke DBA role from SYSMAN and grant required privileges
PROMPT
@&EM_SQL_ROOT/core/latest/admin/admin_grants_repos_user.sql &EM_REPOS_USER

EXECUTE	dbms_registry.loading('EM', 'Oracle Enterprise Manager', null, '&EM_REPOS_USER');

GRANT EXECUTE ON DBMS_REGISTRY to &EM_REPOS_USER;
GRANT EXECUTE ON DBMS_CRYPTO to &EM_REPOS_USER;

-- set the current schema to REPOS_USER
ALTER SESSION SET CURRENT_SCHEMA=&EM_REPOS_USER;

PROMPT
PROMPT Create core schema..
PROMPT
@&EM_SQL_ROOT/db/core_cre.sql

PROMPT
PROMPT Create db schema..
PROMPT
@&EM_SQL_ROOT/db/db_cre.sql

PROMPT
PROMPT Create pp schema..
PROMPT
@&EM_SQL_ROOT/db/pp_cre.sql

PROMPT
PROMPT Create pp_db schema..
PROMPT
@&EM_SQL_ROOT/db/pp_db_cre.sql

PROMPT
PROMPT Create cell schema..
PROMPT
@&EM_SQL_ROOT/db/cell_cre.sql 


PROMPT
PROMPT Recompile invalid objects...
PROMPT
@&EM_SQL_ROOT/core/latest/admin/admin_recompile_invalid.sql &EM_REPOS_USER

EXECUTE &EM_REPOS_USER..setEMUserContext('&EM_REPOS_USER',1);

PROMPT
PROMPT Initialize core..
PROMPT
@&EM_SQL_ROOT/db/core_init.sql

EXECUTE EMD_MAINTENANCE.SET_VERSION('CORE', '10.2.0.4.2', '10.2.0.4.2', '&EM_REPOS_MODE');

PROMPT
PROMPT Create MGMT_VIEW user..
PROMPT
@&EM_SQL_ROOT/core/latest/user_model/user_create_view_user.sql &EM_REPOS_PWD &EM_ECHO_SQL &EM_REPOS_USER


PROMPT
PROMPT Initialize DB..
PROMPT
@&EM_SQL_ROOT/db/db_init.sql

EXECUTE EMD_MAINTENANCE.SET_VERSION('DB', '11.2.0.0.0', '11.2.0.0.0', '&EM_REPOS_MODE');

PROMPT
PROMPT Initialize PP..
PROMPT
@&EM_SQL_ROOT/db/pp_init.sql

EXECUTE EMD_MAINTENANCE.SET_VERSION('PP', '10.2.0.4.2', '10.2.0.4.2', '&EM_REPOS_MODE');

PROMPT
PROMPT Initialize PP_DB..
PROMPT
@&EM_SQL_ROOT/db/pp_db_init.sql

EXECUTE EMD_MAINTENANCE.SET_VERSION('PP_DB', '11.2.0.0.0', '11.2.0.0.0', '&EM_REPOS_MODE');

PROMPT
PROMPT Initialize CELL..
PROMPT
@&EM_SQL_ROOT/db/cell_init.sql

EXECUTE EMD_MAINTENANCE.SET_VERSION('CELL', '11.2.0.0.0', '11.2.0.0.0', '&EM_REPOS_MODE');

/*
PROMPT
PROMPT Set repository version 
PROMPT
@&EM_SQL_ROOT/core/latest/admin/admin_set_repos_version.sql &EM_REPOS_MODE
*/

EXECUTE	dbms_registry.loaded('EM');
EXECUTE dbms_registry.valid('EM');

-- Reset the session back to SYS
ALTER SESSION SET CURRENT_SCHEMA=SYS;


PROMPT
PROMPT ==============  End of creation  ==============
PROMPT
