Rem
Rem $Header: emdb/source/oracle/sysman/emdrep/sql/emreposoutofbox.sql /st_emdbsa_11.2/1 2008/12/05 20:46:20 ysun Exp $
Rem
Rem emreposoutofbox.sql
Rem
Rem Copyright (c) 2003, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      emreposoutofbox.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ysun        11/17/08 - adding the CELL component
Rem    gmanglik    10/20/06 - add pp_db component
Rem    kvsingh     08/07/06 - changing path from /pp/ to /db/
Rem    kvsingh     08/01/06 - bug 5405237
Rem    chyu        07/18/06 - Backport chyu_bug-5305174 from 
Rem                           st_emcore_10.2.0.1.0 
Rem    chyu        08/03/06 - moving the derived files directory
Rem    chyu        06/26/06 - making it component dependent 
Rem    chyu        05/15/06 - DBControl SA modification for 10.2 RepManager 
Rem    nachen      10/12/04 - add EMD_REP_USER for db_outofbox 
Rem    rpinnama    09/24/04 - Connect as SYS and execute the out of box action 
Rem    mgoodric    12/15/03 - bug 3312919 
Rem    rpinnama    12/12/03 - Fix bug3296613: Guard against multiple 
Rem                           executions of outofbox 
Rem    rpinnama    10/27/03 - rpinnama_bug-3205102 
Rem    rpinnama    10/27/03 - Created
Rem

rem Parameters
define EMDW_HOME                       = "&1"
define EM_REPOS_USER                   = "&2"

Rem derived variables
define EM_SQL_ROOT                     = "&EMDW_HOME/sysman/admin/emdrep/sql"

Rem MetaLink credentials
define METALINK_USERNAME               = "_NOT_AVAILABLE_";
define METALINK_PASSWORD               = "_NOT_AVAILABLE_";
define METALINK_URL                    = "http://updates.oracle.com";

REM ======================================================
REM Check if the outofbox configuration is already done
REM Exit if the status is already configured.
REM ======================================================
WHENEVER SQLERROR EXIT;

DECLARE
  l_status NUMBER;
BEGIN
  l_status := &EM_REPOS_USER..EMD_MAINTENANCE.GET_COMP_STATUS('CORE');

  IF (l_status = &EM_REPOS_USER..EMD_MAINTENANCE.G_STATUS_CONFIGURED_READY) THEN
      RAISE_APPLICATION_ERROR(-20000, 
          'EM configuration (out-of-box) setup has already been performed.');
  END IF;
END;
/

ALTER SESSION SET CURRENT_SCHEMA=&EM_REPOS_USER;

WHENEVER SQLERROR CONTINUE;

REM ======================================================
REM Start the DBMS jobs
REM ======================================================
@&EM_SQL_ROOT/core/latest/admin/admin_submit_dbms_jobs.sql

PROMPT 
PROMPT Source repository variables..
PROMPT
Rem Source template first so that it will get default values..
@&EMDW_HOME/sysman/emdrep/config/repository.variables.template
@&EMDW_HOME/sysman/emdrep/config/repository.variables

PROMPT 
PROMPT Perform out-of-box config
PROMPT
@&EM_SQL_ROOT/db/core_outofbox.sql
@&EM_SQL_ROOT/db/db_outofbox.sql
@&EM_SQL_ROOT/db/pp_outofbox.sql
@&EM_SQL_ROOT/db/pp_db_outofbox.sql
@&EM_SQL_ROOT/db/cell_outofbox.sql

REM =====================================================
REM Record that the repository is configured and ready
REM =====================================================
EXECUTE EMD_MAINTENANCE.SET_COMP_STATUS('CORE', EMD_MAINTENANCE.G_STATUS_CONFIGURED_READY);
COMMIT;

ALTER SESSION SET CURRENT_SCHEMA=SYS;

PROMPT
PROMPT ==============  End of out-of-box setup  ==============
PROMPT

