Rem drv: <migrate type="schema_upgrade" version="10.2.0.2" />
Rem
Rem $Header: group_schema_upgrade.sql 17-feb-2006.10:57:59 rpatti Exp $
Rem
Rem group_schema_upgrade.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpatti      02/17/06 - schema upgrade required for bug 4608945 
Rem    rpatti      02/17/06 - Created
Rem

DECLARE
   l_object_name VARCHAR2(30);
BEGIN
  SELECT object_name
        INTO l_object_name
    FROM all_objects
   WHERE object_name = 'MGMT_GRP_CHART_DISP_TZ_ARRAY'
     AND owner = UPPER('&&EM_REPOS_USER')
     AND object_type = 'TYPE';

   EXECUTE IMMEDIATE 'drop type MGMT_GRP_CHART_DISP_TZ_ARRAY' ;

  -- if we gt here - then the object type also exists
  SELECT object_name
        INTO l_object_name
    FROM all_objects
   WHERE object_name = 'MGMT_GRP_CHART_DISP_TZ_OBJ'
     AND owner = UPPER('&&EM_REPOS_USER')
     AND object_type = 'TYPE';

   EXECUTE IMMEDIATE 'drop type MGMT_GRP_CHART_DISP_TZ_OBJ' ;

EXCEPTION
  WHEN NO_DATA_FOUND THEN
   NULL;
END;
/

create or replace type MGMT_GRP_CHART_DISP_TZ_OBJ as OBJECT (
    target_guid RAW(16),
    metric_guid RAW(16),
    key_value VARCHAR2(4000),
    target_name VARCHAR2(256),
    timezone_region VARCHAR2(64),
    time_stamp DATE,   -- store target systimestamp
    time_delta NUMBER  -- delta between group tz and target tz
);
/

create or replace type MGMT_GRP_CHART_DISP_TZ_ARRAY as TABLE of MGMT_GRP_CHART_DISP_TZ_OBJ;
/

