Rem
Rem $Header: lfm_fix_host_metadata.sql 23-mar-2006.08:58:47 ajayshar Exp $
Rem
Rem lfm_fix_host_metadata.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      host_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajayshar   03/20/06 - Reset the key order metrics for SunOS host and 
Rem                          reset is_renderable metrics for HP-UX
Rem                          (LogFileMonitoring Metric) <bug-5097695>
Rem    ajayshar   03/20/06 - Created.



BEGIN

  UPDATE MGMT_METRICS 
     SET key_order =DECODE(METRIC_COLUMN,'log_file_match_pattern',2,
                                         'log_file_ignore_pattern',3,
                                         'timestamp',4) 
   WHERE target_type     = 'host' 
     AND metric_name     = 'LogFileMonitoring'
     AND CATEGORY_PROP_1 = 'SunOS'
     AND METRIC_COLUMN IN ('log_file_match_pattern',
                           'log_file_ignore_pattern',
                           'timestamp');

  UPDATE MGMT_METRICS
     SET is_renderable=0 
   WHERE target_type     = 'host' 
     AND metric_name     = 'LogFileMonitoring' 
     AND CATEGORY_PROP_1 = 'HP-UX' 
     AND METRIC_COLUMN   = 'timestamp';
     
END;
/
