Rem Lists all the SunOS hosts whose metadata version is 3.0.

select target_name as "Solaris 3.0 Metadata Host"
  from mgmt_targets t,
       mgmt_metrics m
 where t.target_type = 'host'
   and t.target_type = m.target_type
   and t.type_meta_ver = '3.0'
   and t.type_meta_ver = m.type_meta_ver
   and m.metric_name = 'LogFileMonitoring'
   and m.metric_column = 'log_file_match_count'
   and t.category_prop_1 = 'SunOS'
   and m.category_prop_1 = t.category_prop_1
   and (m.category_prop_2 = ' ' or m.category_prop_2 = t.category_prop_2)
   and (m.category_prop_3 = ' ' or m.category_prop_3 = t.category_prop_3)
   and (m.category_prop_4 = ' ' or m.category_prop_4 = t.category_prop_4)
   and (m.category_prop_5 = ' ' or m.category_prop_5 = t.category_prop_5);
