Rem drv: <migrate type="data_upgrade" version="10.2.0.2"/>
Rem
Rem $Header: license_data_upgrade.sql 04-dec-2005.21:37:37 bram Exp $
Rem
Rem license_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      
Rem
Rem    NOTES
Rem      For Customers who are on 10.2 and who are upgrading to 10.2.0.2 this file will be called
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bram        12/04/05 - Created
Rem

@&EM_SQL_ROOT/core/10.2.0.2/license/license_post_creation.sql

--   Change Description for Bug-4777882--TARGET TYPE "SLB" TO BE ASSOCIATED WITH SMND PACK AND NOT SMS PACK
--   As a result of the change description,the pack_name need to be updated to <nd_smp> 
--    for all Rows in mgmt_licensed_targets which correspond to target_guid=<slb_target_guid>
--   1)get all target_guid from mgmt_targets whose target-type='slb' and those which have a matching entry in mgmt_licensed_targets
--      For each of the target_guid,Update mgmt_licensed_targets update pack_label='nd_smp' 
--   2) BEFORE UPDATE --ROW IN  MGMT_LICENSED_TARGETS
--       <target_guid> <pack_name> <from_target_guid>
--       <target_guid of slb> <storage_smp> <from_target_guid of slb>
--      AFTER UPDATE
--        <target_guid of slb> <nd_smp> <from_target_guid of slb>

DECLARE
    TYPE l_target_guid_table IS TABLE OF mgmt_targets.TARGET_GUID%TYPE INDEX BY BINARY_INTEGER;
         l_target_guid_arr l_target_guid_table;
BEGIN
    SELECT lic.target_guid
      BULK COLLECT 
      INTO l_target_guid_arr
      FROM mgmt_licensed_targets lic,mgmt_targets tar
     WHERE lic.target_guid=tar.target_guid
       AND tar.target_type='slb';

    IF (l_target_guid_arr IS NOT NULL) AND (l_target_guid_arr.count>0) THEN
        FOR i IN 1..l_target_guid_arr.count
            LOOP
                UPDATE MGMT_LICENSED_TARGETS
                   SET pack_name='nd_smp'
                 WHERE pack_name='storage_smp' AND
                       target_guid=l_target_guid_arr(i);
            END LOOP;
    END IF;
  COMMIT;
END;
/