Rem PLEASE DO NOT PUT ANY HEADERS HERE AS IT IS INVOKED FROM license_data_upgrade.sql
Rem $Header: license_post_creation.sql 09-dec-2005.02:20:05 bram Exp $
Rem
Rem license_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      For NEW customers this file will be called through license/license_post_creation.sql
Rem      For UPGRADE FROM 10.2 to 10.2.0.2 this will be called from license_data_upgrade.sql
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bram        12/04/05 - Created
Rem

DECLARE
    l_count NUMBER := 0;
BEGIN
      --Delete Entry for slb and sms association from mgmt_license_definitions
    SELECT  COUNT(1)
      INTO  l_count
      FROM  mgmt_license_definitions 
     WHERE  PACK_LABEL='storage_smp' 
       AND  TARGET_TYPE='slb' 
       AND  PACK_ABBR='SMS';

           IF l_count>0 THEN
               DELETE FROM  mgmt_license_definitions 
                 WHERE PACK_LABEL='storage_smp' 
                   AND TARGET_TYPE='slb' 
                   AND PACK_ABBR='SMS';
               COMMIT;
           END IF;
   
  --This block will create an association between slb and SMND
   
    em_license.add_pack_definitions
    (   
        p_pack_label         => 'nd_smp'  ,
        p_target_type        => 'slb'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Network Devices',
        p_pack_description   => 'The System Monitoring Plug-in for Network Devices provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for network devices</li></p>' ,
        p_pack_abbr          => 'SMND'
    );

  -- The description for the provisioning packs have changed, so putting
  -- the new descriptions here.

   em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Deployment Procedure Manager</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'oracle_ias'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Deployment Procedure Manager</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Deployment Procedure Manager</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Deployment Procedure Manager</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Deployment Procedure Manager</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );
    COMMIT;
END;
/

