Rem
Rem $Header: storage_ui_indexes.sql 16-dec-2005.17:24:35 ajdsouza Exp $
Rem
Rem storage_ui_indexes.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_ui_indexes.sql 
Rem
Rem    DESCRIPTION
Rem      indexes for tables in storage_ui_tables.sql
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajdsouza    12/16/05 - Backport ajdsouza_stg_bug_4880388_fix from main 
Rem    ajdsouza    12/12/05 - fixed bug#4880388 - removed ROWNUMcheck and added EXISTS
Rem    ajdsouza    11/28/05 - Created
Rem

-- index for the temporary table mgmt_storage_report_ui_targets
-- This index will get used when the number of entries in the
-- temporary table is large. We put target_name first simply
-- because we have queries with where clause having only
-- target_name. In such cases, this indexes could be a
-- candidate for the optimizer.

DECLARE

  e_object_exists     EXCEPTION;
  PRAGMA EXCEPTION_INIT(e_object_exists,-955);

BEGIN

    EXECUTE IMMEDIATE
     'CREATE INDEX mgmt_storage_ui_target_idx1 ON
      mgmt_storage_report_ui_targets
      (
        target_name, 
        target_type
      )';

EXCEPTION

   WHEN E_OBJECT_EXISTS THEN
    NULL;

   WHEN OTHERS THEN
    RAISE;

END;
/
