Rem drv: <migrate type="schema_upgrade" version="10.2.0.3" pos="bam/bam_tables.sql+"/>
Rem
Rem $Header: bam_indexes.sql 07-sep-2006.19:23:11 jthaniga Exp $
Rem
Rem bam_indexes.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      bam_indexes.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    skkunise    04/04/06 - Created
Rem

Rem
Rem Add Primary Keys and Indices to all tables
Rem


ALTER TABLE MGMT_BAM_DATA_HUBS
  ADD CONSTRAINT MGMT_BAM_DATA_HUBS_PK
    PRIMARY KEY (HUB_GUID);

CREATE UNIQUE INDEX MGMT_BAM_DATA_HUBS_IDX_01
  ON MGMT_BAM_DATA_HUBS (HUB_NAME);

ALTER TABLE MGMT_BAM_DATA_OSESSIONS
  ADD CONSTRAINT MGMT_BAM_DATA_OSESSIONS_PK
    PRIMARY KEY (SESSION_GUID);

ALTER TABLE MGMT_BAM_DATA_OSESSIONS
  ADD CONSTRAINT MGMT_BAM_DATA_OSESSIONS_FK
    FOREIGN  KEY (HUB_GUID)
    REFERENCES MGMT_BAM_DATA_HUBS (HUB_GUID);

CREATE INDEX MGMT_BAM_DATA_OSESSIONS_IDX_01
  ON MGMT_BAM_DATA_OSESSIONS (HUB_GUID);

CREATE UNIQUE INDEX MGMT_BAM_DATA_OSESSIONS_IDX_02
  ON MGMT_BAM_DATA_OSESSIONS (SESSION_NAME);

CREATE INDEX MGMT_BAM_OS_ALERTS_IDX_01
  ON MGMT_BAM_OSESSION_ALERTS (TARGET_GUID);

CREATE INDEX MGMT_BAM_OS_METRICS_IDX_01
  ON MGMT_BAM_OSESSION_METRICS (TARGET_GUID);

CREATE INDEX MGMT_BAM_OS_STATUS_IDX_01
  ON MGMT_BAM_OSESSION_STATUS (TARGET_GUID);

ALTER TABLE  MGMT_BAM_OSESSION_DIAG
  ADD  CONSTRAINT MGMT_BAM_OSESSION_DIAG_PK
    PRIMARY KEY (SESSION_GUID, DATA_TYPE);

ALTER TABLE MGMT_BAM_DATA_ISESSIONS
  ADD CONSTRAINT MGMT_BAM_DATA_ISESSIONS_PK
    PRIMARY KEY (SESSION_GUID);

ALTER TABLE MGMT_BAM_DATA_ISESSIONS
  ADD CONSTRAINT MGMT_BAM_DATA_ISESSIONS_FK
    FOREIGN  KEY (HUB_GUID)
    REFERENCES MGMT_BAM_DATA_HUBS (HUB_GUID);

CREATE INDEX MGMT_BAM_DATA_ISESSIONS_IDX_01
  ON MGMT_BAM_DATA_ISESSIONS (HUB_GUID);

CREATE UNIQUE INDEX MGMT_BAM_DATA_ISESSIONS_IDX_02
  ON MGMT_BAM_DATA_ISESSIONS (SESSION_NAME);

CREATE INDEX MGMT_BAM_DS_ISESSIONS_IDX_01
  ON MGMT_BAM_ISESSION_DATASOURCE (TARGET_GUID);

ALTER TABLE  MGMT_BAM_ISESSION_DATASOURCE
  ADD CONSTRAINT MGMT_BAM_ISESSION_DS_PK
    PRIMARY KEY (SESSION_GUID, DATASOURCE_NAME);

ALTER TABLE  MGMT_BAM_ISESSION_KPIS
  ADD CONSTRAINT MGMT_BAM_ISESSION_KPIS_PK
    PRIMARY KEY (SESSION_GUID, DATASOURCE_NAME, KPI_NAME);

ALTER TABLE  MGMT_BAM_ISESSION_DIAG
  ADD  CONSTRAINT MGMT_BAM_ISESSION_DIAG_PK
    PRIMARY KEY (SESSION_GUID, DATA_TYPE);
