Rem drv: <migrate type="data_upgrade" version="10.2.0.3"/>
Rem
Rem $Header: beacon_data_upgrade.sql 03-jul-2006.12:04:08 rmarripa Exp $
Rem
Rem beacon_data_upgrade.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmarripa    06/30/06 - Fix Beacon Wathlist thresholds format 
Rem    skkunise    02/15/06 - Add has_business property 
Rem    skkunise    02/15/06 - Created
Rem


BEGIN
DECLARE

  PROCEDURE add_prop_def(p_service_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2, p_property_name IN VARCHAR2)
  AS
  BEGIN
     dbms_output.put_line('adding props');
     BEGIN
        INSERT INTO mgmt_target_prop_defs(target_type, type_meta_ver,
                         property_name,
                         property_display_name, hidden_flag)
        VALUES(p_service_type, p_type_meta_ver, p_property_name, p_property_name, 1);
     EXCEPTION
        WHEN DUP_VAL_ON_INDEX THEN
            NULL;
     END;
  END; -- PROCEDURE add_prop_def

  PROCEDURE add_business_svc_prop_def(p_service_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2)
  AS
  BEGIN
     
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HAS_BUSINESS );
  END; --PROCEDURE add_business_svc_prop_def

  BEGIN
     --add property def for website target
     add_business_svc_prop_def(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '1.0');
     add_business_svc_prop_def(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '2.0');
     add_business_svc_prop_def(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '3.0');
     COMMIT;
  EXCEPTION
    WHEN OTHERS THEN
      ROLLBACK;
  END; -- for previous BEGIN block
END; --
/
show errors;

DECLARE
BEGIN

  -- Delete Beacon specific thresholds for beacon target type
  DELETE FROM mgmt_admin_metric_thresholds 
        WHERE target_guid in (SELECT target_guid
                                     FROM mgmt_targets
                                    WHERE target_type = mgmt_global.G_BEACON_TARGET_TYPE)
          AND key_value != emd_bcntxn.p_default_thresh_key;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
END;
/
SHOW ERRORS;

