Rem drv: <migrate type="pre_data_upgrade" version="10.2.0.3" />
Rem
Rem $Header: beacon_post_creation.sql 06-nov-2006.09:19:06 andyao Exp $
Rem
Rem beacon_post_creation.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    andyao      11/06/06 - fix bug 5633338, call create_metric with p_end_type_meta_ver
Rem    skkunise    02/16/06 - registering business metrics 
Rem    skkunise    02/16/06 - Created
Rem

BEGIN
DECLARE

PROCEDURE register_business_metric(p_target_type   IN VARCHAR2,
                                   p_type_meta_ver IN VARCHAR2)
AS 
  l_metric_col_list MGMT_METRIC_COLUMN_ARRAY :=  MGMT_METRIC_COLUMN_ARRAY();
  l_cat_array MGMT_CATEGORY_ARRAY := MGMT_CATEGORY_ARRAY();
  l_type_meta_ver MGMT_TARGETS.TYPE_META_VER%TYPE := p_type_meta_ver;
BEGIN

  -- Register business metric
  l_metric_col_list.extend(1);
  l_metric_col_list(1) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_BUSINESS_KEY_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                             p_column_label_nlsid => 'svc_business_metric_name',
                             p_short_name_nlsid => 'svc_business_metric_name',
                             p_is_key => 1);

  l_metric_col_list.extend(1);
  l_metric_col_list(2) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_BUSINESS_VALUE_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                             p_column_label_nlsid => 'svc_business_metric_value',
                             p_short_name_nlsid => 'svc_business_metric_value',
                             p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                             p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC);

  l_cat_array.extend(1);
  l_cat_array(1) := MGMT_CATEGORY_OBJ.NEW(mgmt_global.G_CATEGORY_CLASS_SERVICE,
                                          mgmt_global.G_SERVICE_CATEGORY_BUSINESS);

  BEGIN
    mgmt_metric.create_metric(p_target_type => p_target_type,
                              p_metric_name => MGMT_SERVICE.G_BUSINESS_METRIC_NAME,
                              p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                              p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                              p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC,
                              p_metric_label_nlsid => 'svc_business',
                              p_short_name_nlsid => 'svc_business',
                              p_type_meta_ver => p_type_meta_ver,
                              p_metric_column_list => l_metric_col_list,
                              p_category_list => l_cat_array,
                              p_is_transposed => 1,
                              p_is_repository => 1,
                              p_end_type_meta_ver => p_type_meta_ver,
                              p_keys_from_mult_colls => 1);
     exception when dup_val_on_index then
    null;
  END;

END register_business_metric;
  
BEGIN
  
   -- register business metrics to all versions of web site
   register_business_metric(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '1.0');
   register_business_metric(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '2.0');
   register_business_metric(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '3.0');


   COMMIT;

END;
END;
/
show errors;

