Rem drv: <migrate type="schema_upgrade" version="10.2.0.3"  condition="EM_REPOS_MODE=SYSAUX"/>
Rem
Rem $Header: beacon_schema_upgrade.sql 23-oct-2006.16:35:11 tlay Exp $
Rem $Header: beacon_schema_upgrade.sql 23-oct-2006.16:35:11 tlay Exp $
Rem
Rem beacon_schema_upgrade.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem     beacon_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem		Copied from beacon_indexes.sql for upgrade
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    tlay    10/19/06 - Created
Rem

DECLARE
BEGIN

-- Indices for MGMT_BCN_TARGET table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_TARGET
   ADD CONSTRAINT bcn_tgt_primary_key
       PRIMARY KEY (target_guid, beacon_target_guid)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indices for MGMT_BCN_AVAIL_DEF table
BEGIN
EXECUTE IMMEDIATE ' ALTER TABLE MGMT_BCN_AVAIL_DEF
   ADD CONSTRAINT bcn_avail_primary_key
       PRIMARY KEY (target_guid)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
 EXCEPTION
 	WHEN OTHERS THEN
        	NULL;
END;

-- Indices for MGMT_BCN_AVAIL_JOB table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_AVAIL_JOB
   ADD CONSTRAINT bcn_avail_job_primary_key
       PRIMARY KEY (target_guid)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

BEGIN
EXECUTE IMMEDIATE 'CREATE INDEX MGMT_BCN_AVAIL_JOB_IDX_02
  ON MGMT_BCN_AVAIL_JOB
     (insert_time)';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indices for MGMT_BCN_TXN_DEFN table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_TXN_DEFN
   ADD CONSTRAINT bcn_txn_primary_key
       PRIMARY KEY (target_guid, txn_guid, txn_type, name)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_TXN_DEFN
   ADD CONSTRAINT bcn_txn_name_unique_key
       UNIQUE (target_guid, name)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;




-- Indices for MGMT_BCN_STEP_DEFN table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_STEP_DEFN
   ADD CONSTRAINT bcn_txn_step_defn_primary_key
       PRIMARY KEY (target_guid, txn_guid, step_guid, step_type, name)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;



-- Indices for MGMT_BCN_STEPGROUP_DEFN table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_STEPGROUP_DEFN
   ADD CONSTRAINT bcn_group_defn_primary_key
        PRIMARY KEY (target_guid, txn_guid, stepgroup_guid, stepgroup_type, name)
      USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;



-- Indices for MGMT_BCN_STEPGROUP_STEPS table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_STEPGROUP_STEPS
   ADD CONSTRAINT bcn_group_steps_primary_key
       PRIMARY KEY (target_guid, txn_guid, stepgroup_guid, step_guid)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;


-- Indices for MGMT_BCN_TXN_AUDIT table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_TXN_AUDIT
   ADD CONSTRAINT bcn_txn_audit_primary_key
       PRIMARY KEY (target_guid, txn_guid, audit_timestamp)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;



-- Indices for MGMT_BCN_TXN_PROPS table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_TXN_PROPS
   ADD CONSTRAINT bcn_txn_props_primary_key
       PRIMARY KEY (target_guid, txn_guid, name, string_part)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;



-- Indices for MGMT_BCN_STEP_PROPS table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_STEP_PROPS
   ADD CONSTRAINT bcn_step_props_primary_key
       PRIMARY KEY (target_guid, step_guid, name, string_part)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;


-- Indices for MGMT_BCN_BCNTXN_PROPS table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_BCNTXN_PROPS
   ADD CONSTRAINT bcn_bcntxn_props_primary_key
       PRIMARY KEY (target_guid, txn_guid, bcn_guid, name, string_part)
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;


-- Indices for MGMT_BCN_BCNSTEP_PROPS table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_BCN_BCNSTEP_PROPS
   ADD CONSTRAINT bcn_bcnstep_props_primary_key
       PRIMARY KEY (target_guid, step_guid, bcn_guid, name, string_part)
          USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indices for MGMT_ADMIN_METRIC_THRESHOLDS table
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_ADMIN_METRIC_THRESHOLDS
   ADD CONSTRAINT ADMIN_METRIC_THRES_PRIM_KEY
       PRIMARY KEY (target_guid, metric_guid, coll_name, key_value)';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

BEGIN
EXECUTE IMMEDIATE 'CREATE INDEX MGMT_ADMIN_METRIC_THRES_IDX_02
  ON MGMT_ADMIN_METRIC_THRESHOLDS
     (metric_guid, key_value)';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;


-- Indices for MGMT_BCN_AVAIL_LOG table
BEGIN
EXECUTE IMMEDIATE 'CREATE INDEX MGMT_BCN_AVAIL_LOG_IDX
  ON MGMT_BCN_AVAIL_LOG
     (target_guid, severity_guid)';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_SUMMARY
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_SUMMARY
   ADD CONSTRAINT e2e_smry_primary_key
       PRIMARY KEY ( target_guid, collection_timestamp, uri, vhost )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_SUMMARY_1HOUR
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_SUMMARY_1HOUR
   ADD CONSTRAINT e2e_smry_1hr_primary_key
       PRIMARY KEY ( target_guid, rollup_timestamp, uri, vhost )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;


-- Indexes for MGMT_E2E_SUMMARY_1DAY
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_SUMMARY_1DAY
   ADD CONSTRAINT e2e_smry_1dy_primary_key
       PRIMARY KEY ( target_guid, rollup_timestamp, uri, vhost )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_DETAILS
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_DETAILS
   ADD CONSTRAINT e2e_deta_primary_key
       PRIMARY KEY ( target_guid, collection_timestamp, uri, node_type,
                     node_id, key_guid, parent_key_guid, app_id, vhost )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_DETAILS_1HOUR
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_DETAILS_1HOUR
   ADD CONSTRAINT e2e_deta_1hr_primary_key
       PRIMARY KEY ( target_guid, rollup_timestamp, uri, node_type,
                     node_id, key_guid, parent_key_guid, app_id, vhost )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_DETAILS_1DAY
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_DETAILS_1DAY
   ADD CONSTRAINT e2e_deta_1dy_primary_key
       PRIMARY KEY ( target_guid, rollup_timestamp, uri, node_type,
                     node_id, key_guid, parent_key_guid, app_id, vhost )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_SQL
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_SQL
   ADD CONSTRAINT e2e_sql_primary_key
       PRIMARY KEY ( target_guid, collection_timestamp, uri, key_guid, vhost, app_id )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_SQL_1HOUR
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_SQL_1HOUR
   ADD CONSTRAINT e2e_sql_1hr_primary_key
       PRIMARY KEY ( target_guid, rollup_timestamp, uri, key_guid, vhost, app_id )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_SQL_1DAY
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_SQL_1DAY
   ADD CONSTRAINT e2e_sql_1_dy_primary_key
       PRIMARY KEY ( target_guid, rollup_timestamp, uri, key_guid, vhost, app_id )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_JDBC
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_JDBC
   ADD CONSTRAINT e2e_jdbc_primary_key
       PRIMARY KEY ( target_guid, collection_timestamp, uri, key_guid, vhost, app_id )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_JDBC_1HOUR
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_JDBC_1HOUR
   ADD CONSTRAINT e2e_jdbc_1hr_primary_key
       PRIMARY KEY ( target_guid, rollup_timestamp, uri, key_guid, vhost, app_id )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_JDBC_1DAY
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_JDBC_1DAY
   ADD CONSTRAINT e2e_jdbc_1_dy_primary_key
       PRIMARY KEY ( target_guid, rollup_timestamp, uri, key_guid, vhost, app_id )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_SQL_STMT
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_SQL_STMT
   ADD CONSTRAINT e2e_sql_stmt_primary_key
       PRIMARY KEY ( stmt_guid, part_no, target_guid )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

BEGIN
EXECUTE IMMEDIATE 'CREATE INDEX MGMT_E2E_SQL_STMT_IDX01
  ON MGMT_E2E_SQL_STMT
     ( target_guid, ttl_ref )
  INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

-- Indexes for MGMT_E2E_SQL_CONN
BEGIN
EXECUTE IMMEDIATE 'ALTER TABLE MGMT_E2E_SQL_CONN
   ADD CONSTRAINT e2e_sql_conn_primary_key
       PRIMARY KEY ( conn_guid, target_guid )
       USING INDEX STORAGE
                (FREELISTS 4)
                INITRANS 4';
EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

BEGIN
EXECUTE IMMEDIATE 'CREATE INDEX MGMT_E2E_SQL_CONN_IDX01
  ON MGMT_E2E_SQL_CONN
     ( target_guid, ttl_ref )
  INITRANS 4';
  EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

EXCEPTION
	WHEN OTHERS THEN
        	NULL;
END;

/
