Rem PLEASE DO NOT PUT ANY HEADER TO THIS FILE
Rem
Rem $Header: blackout_tables.sql 19-sep-2006.05:50:25 kannatar Exp $
Rem
Rem blackout_tables.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      blackout_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sbhagwat   09/18/06 - Creation
Rem

REM
REM PURPOSE
REM
REM This table is used to keep the backup of availability records that the rbk
REM has modified. It also holds link to reason id for the rbk, if it was specified.
REM
CREATE TABLE MGMT_AVAILABILITY_RBK
(
    TARGET_GUID RAW(16) NOT NULL,
    RBK_GUID RAW(16) NOT NULL,
    SEVERITY_GUID RAW(16),
    CURRENT_STATUS NUMBER NOT NULL,
    START_COLLECTION_TIMESTAMP DATE NOT NULL,
    END_COLLECTION_TIMESTAMP DATE,
    REASON_ID NUMBER,
    CREATE_TIMESTAMP DATE DEFAULT SYSDATE,
    CONSTRAINT PK_MGMT_AVAILABILITY_RBK PRIMARY KEY(TARGET_GUID,RBK_GUID, CURRENT_STATUS, START_COLLECTION_TIMESTAMP)
)MONITORING;

COMMENT ON TABLE  MGMT_AVAILABILITY_RBK IS
    'This table stores availability back data that is going to be changed due to RBK. ';
    
COMMENT ON COLUMN  MGMT_AVAILABILITY_RBK.TARGET_GUID IS
    'Stores the target guid';    

COMMENT ON COLUMN  MGMT_AVAILABILITY_RBK.RBK_GUID IS
    'Stores the Retroactive blackout guid';    
    
COMMENT ON COLUMN  MGMT_AVAILABILITY_RBK.SEVERITY_GUID IS
    'Stores the Severity guid of the priginal availability table';     
    
COMMENT ON COLUMN  MGMT_AVAILABILITY_RBK.CURRENT_STATUS IS
    'Stores the status of the target';    
    
COMMENT ON COLUMN  MGMT_AVAILABILITY_RBK.START_COLLECTION_TIMESTAMP IS
    'Stores the starting collection timestamp from which the object in the corresponding status.';    

COMMENT ON COLUMN  MGMT_AVAILABILITY_RBK.END_COLLECTION_TIMESTAMP IS
    'Stores the ending collection timestamp until which the object in the corresponding status.';        
    
COMMENT ON COLUMN  MGMT_AVAILABILITY_RBK.REASON_ID IS
    'Stores the Reson id of RBK';    
    
COMMENT ON COLUMN  MGMT_AVAILABILITY_RBK.CREATE_TIMESTAMP IS
    'Stores the Create timestamp of this record';        
    
REM
REM PURPOSE
REM
REM This table is used to put the severity code similar to blackout.
REM Basically this would be used to do union of mgmt_severity and rbk severity
REM and filter out all the severity that came inbetween the rbk time period
REM
CREATE TABLE MGMT_SEVERITY_RBK
(
    TARGET_GUID RAW(16) NOT NULL,
    RBK_GUID RAW(16) NOT NULL,
    METRIC_GUID RAW(16) NOT NULL,
    KEY_VALUE VARCHAR2(256) DEFAULT ' ' NOT NULL,
    COLLECTION_TIMESTAMP DATE DEFAULT SYSDATE NOT NULL,
    SEVERITY_GUID  RAW(16) DEFAULT SYS_GUID(),    
    SEVERITY_CODE NUMBER NOT NULL,
    SEVERITY_TYPE NUMBER DEFAULT 0 NOT NULL,
    SEVERITY_DURATION NUMBER DEFAULT NULL,
    ANNOTATED_FLAG NUMBER DEFAULT 0,
    NOTIFICATION_STATUS NUMBER DEFAULT 1,
    MESSAGE VARCHAR2(4000) DEFAULT NULL,
    MESSAGE_NLSID VARCHAR2(64) DEFAULT NULL,
    MESSAGE_PARAMS VARCHAR2(4000) DEFAULT NULL,
    ACTION_MESSAGE VARCHAR2(4000) DEFAULT NULL,
    ACTION_MESSAGE_NLSID VARCHAR2(64) DEFAULT NULL,
    ACTION_MESSAGE_PARAMS VARCHAR2(4000) DEFAULT NULL,
    ADVISORY_ID VARCHAR2(64) DEFAULT NULL,    
    LOAD_TIMESTAMP DATE DEFAULT SYSDATE,
    USER_NAME VARCHAR2(64) DEFAULT '<SYSTEM>',
    CONSTRAINT PK_MGMT_SEVERITY_RBK PRIMARY KEY(TARGET_GUID,RBK_GUID, METRIC_GUID, KEY_VALUE,COLLECTION_TIMESTAMP,SEVERITY_CODE)
)MONITORING;

COMMENT ON TABLE  MGMT_SEVERITY_RBK IS
    'This table stores severities of RBK.';
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.TARGET_GUID IS
    'Stores the target GUID of the target on which RBK is created';
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.RBK_GUID IS
    'Stores the RBK GUID';        

COMMENT ON COLUMN  MGMT_SEVERITY_RBK.METRIC_GUID IS
    'Stores the Metric GUID of the severity';            
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.KEY_VALUE IS
    'Stores the key of the metric';   
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.COLLECTION_TIMESTAMP IS
    'Stores the collection timestamp of the severity';    
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.SEVERITY_GUID IS
    'Stores the severity GUID';  
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.SEVERITY_CODE IS
    'Stores the severity Code';  
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.SEVERITY_CODE IS
    'Stores the severity Code';    
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.SEVERITY_TYPE IS
    'Stores the severity Type';    
    
COMMENT ON COLUMN  MGMT_SEVERITY_RBK.SEVERITY_DURATION IS
    'Stores the duration of the severity';   
    
COMMENT ON COLUMN MGMT_SEVERITY_RBK.ANNOTATED_FLAG IS
   'A flag to indicate whether the severity is annotated or not.';
    
COMMENT ON COLUMN MGMT_SEVERITY_RBK.NOTIFICATION_STATUS IS
   'The column used by the notification sub system to determine
    notification status of the severity.'; 

COMMENT ON COLUMN MGMT_SEVERITY_RBK.MESSAGE IS
    'The message of the severity.  The messages usually contain
    details about what triggered this severity.';

COMMENT ON COLUMN MGMT_SEVERITY_RBK.MESSAGE_NLSID IS
    'The NLS ID of the severity message.';

COMMENT ON COLUMN MGMT_SEVERITY_RBK.MESSAGE_PARAMS IS
    'URL encoded parameters separated by "&" to be used to
    format the severity message.';

COMMENT ON COLUMN MGMT_SEVERITY_RBK.ACTION_MESSAGE IS
    'Suggested action message in english for this severity';

COMMENT ON COLUMN MGMT_SEVERITY_RBK.ACTION_MESSAGE_NLSID IS
    'The NLS ID of the action message.';

COMMENT ON COLUMN MGMT_SEVERITY_RBK.ACTION_MESSAGE_PARAMS IS
    'URL encoded parameters for translating action message';

COMMENT ON COLUMN MGMT_SEVERITY_RBK.ADVISORY_ID IS
    'Advisory ID of the severity';
    
COMMENT ON COLUMN MGMT_SEVERITY_RBK.LOAD_TIMESTAMP IS
    'Date and time when the severity was loaded';

COMMENT ON COLUMN MGMT_SEVERITY_RBK.USER_NAME IS
    'Name of the user to load the severity';   

    
    
