Rem drv: <migrate type="schema_upgrade" version="10.2.0.3" condition="EM_REPOS_MODE=CENTRAL"/>
Rem
Rem $Header: chronos_schema_upgrade.sql 23-apr-2007.23:28:19 jsadras Exp $
Rem
Rem chronos_schema_upgrade.sql
Rem
Rem Copyright (c) 2006, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     04/23/07 - Backport jsadras_bug-5934433 from main
Rem    jsadras     04/04/07 - Bug:5964374, handle ORA-01450 on 2k block size db
Rem    adosani     05/08/06 - bug 5044097 - remove primary key, add non-unique 
Rem                           index, and not null columns for pr_mapping and 
Rem                           incomplete_loads tables 
Rem    adosani     05/08/06 - Created
Rem

-- Bug 5044097: Remove primary key, add non-unique index, and 
-- not null columns for pr_mapping and incomplete_loads tables.

-- Incomplete Loads Table

ALTER TABLE MGMT_RT_INCOMPLETE_LOADS
   DROP PRIMARY KEY;

ALTER TABLE MGMT_RT_INCOMPLETE_LOADS 
  MODIFY aggregate_hour_timestamp NOT NULL;

CREATE INDEX inc_loads_idx ON MGMT_RT_INCOMPLETE_LOADS  
   (target_guid, aggregate_hour_timestamp, page_url);

-- PR Mapping Table
BEGIN
EXECUTE IMMEDIATE
  'ALTER TABLE MGMT_RT_PR_MAPPING
   DROP PRIMARY KEY';
EXCEPTION
WHEN OTHERS THEN NULL ;
END ;
/

ALTER TABLE MGMT_RT_PR_MAPPING 
  MODIFY aggregate_hour_timestamp NOT NULL;

BEGIN
EXECUTE IMMEDIATE
'CREATE INDEX pr_mapping_idx ON MGMT_RT_PR_MAPPING
   (target_guid, aggregate_hour_timestamp, page_url, request_url)';
EXCEPTION
WHEN OTHERS THEN 
IF SQLCODE != -1450 THEN RAISE ; END IF ;
END ;
/
