Rem drv: <migrate type="schema_upgrade" version="10.2.0.3" condition="EM_REPOS_MODE=SYSAUX"/>
Rem
Rem $Header: chronos_schema_upgrade_db.sql 03-jun-2008.12:16:38 jashukla Exp $
Rem
Rem chronos_schema_upgrade_db.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_schema_upgrade_db.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jashukla    06/03/08 - Bug 7144619 remove internal identifiers
Rem    chyu        08/16/06 - 
Rem    bmallipe    08/13/06 - adding the chronos tables for DBControl upgrade
Rem    bmallipe    08/13/06 - Created
Rem

rem here is from chronos types
CREATE OR REPLACE TYPE MgmtChrnsRegionMembers AS TABLE OF VARCHAR2(256);
/


CREATE OR REPLACE TYPE MgmtChrnsEventURLInfo AS OBJECT
(
  url_filename VARCHAR(512),
  url_sum NUMBER,
  url_count NUMBER
);
/

CREATE OR REPLACE TYPE MgmtChrnsEventURLInfoTable AS TABLE OF
  MgmtChrnsEventURLInfo;
/

CREATE OR REPLACE TYPE MgmtChrnsTgtGuid AS OBJECT
(
  target_guid RAW(16)
);
/

CREATE OR REPLACE TYPE MgmtChrnsTgtGuids AS TABLE OF MgmtChrnsTgtGuid;
/

create or replace type MGMT_CHRONOS_ANALYZE_OBJ as OBJECT (
    value VARCHAR2(256),
    value_type NUMBER
);
/

create or replace type MGMT_CHRONOS_ANALYZE_ARRAY as TABLE of MGMT_CHRONOS_ANALYZE_OBJ;
/

CREATE OR REPLACE TYPE MgmtChrnsAnlzFxdAxesMembers AS TABLE OF VARCHAR2(256);
/

-- Creating MGMT_MNTR_USER_STATS_OBJ will throw an ORA-02303 error if it is
-- replaced while REPLACE TYPE MGMT_MNTR_USER_STATS_ARRAY exists.
-- Delete the dependent type so that MGMT_MNTR_USER_STATS_OBJ can be replaced.
DECLARE
  l_dummy                     VARCHAR2(1);
BEGIN
  SELECT NULL
  INTO   l_dummy
  FROM   sys.user_types
  WHERE  type_name = 'MGMT_MNTR_USER_STATS_ARRAY';
  EXECUTE IMMEDIATE 'DROP TYPE MGMT_MNTR_USER_STATS_ARRAY';
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    NULL; -- Do nothing if type MGMT_MNTR_USER_STATS_ARRAY does not exist
END;
/

CREATE OR REPLACE TYPE MGMT_MNTR_USER_STATS_OBJ as OBJECT (
    queryName VARCHAR2(1024),
    displayName VARCHAR2(128),
    avgVal VARCHAR2(20),
    servAvgVal VARCHAR2(20),
    dbAvgVal VARCHAR2(20),
    hitsVal VARCHAR2(20),
    minVal VARCHAR2(20),
    maxVal VARCHAR2(20),
    stddevVal VARCHAR2(20),
    varianceVal VARCHAR2(20),
    critThreshold VARCHAR2(20),
    warnThreshold VARCHAR2(20),
    urlLink VARCHAR2(1280),
    mostFavorite VARCHAR(5),
    incompleteHitsVal VARCHAR2(20),
    incompleteAvgVal VARCHAR2(20)
);
/

CREATE OR REPLACE TYPE MGMT_MNTR_USER_STATS_ARRAY
  as TABLE of MGMT_MNTR_USER_STATS_OBJ;
/

rem here is from the chronos_tables.sql

rem
rem  PURPOSE
rem
rem     The MGMT_RT_METRICS_RAW table contains the raw url access
rem     response time samples that are collected at a target.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME
rem                 - the name of the metric that is being defined
rem
rem     COLLECTION_TIMESTAMP
rem                 - the date/time when the metric was collected
rem
rem     STATUS
rem                 - Status code returned from the metric being measured
rem
rem     STATUS_DESCRIPTION
rem                 - Text message describing the status condition.
rem
rem     SUBMIT_ACTION_TIMESTAMP
rem                 - Time stamp for submit event on browser that started a
rem                   client transaction logged in latency cookie
rem
rem     LOAD_ACTION_TIMESTAMP
rem                 - Time stamp for load event on browser that marks end of
rem                   a transaction logged in latency cookie
rem
rem     ELAPSED_TIME
rem                 - Number of milliseconds it took to access this url.
rem                   For Chronos:  Difference in milliseconds between
rem                   SUBMIT_ACTION_TIMESTAMP and LOAD_ACTION_TIMESTAMP.
rem
rem     URL_FILENAME
rem                 - This is the url filename relative to the webserver host and port.
rem                   The response of this url is measured in elapsed_time.
rem                   For Chronos: Referring URL that requested oem slr gif file.
rem
rem     URL_BASE
rem                 - The base of the URL, which contains the protocol, the
rem                   host id, and the port # (e.g. "http://machine.com:99")
rem
rem     VISITOR_NODE
rem                 - Resolved machine name from which a logged request is
rem                   made
rem
rem     VISITOR_DOMAIN
rem                 - Domain of the machine making requests
rem                   For Chronos:  logged in access_log
rem
rem     VISITOR_IP
rem                 - ip address of machine making requests
rem
rem     VISITOR_IP_NUM
rem                 - ip address of machine making requests as a number
rem
rem     SERVER_IN_TIMESTAMP
rem                 - Relative timestamp for receiving a webserver request
rem
rem     SERVER_OUT_TIMESTAMP
rem                 - Relative timestamp for webserver response to a request
rem
rem     SERVER_LATENCY_TIME
rem                 - Total of latencies for all constituent requests made
rem                   for rendering a page
rem
rem     BROWSER_NAME
rem                 - Name of web browser in user-agent information logged in
rem                   access_log
rem
rem     BROWSER_VERSION
rem                 - Version of web browser in user-agent
rem
rem     OS_NAME
rem                 - Name of operating system in user-agent information
rem
rem     OS_VERSION
rem                 - Version of operating system in user-agent information
rem                   in access_log
rem
rem     USERNAME
rem                 - The name of the user that submited the request (if available)
rem
rem     COOKIE_INDEX
rem                 - The filed used on joins with the cookie table.
rem
rem     CACHE_RENDERED
rem                 - Marks latency time for pages that got rendered out
rem                   of webcache. No page request was found in the log file
rem                   corresponding to the marker file request.
rem
rem  NOTES
rem
rem     The default value for the value of a response time value is NULL.
rem
rem

CREATE TABLE MGMT_RT_METRICS_RAW
    (target_guid             RAW(16)         NOT NULL,
     metric_name             VARCHAR2(64)    NOT NULL,
     collection_timestamp    DATE            NOT NULL,
     status                  NUMBER          DEFAULT NULL,
     status_description      VARCHAR(128)    DEFAULT NULL,
     submit_action_timestamp NUMBER          DEFAULT 0,
     load_action_timestamp   NUMBER          DEFAULT NULL,
     elapsed_time            NUMBER          DEFAULT 0,
     url_filename            VARCHAR2(1024)  DEFAULT NULL,
     url_base                VARCHAR2(256)   DEFAULT NULL,
     visitor_node            VARCHAR2(1024)  DEFAULT NULL,
     visitor_domain          VARCHAR2(1024)  DEFAULT NULL,
     visitor_ip              VARCHAR2(15)    DEFAULT NULL,
     visitor_ip_num          NUMBER          DEFAULT NULL,
     server_in_timestamp     NUMBER          DEFAULT NULL,
     server_out_timestamp    NUMBER          DEFAULT NULL,
     server_latency_time     NUMBER          DEFAULT 0,
     database_time           NUMBER          DEFAULT NULL,
     icx_session_id          VARCHAR2(32)    DEFAULT NULL,
     browser_name            VARCHAR2(64)    DEFAULT NULL,
     browser_version         VARCHAR2(16)    DEFAULT NULL,
     os_name                 VARCHAR2(64)    DEFAULT NULL,
     os_version              VARCHAR2(25)    DEFAULT NULL,
     username                VARCHAR2(64)    DEFAULT NULL,
     cookie_index            VARCHAR2(256)   DEFAULT NULL,
     cache_rendered          CHAR(1)         DEFAULT 'N' 
    )
  STORAGE
    (FREELISTS 4)
  INITRANS 2
  MONITORING;



rem
rem  PURPOSE
rem
rem  The MGMT_RT_URLS table is used to define a set of watch list URLs
rem  for a given application (as identified by a composite_target).
rem
rem  The table contains a list of named URLs. Only one name is allowed for
rem  a composite target.
rem
rem  COLUMNS
rem
rem    URL_GUID
rem      The unique guid to identify a display name.
rem
rem    TARGET_GUID
rem      The Composite target guid defined in
rem      MGMT_COMP_TARGET_DEF table.
rem
rem    DISPLAY_NAME
rem      The display name for the url.
rem
rem    URL_FILENAME
rem      The file name of a URL (e.g. "/somepath/somefile.html").  This is
rem      the relative path from the webserver root.
rem
rem    DESCRIPTION:
rem       Optional end user readable description of the URL.
rem

CREATE TABLE MGMT_RT_URLS
(
  url_guid              RAW(16)                 DEFAULT SYS_GUID(),
  target_guid           RAW(16)                 NOT NULL,
  display_name          VARCHAR2(128)           NOT NULL,
  url_filename          VARCHAR2(512)           NOT NULL,
  description           VARCHAR2(256)
) MONITORING;

rem
rem  PURPOSE
rem
rem    MGMT_RT_REGIONS table defines a set of regions for reporting purposes.
rem    Each region consists of a set of domains, which are specified in the
rem    MGMT_RT_REGION_ENTRIES and MGMT_RT_REGION_MAPPING tables.
rem    Regions are not hierarchical.
rem
rem  COLUMNS
rem
rem    REGION_GUID
rem      The unique guid to identify a display name.
rem
rem    TARGET_GUID
rem         The Composite target guid defined in MGMT_TARGETS.
rem    REGION :
rem      This is a logical group for the domain.  An example for region
rem      might be a country name, company, etc that the domain is in.
rem      (i.e. usA, Spain, Italy, California, Corporate HQ, etc.)
rem
rem    DESCRIPTION :
rem      Description of the region.
rem
rem  NOTES
rem

CREATE TABLE MGMT_RT_REGIONS
(
    region_guid             RAW(16)         DEFAULT SYS_GUID(),
    target_guid             RAW(16)                 NOT NULL,
    region_name             VARCHAR2(128)           NOT NULL,
    description             VARCHAR2(256)
) MONITORING;



rem
rem  PURPOSE
rem
rem    MGMT_RT_REGION_ENTRIES table defines 
rem
rem  COLUMNS
rem
rem    ID :
rem      A unique ID for each row that is used for joining with the 
rem      MGMT_RT_REGION_MAPPING table.
rem
rem    MIN_IP :
rem      A representation of the minimum ip address for the region as a number.
rem      The first octet is the most significant byte. 
rem      For example 0.0.0.5 = 5;   0.0.2.1 = 513; etc
rem      If the region is specified in terms of an IP subnet, the minimum ip
rem      address will be >= 0.  If the region is specified as a domain, like
rem      example.com, the min_ip is set to -1.
rem
rem    MAX_IP :
rem      A representation of the maximum ip address for the region as a number.
rem
rem    DOMAIN : 
rem      The actual domain if the region entry is specified by a domain.  
rem      Otherwise, a textual representation of the IP subnet.
rem
rem    REF_COUNT :
rem      A count of how many times this region entry is used in the mapping 
rem      table.  Keeping a refenence count in this table allows an unused entry
rem      to be deleted when a Web Application is deleted.  
rem      

CREATE TABLE MGMT_RT_REGION_ENTRIES
(
  id                    NUMBER                  NOT NULL,
  min_ip                NUMBER                  NOT NULL,
  max_ip                NUMBER                  NOT NULL,
  domain                VARCHAR2(1024)          NOT NULL,
  ref_count             NUMBER                  NOT NULL
) MONITORING;



rem
rem  PURPOSE
rem
rem    MGMT_RT_REGION_MAPPING table defines a mapping from the 
rem    MGMT_RT_REGION_ENTRIES table to the MGMT_RT_REGIONS table.
rem
rem  COLUMNS
rem
rem    ID :
rem      Serves as a mapping from this table to the region mapping table.
rem      Must be unique per Web Application.
rem
rem    REGION_GUID :
rem      The unique guid to identify a display name.

CREATE TABLE MGMT_RT_REGION_MAPPING
(
  id                    NUMBER                  NOT NULL,
  region_guid           RAW(16)                 NOT NULL
) MONITORING;



rem
rem  PURPOSE
rem
rem     The MGMT_RT_TARGET_PROPERTIES table holds the list of chronos
rem     target properties
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - target guid .
rem
rem     PROPERTY_NAME  - the name of the property.
rem
rem     PROPERTY_VALUE - the value of the property.
rem
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_TARGET_PROPERTIES
    (target_guid          RAW(16)    NOT NULL,
     property_name         VARCHAR2(64)    NOT NULL,
     property_value     VARCHAR2(1024)  NOT NULL)
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_BOOTSTRAP_TIMES table holds the list of chronos
rem     target properties
rem
rem  COLUMNS
rem
rem     TARGET_GUID       - target guid .
rem
rem     ROLLUP_TIMESTAMP  - the last time for which bootstrap data exists.
rem
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_BOOTSTRAP_TIMES
    (target_guid          RAW(16)    NOT NULL,
     rollup_timestamp     DATE       NOT NULL)
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_COOKIE_DATA table contains the cookie data for a
rem     response time collection, broken down into name/value pairs.
rem
rem  COLUMNS
rem
rem     RAW INDEX
rem                 - The field that glues rows in this table with a row in
rem                   the MGMT_RT_METRICS_RAW table
rem
rem     NAME
rem                 - The name portion of the cookie's name/value pair
rem
rem     VALUE
rem                - the value portion of the cookie's name/value pair
rem
rem  NOTES
rem
rem     There can be duplicates in the table.
rem

CREATE TABLE MGMT_RT_COOKIE_DATA
    (
     raw_index             VARCHAR2(256)   DEFAULT NULL,
     name                  VARCHAR2(256)   NOT NULL,
     value                 VARCHAR2(1024)  NOT NULL)
  STORAGE
    (FREELISTS 4)
  INITRANS 2
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_URL_1HOUR table contains the rollup metrics from the
rem     response data samples collected on the target system rolled
rem     into 1 hour intervals.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the description of the
rem     MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     URL_FILENAME
rem                 - the url filename relative to the webserver host and port.
rem
rem     URL_LINK
rem                 - complete url specification for the measured url
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this
rem                   case the rollup times will be on 1 hour boundaries using a
rem                   24 hour clock.  Samples included in the rollup are greater
rem                   than or equal to the start of the period, and less than
rem                   the next period.  So the 00 rollup includes samples from
rem                   midnight up to samples collected at 1 o'clock AM.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_URL_1HOUR
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     url_filename                 VARCHAR2(1024)  NOT NULL,
     url_link                     VARCHAR2(1280)  DEFAULT ' ',
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_RT_URL_BOOTSTRAP table contains the rollup metrics from the
rem     response data samples collected on the target system rolled
rem     into 1 hour intervals.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the description of the
rem     MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     URL_FILENAME
rem                 - the url filename relative to the webserver host and port.
rem
rem     URL_LINK
rem                 - complete url specification for the measured url
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this
rem                   case the rollup times will be on 1 hour boundaries using a
rem                   24 hour clock.  Samples included in the rollup are greater
rem                   than or equal to the start of the period, and less than
rem                   the next period.  So the 00 rollup includes samples from
rem                   midnight up to samples collected at 1 o'clock AM.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_URL_BOOTSTRAP
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     url_filename                 VARCHAR2(1024)  NOT NULL,
     url_link                     VARCHAR2(1280)  DEFAULT ' ',
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_RT_URL_1DAY table contains the rollup metrics from the response
rem     data samples into 1 day intervals that were collected on the target
rem     system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the description of the
rem     MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     URL_FILENAME
rem                 - the url filename relative to the webserver host and port.
rem
rem     URL_LINK
rem                 - complete url specification for the measured url
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_URL_1DAY
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     url_filename                 VARCHAR2(1024)  NOT NULL,
     url_link                     VARCHAR2(1280)  DEFAULT ' ',
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_URL_DIST_1HOUR table contains the rollup metrics from the
rem     response data samples into 1 hour intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     URL_FILENAME
rem                 - the url filename relative to the webserver host and port.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_URL_DIST_1HOUR
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     url_filename                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_URL_DIST_BOOTSTRAP table contains the rollup metrics from
rem     the response data samples into 1 hour intervals that were collected on
rem     the target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     URL_FILENAME
rem                 - the url filename relative to the webserver host and port.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_URL_DIST_BOOTSTRAP
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     url_filename                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_URL_DIST_1DAY table contains the rollup metrics from the
rem     response data samples into 1 day intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     URL_FILENAME
rem                 - the url filename relative to the webserver host and port.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_URL_DIST_1DAY
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     url_filename                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;



rem
rem  PURPOSE
rem
rem     The MGMT_RT_DOMAIN_1HOUR table contains the rollup metrics from the
rem     response data samples into 1 hour intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_DOMAIN - domain of the visitor to the website, matches
rem                   the visitor_domain collected in MGMT_RT_METRICS_RAW
rem
rem     VISITOR_SUBNET - subnet portion of ip address of visitor to the website
rem
rem     VISITOR_SUBNET_NUM - subnet portion of ip address of visitor to the 
rem                          website as a number
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this
rem                   case the rollup times will be on 1 hour boundaries using a
rem                   24 hour clock.  Samples included in the rollup are greater
rem                   than or equal to the start of the period, and less than
rem                   the next period.  So the 00 rollup includes samples from
rem                   midnight up to samples collected at 1 o'clock AM.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_DOMAIN_1HOUR
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_domain               VARCHAR2(1024)  NOT NULL,
     visitor_subnet               VARCHAR2(15)    NOT NULL,
     visitor_subnet_num           NUMBER          DEFAULT NULL NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;



rem
rem  PURPOSE
rem
rem     The MGMT_RT_DOMAIN_BOOTSTRAP table contains the rollup metrics from the
rem     response data samples into 1 hour intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_DOMAIN - domain of the visitor to the website, matches
rem                   the visitor_domain collected in MGMT_RT_METRICS_RAW
rem
rem     VISITOR_SUBNET - subnet portion of ip address of visitor to the website
rem
rem     VISITOR_SUBNET_NUM - subnet portion of ip address of visitor to the 
rem                          website as a number
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this
rem                   case the rollup times will be on 1 hour boundaries using a
rem                   24 hour clock.  Samples included in the rollup are greater
rem                   than or equal to the start of the period, and less than
rem                   the next period.  So the 00 rollup includes samples from
rem                   midnight up to samples collected at 1 o'clock AM.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_DOMAIN_BOOTSTRAP
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_domain               VARCHAR2(1024)  NOT NULL,
     visitor_subnet               VARCHAR2(15)    NOT NULL,
     visitor_subnet_num           NUMBER          NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;



rem
rem  PURPOSE
rem
rem     The MGMT_RT_DOMAIN_1DAY table contains the rollup metrics from the
rem     response data samples into 1 day intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_DOMAIN - domain of the visitor to the website, matches
rem                   the visitor_domain collected in MGMT_RT_METRICS_RAW
rem
rem     VISITOR_SUBNET - subnet portion of ip address of visitor to the website
rem
rem     VISITOR_SUBNET_NUM - subnet portion of ip address of visitor to the 
rem                          website as a number
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     ROLLUP_TIMESTAMP
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_DOMAIN_1DAY
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_domain               VARCHAR2(1024)  NOT NULL,
     visitor_subnet               VARCHAR2(15)    NOT NULL,
     visitor_subnet_num           NUMBER          DEFAULT NULL NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_DOMAIN_DIST_1HOUR table contains the rollup metrics from
rem     the response data samples into 1 hour intervals that were collected on
rem     the target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_DOMAIN - domain of the visitor to the website, matches
rem                   the visitor_domain collected in MGMT_RT_METRICS_RAW
rem
rem     VISITOR_SUBNET - subnet portion of ip address of visitor to the website
rem
rem     VISITOR_SUBNET_NUM - subnet portion of ip address of visitor to the 
rem                          website as a number
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_DOMAIN_DIST_1HOUR
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_domain               VARCHAR2(1024)  NOT NULL,
     visitor_subnet               VARCHAR2(15)    NOT NULL,
     visitor_subnet_num           NUMBER          DEFAULT NULL NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_DOMAIN_DIST_BOOTSTRAP table contains the rollup metrics
rem     fromthe response data samples into 1 hour intervals that were collected
rem     on the target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_DOMAIN - domain of the visitor to the website, matches
rem                   the visitor_domain collected in MGMT_RT_METRICS_RAW
rem
rem     VISITOR_SUBNET - subnet portion of ip address of visitor to the website
rem
rem     VISITOR_SUBNET_NUM - subnet portion of ip address of visitor to the 
rem                          website as a number
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_DOMAIN_DIST_BOOTSTRAP
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_domain               VARCHAR2(1024)  NOT NULL,
     visitor_subnet               VARCHAR2(15)    NOT NULL,
     visitor_subnet_num           NUMBER          NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;



rem
rem  PURPOSE
rem
rem     The MGMT_RT_DOMAIN_DIST_1DAY table contains the rollup metrics from
rem     the response data samples into 1 day intervals that were collected on
rem     the target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_DOMAIN - domain of the visitor to the website, matches
rem                   the visitor_domain collected in MGMT_RT_METRICS_RAW
rem
rem     VISITOR_SUBNET - subnet portion of ip address of visitor to the website
rem
rem     VISITOR_SUBNET_NUM - subnet portion of ip address of visitor to the 
rem                          website as a number
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_DOMAIN_DIST_1DAY
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_domain               VARCHAR2(1024)  NOT NULL,
     visitor_subnet               VARCHAR2(15)    NOT NULL,
     visitor_subnet_num           NUMBER          DEFAULT NULL NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_IP_1HOUR table contains the rollup metrics from the
rem     response data samples into 1 hour intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_NODE - the resolved node name (if available) or IP address of the
rem                   visitor node.  This may be a gateway or router if one
rem                   exists between the user machine and the webserver target.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this
rem                   case the rollup times will be on 1 hour boundaries using a
rem                   24 hour clock.  Samples included in the rollup are greater
rem                   than or equal to the start of the period, and less than
rem                   the next period.  So the 00 rollup includes samples from
rem                   midnight up to samples collected at 1 o'clock AM.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_IP_1HOUR
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_node                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_RT_IP_BOOTSTRAP table contains the rollup metrics from the
rem     response data samples into 1 hour intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_NODE - the resolved node name (if available) or IP address of the
rem                   visitor node.  This may be a gateway or router if one
rem                   exists between the user machine and the webserver target.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this
rem                   case the rollup times will be on 1 hour boundaries using a
rem                   24 hour clock.  Samples included in the rollup are greater
rem                   than or equal to the start of the period, and less than
rem                   the next period.  So the 00 rollup includes samples from
rem                   midnight up to samples collected at 1 o'clock AM.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_IP_BOOTSTRAP
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_node                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;

rem  PURPOSE
rem
rem     The MGMT_RT_IP_1DAY table contains the rollup metrics from the
rem     response data samples into 1 day intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_NODE - the node name (if available) or IP address of the
rem                   visitor node.  This may be a gateway or router if one
rem                   exists between the user machine and the webserver target.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this
rem                   case the rollup times will be on 1 hour boundaries using a
rem                   24 hour clock.  Samples included in the rollup are greater
rem                   than or equal to the start of the period, and less than
rem                   the next period.  So the 00 rollup includes samples from
rem                   midnight up to samples collected at 1 o'clock AM.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     ROLLUP_TIMESTAMP
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem     RESPONSE_TIME_AVERAGE
rem
rem                 - The average value of the metric for samples in the time
rem                   period
rem
rem
rem     RESPONSE_TIME_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time
rem                   period
rem
rem     RESPONSE_TIME_SDEV
rem
rem                 - The standard deviation of the metric for samples in the
rem                   time period
rem
rem     RESPONSE_TIME_VARIANCE
rem
rem                 - The variance of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_IP_1DAY
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_node                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          NOT NULL,
     response_time_average        NUMBER          NOT NULL,
     response_time_minimum        NUMBER          NOT NULL,
     response_time_maximum        NUMBER          NOT NULL,
     response_time_sdev           NUMBER          NOT NULL,
     response_time_variance       NUMBER          NOT NULL,
     server_time_average          NUMBER          NOT NULL,
     server_time_minimum          NUMBER          NOT NULL,
     server_time_maximum          NUMBER          NOT NULL,
     server_time_sdev             NUMBER          NOT NULL,
     server_time_variance         NUMBER          NOT NULL,
     db_time_average              NUMBER          DEFAULT NULL,
     db_time_minimum              NUMBER          DEFAULT NULL,
     db_time_maximum              NUMBER          DEFAULT NULL,
     db_time_sdev                 NUMBER          DEFAULT NULL,
     db_time_variance             NUMBER          DEFAULT NULL)
  PCTFREE 0
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_RT_IP_DIST_1HOUR table contains the rollup metrics from the
rem     response data samples into 1 hour intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_NODE - the resolved node name (if available) or IP address of the
rem                   visitor node.  This may be a gateway or router if one
rem                   exists between the user machine and the webserver target.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_IP_DIST_1HOUR
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_node                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_RT_IP_DIST_BOOTSTRAP table contains the rollup metrics from
rem     the response data samples into 1 hour intervals that were collected on
rem     the target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_NODE - the resolved node name (if available) or IP address of the
rem                   visitor node.  This may be a gateway or router if one
rem                   exists between the user machine and the webserver target.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_IP_DIST_BOOTSTRAP
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_node                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;



rem
rem  PURPOSE
rem
rem     The MGMT_RT_IP_DIST_1DAY table contains the rollup metrics from the
rem     response data samples into 1 day intervals that were collected on the
rem     target system.
rem     The individual targets (i.e. webservers) where metrics were collected
rem     are maintained in this rollup table.
rem
rem     For more information on valid metrics, see the
rem     description of the MGMT_RT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_NAME - the name of the metric collected
rem
rem     VISITOR_NODE - the resolved node name (if available) or IP address of the
rem                   visitor node.  This may be a gateway or router if one
rem                   exists between the user machine and the webserver target.
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     HITS - The number of hits that have been rolled for this time period.
rem
rem     NUM_SECONDS
rem
rem            - The number of seconds that all the hits in this record took to
rem              respond to the client.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_RT_IP_DIST_1DAY
    (target_guid                  RAW(16)         NOT NULL,
     metric_name                  VARCHAR2(64)    NOT NULL,
     visitor_node                 VARCHAR2(1024)  NOT NULL,
     rollup_timestamp             DATE            NOT NULL,
     hits                         NUMBER          DEFAULT 0,
     num_seconds                  NUMBER          DEFAULT 0,
     dist_value_type              NUMBER(4)       DEFAULT 0)
  PCTFREE 0
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_RT_PR_MAPPING (Page Request Mapping) table holds a mapping of
rem     page URLs to their component requests.  Each PAGE_URL can have several
rem     REQUEST_URLs associated with it.
rem     This table is like a raw table in that it comes directly from the CME.
rem     Even though it is aggregated by hour, there can be multiple entries
rem     that have the same PAGE_URL, REQUEST_URL, and AGGREGATE_HOUR_TIMESTAMP.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     PAGE_URL       - The page that the user visited that resulted in 
rem                      requests for each REQUEST_URL.
rem
rem     REQUEST_URL    - The component of the PAGE_URL.
rem
rem     NUM_CACHE_HITS - The number of caches hits on the request URL.
rem
rem     CACHE_HITS_AVG_SVR_TIME 
rem                    - The average server time for cached hits on
rem                      the REQUEST_URL.
rem
rem     NUM_NON_CACHE_HITS 
rem                    - The number of non-cached hits for the REQUEST_URL.
rem
rem     NON_CACHE_HITS_AVG_SVR_TIME 
rem                    - The average server time for non-cached 
rem                      hits on the REQUEST_URL.
rem
rem     AGGREGATE_HOUR_TIMESTAMP 
rem                    - The hour in which the samples were aggregated.
rem
rem
CREATE TABLE MGMT_RT_PR_MAPPING
   (TARGET_GUID                 RAW(16)         NOT NULL,
    PAGE_URL                    VARCHAR2(1024)  NOT NULL,
    REQUEST_URL                 VARCHAR2(1024)  NOT NULL,
    NUM_CACHE_HITS              NUMBER          DEFAULT 0,              
    CACHE_HITS_AVG_SVR_TIME     NUMBER(10,2)    DEFAULT 0,
    NUM_NON_CACHE_HITS          NUMBER          DEFAULT 0,
    NON_CACHE_HITS_AVG_SVR_TIME NUMBER(10,2)    DEFAULT 0,
    AGGREGATE_HOUR_TIMESTAMP    DATE            NOT NULL);



rem
rem  PURPOSE
rem
rem     The MGMT_RT_INCOMPLETE_LOADS table holds data on the incomplete page
rem     loads on a webserver.  
rem     This table is like a raw table in that it comes directly from the CME.
rem     Even though it is aggregated by hour, there can be multiple entries
rem     that have the same PAGE_URL and AGGREGATE_HOUR_TIMESTAMP.
rem
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     PAGE_URL       - The page that the user visited that resulted in 
rem                      an incomplete page load.
rem
rem     NUM_INCOMPLETE_LOADS 
rem                    - The number of incomplete loads that occured in the 
rem                      hour.
rem
rem     AVG_SERVER_TIME- The average server time spent processing the 
rem                      incomplete page loads.
rem
rem     AGGREGATE_HOUR_TIMESTAMP 
rem                    - The hour in which the samples were aggregated.
rem
rem
CREATE TABLE MGMT_RT_INCOMPLETE_LOADS
   (TARGET_GUID                RAW(16)         NOT NULL,
    PAGE_URL                   VARCHAR2(1024)  NOT NULL,
    NUM_INCOMPLETE_LOADS       NUMBER          DEFAULT 0,
    AVG_SERVER_TIME            NUMBER(10,2)    DEFAULT 0,
    AGGREGATE_HOUR_TIMESTAMP   DATE            NOT NULL);



rem
rem  PURPOSE
rem
rem     The MGMT_RT_PR_MAPPING_1HOUR (Page Request Mapping) table holds a 
rem     mapping of page URLs to their component requests.  Each PAGE_URL can
rem     have several REQUEST_URLs associated with it.
rem     This table contains rolled up page request mappings from the 
rem     MGMT_RT_PR_MAPPING table.  Unlike the MGMT_RT_PR_MAPPING table, this 
rem     table does not have any rows with the same PAGE_URL, REQUEST_URL, and 
rem     AGGREGATE_HOUR_TIMESTAMP.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     PAGE_URL       - The page that the user visited that resulted in 
rem                      requests for each REQUEST_URL.
rem
rem     REQUEST_URL    - The component of the PAGE_URL.
rem
rem     NUM_CACHE_HITS - The number of caches hits on the request URL.
rem
rem     CACHE_HITS_AVG_SVR_TIME 
rem                    - The average server time for cached hits on
rem                      the REQUEST_URL.
rem
rem     NUM_NON_CACHE_HITS 
rem                    - The number of non-cached hits for the REQUEST_URL.
rem
rem     NON_CACHE_HITS_AVG_SVR_TIME 
rem                    - The average server time for non-cached 
rem                      hits on the REQUEST_URL.
rem
rem     ROLLUP_TIMESTAMP 
rem                    - The hour in which the samples were rolled up.
rem
rem
CREATE TABLE MGMT_RT_PR_MAPPING_1HOUR
   (TARGET_GUID                 RAW(16)         NOT NULL,
    PAGE_URL                    VARCHAR2(1024)  NOT NULL,
    REQUEST_URL                 VARCHAR2(1024)  NOT NULL,
    NUM_CACHE_HITS              NUMBER          DEFAULT 0,              
    CACHE_HITS_AVG_SVR_TIME     NUMBER(10,2)    DEFAULT 0,
    NUM_NON_CACHE_HITS          NUMBER          DEFAULT 0,
    NON_CACHE_HITS_AVG_SVR_TIME NUMBER(10,2)    DEFAULT 0,
    ROLLUP_TIMESTAMP            DATE);


rem
rem  PURPOSE
rem
rem     The MGMT_RT_INCOMPLETE_LOADS_1HOUR table holds data on the incomplete
rem     page loads on a webserver.  
rem     This table contains rolled up incomplete page loads from the 
rem     MGMT_RT_INCOMPLETE_LOADS table.  Unlike the MGMT_RT_INCOMPLETE_LOADS table, this 
rem     table does not have any rows with the same PAGE_URL and 
rem     AGGREGATE_HOUR_TIMESTAMP.
rem
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     PAGE_URL       - The page that the user visited that resulted in 
rem                      an incomplete page load.
rem
rem     NUM_INCOMPLETE_LOADS 
rem                    - The number of incomplete loads that occured in the 
rem                      hour.
rem
rem     AVG_SERVER_TIME- The average server time spent processing the 
rem                      incomplete page loads.
rem
rem     ROLLUP_TIMESTAMP 
rem                    - The hour in which the samples were rolled up.
rem
rem
CREATE TABLE MGMT_RT_INCOMPLETE_LOADS_1HOUR
   (TARGET_GUID                RAW(16)         NOT NULL,
    PAGE_URL                   VARCHAR2(1024)  NOT NULL,
    NUM_INCOMPLETE_LOADS       NUMBER          DEFAULT 0,
    AVG_SERVER_TIME            NUMBER(10,2)    DEFAULT 0,
    ROLLUP_TIMESTAMP           DATE);


rem
rem  PURPOSE
rem
rem     The MGMT_RT_PR_MAPPING_1DAY (Page Request Mapping) table holds a 
rem     mapping of page URLs to their component requests.  Each PAGE_URL can
rem     have several REQUEST_URLs associated with it.
rem     This table contains rolled up page request mappings from the 
rem     MGMT_RT_PR_MAPPING_1HOUR table by day.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     PAGE_URL       - The page that the user visited that resulted in 
rem                      requests for each REQUEST_URL.
rem
rem     REQUEST_URL    - The component of the PAGE_URL.
rem
rem     NUM_CACHE_HITS - The number of caches hits on the request URL.
rem
rem     CACHE_HITS_AVG_SVR_TIME 
rem                    - The average server time for cached hits on
rem                      the REQUEST_URL.
rem
rem     NUM_NON_CACHE_HITS 
rem                    - The number of non-cached hits for the REQUEST_URL.
rem
rem     NON_CACHE_HITS_AVG_SVR_TIME 
rem                    - The average server time for non-cached 
rem                      hits on the REQUEST_URL.
rem
rem     ROLLUP_TIMESTAMP 
rem                    - The hour in which the samples were rolled up.
rem
rem
CREATE TABLE MGMT_RT_PR_MAPPING_1DAY
   (TARGET_GUID                 RAW(16)         NOT NULL,
    PAGE_URL                    VARCHAR2(1024)  NOT NULL,
    REQUEST_URL                 VARCHAR2(1024)  NOT NULL,
    NUM_CACHE_HITS              NUMBER          DEFAULT 0,              
    CACHE_HITS_AVG_SVR_TIME     NUMBER(10,2)    DEFAULT 0,
    NUM_NON_CACHE_HITS          NUMBER          DEFAULT 0,
    NON_CACHE_HITS_AVG_SVR_TIME NUMBER(10,2)    DEFAULT 0,
    ROLLUP_TIMESTAMP            DATE);


rem
rem  PURPOSE
rem
rem     The MGMT_RT_INCOMPLETE_LOADS_1DAY table holds data on the incomplete
rem     page loads on a webserver.  
rem     This table contains rolled up incomplete page loads from the 
rem     MGMT_RT_INCOMPLETE_LOADS_1HOUR table by day. 
rem
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     PAGE_URL       - The page that the user visited that resulted in 
rem                      an incomplete page load.
rem
rem     NUM_INCOMPLETE_LOADS 
rem                    - The number of incomplete loads that occured in the 
rem                      hour.
rem
rem     AVG_SERVER_TIME- The average server time spent processing the 
rem                      incomplete page loads.
rem
rem     ROLLUP_TIMESTAMP 
rem                    - The hour in which the samples were rolled up.
rem
rem
CREATE TABLE MGMT_RT_INCOMPLETE_LOADS_1DAY
   (TARGET_GUID                RAW(16)         NOT NULL,
    PAGE_URL                   VARCHAR2(1024)  NOT NULL,
    NUM_INCOMPLETE_LOADS       NUMBER          DEFAULT 0,
    AVG_SERVER_TIME            NUMBER(10,2)    DEFAULT 0,
    ROLLUP_TIMESTAMP           DATE);


rem here is from the chronos_indexes.sql

Rem Indices for MGMT_RT_METRICS_RAW table
Rem
ALTER TABLE MGMT_RT_METRICS_RAW
   ADD CONSTRAINT MGMT_RT_METRICS_RAW_PK
       PRIMARY KEY (target_guid, collection_timestamp, url_filename,
                      metric_name, submit_action_timestamp, visitor_ip)
   USING INDEX STORAGE
    (FREELISTS 4)
    INITRANS 4;

create index mgmt_rt_metrics_raw_ip_num_idx on mgmt_rt_metrics_raw (visitor_ip_num);

Rem
Rem Indices for MGMT_RT_URLS table
Rem
ALTER TABLE MGMT_RT_URLS
 ADD CONSTRAINT MGMT_RT_URLS_PK
  PRIMARY KEY (url_guid);

ALTER TABLE MGMT_RT_URLS
   ADD CONSTRAINT MGMT_RT_URLS_NAME_UN
       UNIQUE(target_guid, display_name);

ALTER TABLE MGMT_RT_URLS
   ADD CONSTRAINT MGMT_RT_URLS_URL_UN
       UNIQUE(target_guid, url_filename);


Rem
Rem Indices for MGMT_RT_REGIONS table
Rem
ALTER TABLE MGMT_RT_REGIONS
  ADD CONSTRAINT MGMT_RT_REGIONS_PK
  PRIMARY KEY (region_guid);

ALTER TABLE MGMT_RT_REGIONS
    ADD CONSTRAINT MGMT_RT_REGIONS_UN
    UNIQUE(target_guid, region_name);


Rem
Rem Indices for MGMT_RT_REGION_ENTRIES table
Rem
ALTER TABLE MGMT_RT_REGION_ENTRIES
    ADD CONSTRAINT MGMT_RT_REGION_ENTRIES_PK
    PRIMARY KEY (id);
ALTER TABLE MGMT_RT_REGION_ENTRIES
    ADD CONSTRAINT MGMT_RT_REGION_ENTRIES_UN_DOM
    UNIQUE (domain);

create index IDX_REGION_MIN_IP on MGMT_RT_REGION_ENTRIES (MIN_IP);

Rem
Rem Indices for MGMT_RT_REGION_MAPPING table
Rem
ALTER TABLE MGMT_RT_REGION_MAPPING
    ADD CONSTRAINT MGMT_RT_REGION_MAPPING_PK
    PRIMARY KEY (id, region_guid);

create index MGMT_RT_REGION_MAPPING_ID_IDX on MGMT_RT_REGION_MAPPING (id);

ALTER TABLE MGMT_RT_REGION_MAPPING
   ADD CONSTRAINT MGMT_RT_REGION_MAPPING_FK
       FOREIGN KEY (region_guid)
       REFERENCES MGMT_RT_REGIONS (region_guid)
     ON DELETE CASCADE;


Rem
Rem Indices for MGMT_RT_TARGET_PROPERTIES table
Rem
ALTER TABLE MGMT_RT_TARGET_PROPERTIES
   ADD CONSTRAINT RT_TARGET_PROPERTIES_PK
       PRIMARY KEY (target_guid, property_name);



Rem
Rem Indices for MGMT_RT_COOKIE_DATA table
Rem
ALTER TABLE MGMT_RT_COOKIE_DATA
   ADD CONSTRAINT MGMT_RT_COOKIE_DATA_PK
       PRIMARY KEY (raw_index,name,value)
    USING INDEX STORAGE
    (FREELISTS 4)
    INITRANS 4;


Rem
Rem Indices for MGMT_RT_URL_1HOUR table
Rem
ALTER TABLE MGMT_RT_URL_1HOUR
   ADD CONSTRAINT url_1hour_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    url_filename, url_link)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_URL_1DAY table
Rem
ALTER TABLE MGMT_RT_URL_1DAY
   ADD CONSTRAINT url_1day_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name, url_filename,url_link)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_URL_DIST_1HOUR table
Rem
ALTER TABLE MGMT_RT_URL_DIST_1HOUR
   ADD CONSTRAINT url_dist_1hour_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    url_filename, num_seconds, dist_value_type)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_URL_DIST_1DAY table
Rem
ALTER TABLE MGMT_RT_URL_DIST_1DAY
   ADD CONSTRAINT url_dist_1day_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    url_filename, num_seconds,dist_value_type)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_DOMAIN_1HOUR table
Rem
ALTER TABLE MGMT_RT_DOMAIN_1HOUR
   ADD CONSTRAINT domain_1hour_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_domain, visitor_subnet)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_DOMAIN_1DAY table
Rem
ALTER TABLE MGMT_RT_DOMAIN_1DAY
   ADD CONSTRAINT domain_1day_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_domain, visitor_subnet)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_DOMAIN_DIST_1HOUR table
Rem
ALTER TABLE MGMT_RT_DOMAIN_DIST_1HOUR
   ADD CONSTRAINT domain_dist_1hour_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_domain, visitor_subnet, 
                    num_seconds, dist_value_type)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_DOMAIN_DIST_1DAY table
Rem
ALTER TABLE MGMT_RT_DOMAIN_DIST_1DAY
   ADD CONSTRAINT domain_dist_1day_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_domain, visitor_subnet, 
                    num_seconds, dist_value_type)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_IP_1HOUR table
Rem
ALTER TABLE MGMT_RT_IP_1HOUR
   ADD CONSTRAINT ip_1hour_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name, visitor_node)
   USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_IP_1DAY table
Rem
ALTER TABLE MGMT_RT_IP_1DAY
   ADD CONSTRAINT ip_1day_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name, visitor_node)
  USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_IP_DIST_1HOUR table
Rem
ALTER TABLE MGMT_RT_IP_DIST_1HOUR
   ADD CONSTRAINT ip_dist_1hour_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_node, num_seconds, dist_value_type)
   USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_IP_DIST_1DAY table
Rem
ALTER TABLE MGMT_RT_IP_DIST_1DAY
   ADD CONSTRAINT ip_dist_1day_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_node, num_seconds, dist_value_type)
   USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_BOOTSTRAP_TIMES table
Rem
ALTER TABLE MGMT_RT_BOOTSTRAP_TIMES
   ADD CONSTRAINT mgmt_rt_bootstrap_times_pk
       PRIMARY KEY (target_guid)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_URL_BOOTSTRAP table
Rem
ALTER TABLE MGMT_RT_URL_BOOTSTRAP
   ADD CONSTRAINT url_bootstrap_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    url_filename, url_link)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_URL_DIST_BOOTSTRAP table
Rem
ALTER TABLE MGMT_RT_URL_DIST_BOOTSTRAP
   ADD CONSTRAINT url_dist_bootstrap_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    url_filename, num_seconds, dist_value_type)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_DOMAIN_BOOTSTRAP table
Rem
ALTER TABLE MGMT_RT_DOMAIN_BOOTSTRAP
   ADD CONSTRAINT domain_bootstrap_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_domain, visitor_subnet)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_DOMAIN_DIST_BOOTSTRAP table
Rem
ALTER TABLE MGMT_RT_DOMAIN_DIST_BOOTSTRAP
   ADD CONSTRAINT domain_dist_bs_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_domain, visitor_subnet, 
                    num_seconds, dist_value_type)
   USING INDEX PCTFREE 0;


Rem
Rem Indices for MGMT_RT_IP_BOOTSTRAP table
Rem
ALTER TABLE MGMT_RT_IP_BOOTSTRAP
   ADD CONSTRAINT ip_bootstrap_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name, visitor_node)
   USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_IP_DIST_BOOTSTRAP table
Rem
ALTER TABLE MGMT_RT_IP_DIST_BOOTSTRAP
   ADD CONSTRAINT ip_dist_bootstrap_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, metric_name,
                    visitor_node, num_seconds, dist_value_type)
   USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_INCOMPLETE_LOADS table
Rem
CREATE INDEX inc_loads_idx ON MGMT_RT_INCOMPLETE_LOADS
   (target_guid, aggregate_hour_timestamp, page_url);


Rem
Rem Indices for MGMT_RT_INCOMPLETE_LOADS_1HOUR table
Rem
ALTER TABLE MGMT_RT_INCOMPLETE_LOADS_1HOUR
   ADD CONSTRAINT inc_loads_1hour_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, page_url)
   USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_INCOMPLETE_LOADS_1DAY table
Rem
ALTER TABLE MGMT_RT_INCOMPLETE_LOADS_1DAY
   ADD CONSTRAINT inc_loads_1day_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, page_url)
   USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_PR_MAPPING table
Rem
CREATE INDEX pr_mapping_idx ON MGMT_RT_PR_MAPPING
   (target_guid, aggregate_hour_timestamp, page_url, request_url);


Rem
Rem Indices for MGMT_RT_PR_MAPPING_1HOUR table
Rem
ALTER TABLE MGMT_RT_PR_MAPPING_1HOUR
   ADD CONSTRAINT pr_mapping_1hour_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, page_url, request_url)
   USING INDEX
  PCTFREE 0;


Rem
Rem Indices for MGMT_RT_PR_MAPPING_1DAY table
Rem
ALTER TABLE MGMT_RT_PR_MAPPING_1DAY
   ADD CONSTRAINT pr_mapping_1day_primary_key
       PRIMARY KEY (target_guid, rollup_timestamp, page_url, request_url)
   USING INDEX
  PCTFREE 0;
