Rem drv: <migrate type="data_upgrade" version="10.2.0.3"/>
Rem
Rem $Header: collections_data_upgrade.sql 09-feb-2006.00:50:25 jsadras Exp $
Rem
Rem collections_data_upgrade.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      collections_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     02/09/06 - add remove from mgmt_system_performance_log 
Rem    jsadras     01/30/06 - remove emd_collection.run_collection from 
Rem                           performance names 
Rem    jsadras     01/30/06 - Created
Rem

DECLARE
l_job_name mgmt_performance_names.job_name%TYPE ;
BEGIN
  BEGIN
    SELECT job_name
      INTO l_job_name
      FROM mgmt_performance_names
     WHERE dbms_jobname =  'EMD_COLLECTION.RUN_COLLECTIONS()' ;
  EXCEPTION
  WHEN NO_DATA_FOUND THEN RETURN ;
  END ;

  UPDATE mgmt_system_error_log 
     SET module_name = MGMT_COLLECTION.G_MODULE_NAME
   WHERE module_name = l_job_name ;

  -- old performance log is different from new, so old data will
  -- cause confusion, so deleting , anyway it will be purged after 
  -- 6 hours

  DELETE mgmt_system_performance_log 
  WHERE job_name = l_job_name ;
  
  DELETE mgmt_performance_names 
   WHERE job_name = l_job_name ;

   COMMIT ;
END ;
/

