Rem
Rem $Header: compliance_config_std_indexes.sql 21-nov-2006.08:00:42 groyal Exp $
Rem
Rem compliance_config_std_indexes.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      compliance_config_std_indexes.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      11/20/06 - Remove 11g specific indexes
Rem    groyal      08/25/06 - 
Rem    aragarwa    06/28/06 - Removing importance and adding simple rules. 
Rem    aragarwa    05/19/06 - Adding indexes target columns in compliance 
Rem                           tables. 
Rem    niramach    05/09/06 - 10.3 and 11g table unification. 
Rem    aragarwa    05/01/06 - Fixing not null issue in key table 
Rem    niramach    04/20/06 - Add indexes for cs eval summ and rulefolder eval 
Rem                           summary tables. 
Rem    aragarwa    04/20/06 - Adding 11g table constraints and indexes. 
Rem    groyal      04/03/06 - Add indexes on mgmt_cs_scheduled_eval
Rem    aragarwa    03/06/06 - removing keyword map etc. 
Rem    niramach    01/31/06 - Add primary key constraints for cs evaluation 
Rem                           results tables. 
Rem    aragarwa    01/23/06 - Adding version in cs table. 
Rem    aragarwa    01/13/06 - Constraints and Indexes definition for configuration standard. 
Rem    aragarwa    01/13/06 - Created
Rem


SET ECHO ON

ALTER TABLE mgmt_cs_hierarchy
  ADD CONSTRAINT mgmt_cs_hierarchy_pk
    PRIMARY KEY (parent_guid, child_guid);

ALTER TABLE mgmt_cs_config_standard
  ADD CONSTRAINT mgmt_cs_config_standard_pk
    PRIMARY KEY (cs_guid);
    
ALTER TABLE mgmt_cs_rulefolder
  ADD CONSTRAINT mgmt_cs_rulefolder_pk
    PRIMARY KEY (rulefolder_guid);

ALTER TABLE mgmt_cs_rule
  ADD CONSTRAINT mgmt_cs_rule_pk
    PRIMARY KEY (rule_guid);

ALTER TABLE mgmt_cs_keyword
  ADD CONSTRAINT mgmt_cs_keyword_pk
    PRIMARY KEY (keyword,cs_guid);

CREATE UNIQUE INDEX mgmt_cs_idx_01
  ON mgmt_cs_config_standard(author, cs_iname, version);
  
ALTER TABLE mgmt_cs_scheduled_eval
  ADD CONSTRAINT mgmt_cs_scheduled_eval_pk
    PRIMARY KEY (job_id);
    
CREATE INDEX mgmt_cs_scheduled_eval_idx_01
  ON mgmt_cs_scheduled_eval(cs_guid);


-- Added be arun agarwal, for constraints required by 11g release.

ALTER TABLE mgmt_cs_rulefolder
  ADD CONSTRAINT mgmt_cs_rulefolder_uk
    UNIQUE (cs_guid,rulefolder_iname);

ALTER TABLE mgmt_cs_rule
  ADD CONSTRAINT mgmt_cs_rule_uk
    UNIQUE (cs_guid,rule_iname);

ALTER TABLE mgmt_cs_parameter
  ADD CONSTRAINT mgmt_cs_parameter_pk
    PRIMARY KEY (param_guid);

ALTER TABLE mgmt_cs_parameter
  ADD CONSTRAINT mgmt_cs_parameter_uk
    UNIQUE (cs_guid,param_iname);

ALTER TABLE mgmt_cs_reusable_query
  ADD CONSTRAINT mgmt_cs_reusable_query_pk
    PRIMARY KEY (reusable_query_guid);

ALTER TABLE mgmt_cs_reusable_query
  ADD CONSTRAINT mgmt_cs_reusable_query_uk
    UNIQUE (cs_guid,reusable_query_iname);

ALTER TABLE mgmt_cs_rule_viol_ctx
  ADD CONSTRAINT mgmt_cs_rule_viol_ctx_pk
    UNIQUE (rule_guid,column_iname);

ALTER TABLE mgmt_cs_rule_fix_link
  ADD CONSTRAINT mgmt_cs_rule_fix_link_pk
    PRIMARY KEY ( rule_guid, display_label );

ALTER TABLE mgmt_cs_inclusion
    ADD CONSTRAINT mgmt_cs_inclusion_pk
     PRIMARY KEY (cs_inclusion_guid);

ALTER TABLE mgmt_cs_rqs_inclusion
  ADD CONSTRAINT mgmt_cs_rqs_inclusion_pk
     PRIMARY KEY (rqs_guid);
     
ALTER TABLE mgmt_cs_rqs_inclusion
  ADD CONSTRAINT mgmt_cs_rqs_inclusion_uk
     UNIQUE (root_cs_guid, parent_rqs_guid, cs_inclusion_guid);

ALTER TABLE mgmt_cs_inclusion_parameter
  ADD CONSTRAINT mgmt_cs_inclusion_parameter_pk
     PRIMARY KEY ( cs_inclusion_guid, param_iname);

ALTER TABLE mgmt_cs_rqs_hierarchy
  ADD CONSTRAINT mgmt_cs_rqs_hierarchy_pk
     PRIMARY KEY (child_rqs_guid, parent_guid, child_guid);

ALTER TABLE mgmt_cs_eval_summ_rule
  ADD CONSTRAINT mgmt_cs_eval_summ_rule_pk
     PRIMARY KEY (target_guid, rqs_guid, rule_guid );
     
CREATE UNIQUE INDEX mgmt_cs_eval_summ_rule_idx_01
  ON mgmt_cs_eval_summ_rule(rqs_guid, target_guid, rule_guid);
  
CREATE INDEX mgmt_cs_eval_summ_rule_idx_02
  ON mgmt_cs_eval_summ_rule(root_cs_guid);  

CREATE INDEX mgmt_cs_eval_summ_rule_idx_03
  ON mgmt_cs_eval_summ_rule(root_target_guid);       

ALTER TABLE mgmt_cs_eval_summ_rulefolder
  ADD CONSTRAINT mgmt_cs_eval_summ_rf_pk
     PRIMARY KEY (target_guid,rqs_guid,rulefolder_guid );
     
CREATE UNIQUE INDEX mgmt_cs_eval_summ_rf_idx_01
  ON mgmt_cs_eval_summ_rulefolder(rqs_guid, target_guid, rulefolder_guid);
  
CREATE INDEX mgmt_cs_eval_summ_rf_idx_02
  ON mgmt_cs_eval_summ_rulefolder(root_cs_guid);  

CREATE INDEX  mgmt_cs_eval_summ_rf_idx_03
  ON mgmt_cs_eval_summ_rulefolder(root_target_guid);    

ALTER TABLE mgmt_cs_eval_summ_rqs
  ADD CONSTRAINT mgmt_cs_eval_summ_rqs_pk
     PRIMARY KEY (target_guid,rqs_guid);
     
CREATE UNIQUE INDEX mgmt_cs_eval_summ_idx_01
  ON mgmt_cs_eval_summ_rqs(rqs_guid,target_guid);          

CREATE INDEX mgmt_cs_eval_summ_idx_02
  ON mgmt_cs_eval_summ_rqs(root_cs_guid);
  
CREATE INDEX mgmt_cs_eval_summ_idx_03
  ON mgmt_cs_eval_summ_rqs(root_target_guid);  


ALTER TABLE mgmt_cs_rule_simple_test
  ADD CONSTRAINT mgmt_cs_rule_simple_test_pk
    PRIMARY KEY (rule_guid, position);

CREATE INDEX mgmt_cs_eval_summ_rqs_idx_01
  ON mgmt_cs_eval_summ_rqs(target_guid);

CREATE INDEX mgmt_cs_eval_summ_rf_idx_04
  ON mgmt_cs_eval_summ_rulefolder(target_guid);
  