Rem
Rem $Header: compliance_config_std_metrics.sql 31-aug-2006.05:56:27 groyal Exp $
Rem
Rem compliance_config_std_metrics.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      compliance_config_std_metrics.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      08/31/06 - Change collection interval
Rem    groyal      08/25/06 - Replace total_violations with crit_violations, warn_violations
Rem                           and info_violations, Rework metrics slightly
Rem    sthiruna    06/19/06 - Fix for bug 5307479 
Rem    niramach    05/09/06 - 10.3 and 11g table unification. 
Rem    niramach    03/22/06 - Modify the repository metrics to store the data target wise.
Rem                         - Removed the unnecessary metrics.
Rem    niramach    03/07/06 - Added targets evaluated metric for cs,rule folder and rule
Rem    niramach    03/05/06 - Fixed the collection problem. 
Rem    niramach    02/20/06 - Created
Rem


 
  -- To be called when creating a repository.  This creates all the metrics needed 
  -- to support compliance trend GUI charts. It creates the metrics and sets the 
  -- default collections.  All of the metrics are oracle_emrep metrics.
  --  
  DECLARE
    l_metricColList MGMT_METRIC_COLUMN_ARRAY;

    l_mco_rqs_guid MGMT_METRIC_COLUMN_OBJ; 
    l_mco_object_guid MGMT_METRIC_COLUMN_OBJ; 
    l_mco_root_target_guid MGMT_METRIC_COLUMN_OBJ; 
    l_mco_compliance_score MGMT_METRIC_COLUMN_OBJ;    
    l_mco_crit_violations MGMT_METRIC_COLUMN_OBJ;        
    l_mco_warn_violations MGMT_METRIC_COLUMN_OBJ;        
    l_mco_info_violations MGMT_METRIC_COLUMN_OBJ;        
    l_mco_violation_count MGMT_METRIC_COLUMN_OBJ;        

    l_source_query VARCHAR2(4000);
    

  BEGIN

    -- Set up column descriptors
    
    -- Key columns 
    l_mco_rqs_guid  := MGMT_METRIC_COLUMN_OBJ.NEW( 
      p_column_name=>'RQS_GUID',
      p_column_type=>MGMT_GLOBAL.G_METRIC_TYPE_STRING,
      p_is_key=>MGMT_GLOBAL.G_METRIC_KEY_TRUE,
      p_column_label=>'RQS Guid',
      p_description=>'Identifies the guid of the configuration standard.');                                                                                                                        

    l_mco_object_guid  := MGMT_METRIC_COLUMN_OBJ.NEW( 
      p_column_name=>'OBJECT_GUID',
      p_column_type=>MGMT_GLOBAL.G_METRIC_TYPE_STRING,
      p_is_key=>MGMT_GLOBAL.G_METRIC_KEY_TRUE,
      p_column_label=>'Object Guid',
      p_description=>'Identifies the guid of the configuration standard, 
          folder or rule, depending on the metric.');                                                                                                                        

    l_mco_root_target_guid := MGMT_METRIC_COLUMN_OBJ.NEW( 
      p_column_name=>'ROOT_TARGET_GUID',
      p_column_type=>MGMT_GLOBAL.G_METRIC_TYPE_STRING,
      p_is_key=>MGMT_GLOBAL.G_METRIC_KEY_TRUE,
      p_column_label=>'Target Guid',
      p_description=>'Identifies the target whose compliance is trended.');    

   -- Nonkey columns 
   l_mco_compliance_score := MGMT_METRIC_COLUMN_OBJ.NEW( 
      p_column_name=>'COMPLIANCE_SCORE',
      p_column_type=>MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
      p_is_key=>MGMT_GLOBAL.G_METRIC_KEY_FALSE,
      p_column_label=>'Compliance Score',
      p_description=>'Compliance score of the configuration standard.');
                                            
   l_mco_crit_violations := MGMT_METRIC_COLUMN_OBJ.NEW( 
      p_column_name=>'CRIT_VIOLATIONS',
      p_column_type=>MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
      p_is_key=>MGMT_GLOBAL.G_METRIC_KEY_FALSE,
      p_column_label=>'Critical Violations',
      p_description=>'Count of critical level violation.');

   l_mco_warn_violations := MGMT_METRIC_COLUMN_OBJ.NEW( 
      p_column_name=>'WARN_VIOLATIONS',
      p_column_type=>MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
      p_is_key=>MGMT_GLOBAL.G_METRIC_KEY_FALSE,
      p_column_label=>'Warning Violations',
      p_description=>'Count of warning level violation.');

   l_mco_info_violations := MGMT_METRIC_COLUMN_OBJ.NEW( 
      p_column_name=>'INFO_VIOLATIONS',
      p_column_type=>MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
      p_is_key=>MGMT_GLOBAL.G_METRIC_KEY_FALSE,
      p_column_label=>'Informational Violations',
      p_description=>'Count of information level violation.');

   l_mco_violation_count := MGMT_METRIC_COLUMN_OBJ.NEW( 
      p_column_name=>'VIOLATION_COUNT',
      p_column_type=>MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
      p_is_key=>MGMT_GLOBAL.G_METRIC_KEY_FALSE,
      p_column_label=>'Violation Count',
      p_description=>'Count of violations.');

-- e.rqs_guid as RQS_GUID,

    -- CS_EVAL_SUMM_STANDARD
    l_source_query :=
      'SELECT e.rqs_guid as RQS_GUID,
          e.rqs_guid as OBJECT_GUID,
          e.root_target_guid as ROOT_TARGET_GUID,                
          e.crit_violations AS CRIT_VIOLATIONS,
          e.warn_violations AS WARN_VIOLATIONS,
          e.info_violations AS INFO_VIOLATIONS,
          (e.crit_violations + e.warn_violations + e.info_violations) as VIOLATION_COUNT,
          ROUND(e.compliance_score) as COMPLIANCE_SCORE,          
          rt.target_guid as target_guid
        FROM mgmt_cs_eval_summ_rqs e, mgmt_targets rt   
        WHERE
          rt.target_type = ''' || MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE || '''';

    -- Create metric
    l_metricColList := 
         MGMT_METRIC_COLUMN_ARRAY( l_mco_rqs_guid,          -- key column
                                   l_mco_object_guid,       -- key column
                                   l_mco_root_target_guid,  -- key column                               
                                   l_mco_crit_violations,
                                   l_mco_warn_violations,
                                   l_mco_info_violations,
                                   l_mco_violation_count,
                                   l_mco_compliance_score);

    BEGIN
      --Delete the metric                                   
      MGMT_METRIC.DELETE_METRIC(p_target_type=>MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
        p_metric_name=>'CS_EVAL_SUMM_STANDARD',
        p_type_meta_ver=>MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER);
      EXCEPTION
        WHEN OTHERS THEN NULL;
    END;
                                   

    MGMT_METRIC.CREATE_METRIC( p_target_type=>MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
                               p_metric_name=>'CS_EVAL_SUMM_STANDARD',
                               p_type_meta_ver=>MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER,
                               p_metric_type=>MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
                               p_metric_label=>'Evaluation Summary CS Level',
                               p_usage_type=>MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
                               p_is_repository=>MGMT_GLOBAL.G_TRUE,
                               p_source_type=>MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
                               p_source=>l_source_query,
                               p_metric_column_list=>l_metricColList,                               
                               p_description=>'Tracks evaluation summary information at configuration standard level.');                               

    -- CS_EVAL_SUMM_FOLDER
    l_source_query :=
    'SELECT e.rqs_guid as RQS_GUID,
        e.rulefolder_guid as OBJECT_GUID, 
        e.root_target_guid as ROOT_TARGET_GUID,
        e.crit_violations AS CRIT_VIOLATIONS,
        e.warn_violations AS WARN_VIOLATIONS,
        e.info_violations AS INFO_VIOLATIONS,
        (e.crit_violations + e.warn_violations + e.info_violations) as VIOLATION_COUNT,      
        rt.target_guid as target_guid
      FROM mgmt_cs_eval_summ_rulefolder e, mgmt_targets rt
      WHERE
        rt.target_type = ''' || MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE || '''';

    -- Create metric
    l_metricColList := 
         MGMT_METRIC_COLUMN_ARRAY( l_mco_rqs_guid,            -- key column
                                   l_mco_object_guid,         -- key column
                                   l_mco_root_target_guid,    -- key column
                                   l_mco_crit_violations,
                                   l_mco_warn_violations,
                                   l_mco_info_violations,
                                   l_mco_violation_count);

    BEGIN
      --Delete the metric                                   
      MGMT_METRIC.DELETE_METRIC(p_target_type=>MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
        p_metric_name=>'CS_EVAL_SUMM_FOLDER',
        p_type_meta_ver=>MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER);
      EXCEPTION
        WHEN OTHERS THEN NULL;
    END;
                                   

    MGMT_METRIC.CREATE_METRIC( p_target_type=>MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
                               p_metric_name=>'CS_EVAL_SUMM_FOLDER',
                               p_type_meta_ver=>MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER,
                               p_metric_type=>MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
                               p_metric_label=>'Evaluation Summary Folder Level',
                               p_usage_type=>MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
                               p_is_repository=>MGMT_GLOBAL.G_TRUE,
                               p_source_type=>MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
                               p_source=>l_source_query,
                               p_metric_column_list=>l_metricColList,
                               p_description=>'Tracks evaluation summary information at folder level.');
   

    -- CS_EVAL_SUMM_RULE
    l_source_query :=
    'SELECT e.rqs_guid as RQS_GUID,
        e.rule_guid as OBJECT_GUID,   
        e.root_target_guid as ROOT_TARGET_GUID,
        e.total_violations as VIOLATION_COUNT,
        rt.target_guid as target_guid
      FROM mgmt_cs_eval_summ_rule e, mgmt_targets rt
      WHERE 
        rt.target_type = ''' || MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE || '''';           

    -- Create metric
    l_metricColList := 
         MGMT_METRIC_COLUMN_ARRAY( l_mco_rqs_guid,          -- key column
                                   l_mco_object_guid,       -- key column
                                   l_mco_root_target_guid,  -- key column
                                   l_mco_violation_count);

    BEGIN
      --Delete the metric                                   
      MGMT_METRIC.DELETE_METRIC(p_target_type=>MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
        p_metric_name=>'CS_EVAL_SUMM_RULE',
        p_type_meta_ver=>MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER);
      EXCEPTION
        WHEN OTHERS THEN NULL;
    END;
                                   

    MGMT_METRIC.CREATE_METRIC( p_target_type=>MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
                               p_metric_name=>'CS_EVAL_SUMM_RULE',
                               p_type_meta_ver=>MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER,
                               p_metric_type=>MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
                               p_metric_label=>'Evaluation Summary Rule Level',
                               p_usage_type=>MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
                               p_is_repository=>MGMT_GLOBAL.G_TRUE,
                               p_source_type=>MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
                               p_source=>l_source_query,
                               p_metric_column_list=>l_metricColList,
                               p_description=>'Tracks evaluation summary information at rule level.');

    COMMIT;
    
END;
/


DECLARE
  l_compliance_trend_intvl NUMBER := 360;
  l_emrep_tgt_exists   NUMBER := 1;
  l_emrep_tgt_name     mgmt_targets.target_name%TYPE;
  l_emrep_typ_ver      mgmt_targets.type_meta_ver%TYPE;
BEGIN
    mgmt_collection.add_default_collection(
        p_target_type=>MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
        p_coll_name=>'Compliance repository metric collection',
        p_type_meta_ver=>MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER,
        p_metrics_list=>MGMT_SHORT_STRING_ARRAY('CS_EVAL_SUMM_STANDARD',                                                
                        'CS_EVAL_SUMM_FOLDER',                                                
                        'CS_EVAL_SUMM_RULE'),
        p_coll_schedule=>mgmt_coll_schedule_obj.interval_Schedule(
                p_interval=>l_compliance_trend_intvl,
                p_start_time=>sysdate,
                p_end_time=>null),
                p_auto_enable => MGMT_GLOBAL.G_TRUE                        
        );

    DBMS_OUTPUT.PUT_LINE('**Compliance Trend collection not started.Default Collection added**');                          

  COMMIT;
END;
/

show errors;


