Rem
Rem $Header: compliance_config_std_tables.sql 21-nov-2006.08:00:38 groyal Exp $
Rem
Rem compliance_config_std_tables.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      compliance_config_std_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      11/20/06 - Remove 11g specific tables
Rem    groyal      11/01/06 - Fix defaults in mgmt_cs_rule
Rem    groyal      08/25/06 - Replaced total_violations with crit_violations, 
Rem                           warn_violations and info_violations
Rem    rreilly     07/18/06 - add additional cols to error table 
Rem    aragarwa    06/28/06 - Removing importance and adding simple rules. 
Rem    sthiruna    06/08/06 - Fix for bug 5263883. Adding the column 
Rem                           unknown_rules to mgmt_cs_eval_summ_rulefolder 
Rem                           ,mgmt_cs_eval_summ_rqs 
Rem    aragarwa    06/11/06 - Removing default for rule attributes. 
Rem    aragarwa    05/16/06 - Adding not null for param value. 
Rem    niramach    05/09/06 - 10.3 and 11g table unification. 
Rem    aragarwa    05/01/06 - Fixing not null issue in key table 
Rem    aragarwa    04/10/06 - Adding few more elements in rules and std 
Rem                           tables. Adding 11g Tables and Changes.
Rem    groyal      03/31/06 - Add mgmt_cs_scheduled_eval
Rem    aragarwa    02/28/06 - reflecting XSD and table changes. 
Rem    niramach    03/05/06 - Remove compliance score column from rulefolder 
Rem                           eval summary table. 
Rem    niramach    02/28/06 - Add repo_timing_enabled column for cs defnition 
Rem                           table to enable/disable the performance analysis 
Rem                           of the cs evaluation for a cs.. 
Rem    niramach    01/31/06 - Add table creation scripts for cs evaluation 
Rem                           results schema. 
Rem    aragarwa    01/23/06 - Adding internal name to tables 
Rem    aragarwa    01/13/06 - Configuration standard table creation script. 
Rem    aragarwa    01/13/06 - Created
Rem


Rem ****************************************************************************
Rem MGMT_CS_HIERARCHY table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_hierarchy
(
    parent_guid             RAW(16)        NOT NULL,
    child_guid              RAW(16)        NOT NULL,
    child_type              NUMBER(1)	     NOT NULL,
    child_position          NUMBER         NOT NULL 
)
MONITORING;

COMMENT ON COLUMN mgmt_cs_hierarchy.parent_guid IS
    'The guid of the configuration standard or rule folder containing the rule 
     folder, rule or included configuration standard.';

COMMENT ON COLUMN mgmt_cs_hierarchy.child_guid IS
    'The guid of the rule folder, rule or configuration standard inclusion.';

COMMENT ON COLUMN mgmt_cs_hierarchy.child_type IS
    'The type of guid stored in child_guid. Possible values are:
       = 1, Root Configuration Standard.
       = 2, for rule folder
       = 3, for rule
       = 4, for config standard inclusion';

COMMENT ON COLUMN mgmt_cs_hierarchy.child_position IS
    'Position of child relative to its parent container.';


Rem ****************************************************************************
Rem MGMT_CS_CONFIG_STANDARD table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_config_standard
(
    cs_guid                 RAW(16)        NOT NULL,
    cs_iname                VARCHAR2(128)  NOT NULL,
    cs_dname                VARCHAR2(128)  NOT NULL,
    target_type             VARCHAR2(128)  NOT NULL,
    created_date            DATE           DEFAULT SYSDATE,
    last_updated_date       DATE           DEFAULT SYSDATE,
    last_updated_by         VARCHAR2(256)  DEFAULT '<SYSTEM>',
    author                  VARCHAR2(256)  DEFAULT 'ORACLE',
    owner                   VARCHAR2(256)  DEFAULT '<SYSTEM>',
    version                 NUMBER         DEFAULT 1,
    lifecycle_status        NUMBER(1)      DEFAULT 1,
    usage_type              NUMBER(1)      DEFAULT 1,
    is_locked               NUMBER(1)      DEFAULT 0,
    locked_by               VARCHAR2(256)  DEFAULT NULL,
    locked_time             DATE           DEFAULT NULL,
    is_hidden               NUMBER(1)      DEFAULT 0,
    description             VARCHAR2(256)  DEFAULT ' ',
    reference_url           VARCHAR2(4000) DEFAULT NULL,
    front_matter            VARCHAR2(500)  DEFAULT ' ',
    rear_matter             VARCHAR2(500)  DEFAULT ' ',
    notice                  VARCHAR2(500)  DEFAULT ' ',
    repo_timing_enabled     NUMBER(1)      DEFAULT 0,
    cqs_package_name        VARCHAR2(30)   DEFAULT NULL,
    cqs_date                DATE           DEFAULT NULL,
    cqs_valid               NUMBER(1)      DEFAULT 0,
    rqs_hierarchy_valid     NUMBER(1)      DEFAULT 0
)
MONITORING;

COMMENT ON TABLE mgmt_cs_config_standard IS
    'This table provides the configuration standard definition.';

COMMENT ON COLUMN mgmt_cs_config_standard.cs_guid IS
    'The unique Id of the configuration standard.';

COMMENT ON COLUMN mgmt_cs_config_standard.cs_iname IS
    'The internal name of the configuration standard.';

COMMENT ON COLUMN mgmt_cs_config_standard.cs_dname IS
    'The display name of the configuration standard.';

COMMENT ON COLUMN mgmt_cs_config_standard.target_type IS
    'The target type for which this compliance standard is written.
    10.3 : this is required for policy identification written in rule test.
    11GC: corresponding CMDB class will be identified thru this target type.';

COMMENT ON COLUMN mgmt_cs_config_standard.created_date IS
    'The date/time when the configuration standard was created.';

COMMENT ON COLUMN mgmt_cs_config_standard.last_updated_date IS
    'The date/time when the configuration standard was last modified.';

COMMENT ON COLUMN mgmt_cs_config_standard.last_updated_by IS
    'The EM user name who last modified this configuration standard.';

COMMENT ON COLUMN mgmt_cs_config_standard.author IS
    'The author of the configuration standard.';

COMMENT ON COLUMN mgmt_cs_config_standard.owner IS
    'The EM user who create the configuration standard in the repository.';

COMMENT ON COLUMN mgmt_cs_config_standard.version IS
    'The version number of the configuration standard.';

COMMENT ON COLUMN mgmt_cs_config_standard.lifecycle_status IS
    'Lifecycle status of the configuration standard.  Possible values are:
       = 1, for DEVELOPMENT
       = 2, for PRODUCTION
       = 3, for RETIRED';

COMMENT ON COLUMN mgmt_cs_config_standard.usage_type IS
    'Indicates configuration standard type. Possible values are:
	= 1, for CONFIGURATION
	= 2, for MONITORING';

COMMENT ON COLUMN mgmt_cs_config_standard.is_locked IS
    'Indicates configuration standard is locked for editing.';

COMMENT ON COLUMN mgmt_cs_config_standard.is_hidden IS
    'Indicates configuration standard is hidden.';

COMMENT ON COLUMN mgmt_cs_config_standard.description IS
    'The description of the configuration standard.';

COMMENT ON COLUMN mgmt_cs_config_standard.reference_url IS
    'URL to be used for additional detailed information regarding the configuration
     standard.  Intended for use only for non-Oracle provided configuration
     standards.';

COMMENT ON COLUMN mgmt_cs_config_standard.front_matter IS
    'The introductory text of the configuration standard that appears at or near the 
     beginning of a generated document.  Intended for use only during report generation.';

COMMENT ON COLUMN mgmt_cs_config_standard.rear_matter IS
    'The concluding text of the configuration standard that appears at or near the 
     end of a generated document.  Intended for use only during report generation.';

COMMENT ON COLUMN mgmt_cs_config_standard.notice IS
    'Supplies legal notice or copyrith text about configuration standard.  Intended for 
     use only during report generation.';

COMMENT ON COLUMN mgmt_cs_config_standard.repo_timing_enabled IS
    'Flag indicating whether the configuration standard times are logged or not.
     0 = Timing information is not logged to system performance log,
     1 = Timing information is logged to system performance log' ;    

COMMENT ON COLUMN mgmt_cs_config_standard.cqs_package_name IS
    'Package name that has the compiled DMQL statements for this standard.';

COMMENT ON COLUMN mgmt_cs_config_standard.cqs_date IS
    'Last date and time when CS query was compiled successfully.';

COMMENT ON COLUMN mgmt_cs_config_standard.cqs_valid IS
    'Whether the compilation of these DMQLs stands valid or not:
	0 = Not a valid compile.
	1 = Valid compilation. ';

COMMENT ON COLUMN mgmt_cs_config_standard.rqs_hierarchy_valid IS
    'Whether the standard hierarchy is changed and marked as invalid :
	0 = RQS hierachy is invalid.
	1 = RQS hierachy is valid.';

Rem ****************************************************************************
Rem MGMT_CS_RULEFOLDER table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_rulefolder
(
    rulefolder_guid         RAW(16)        DEFAULT SYS_GUID(),
    cs_guid                 RAW(16)        NOT NULL,
    rulefolder_iname        VARCHAR2(128)  NOT NULL,
    rulefolder_dname        VARCHAR2(128)  NOT NULL,
    description             VARCHAR2(256)  DEFAULT ' ',
    reference_url           VARCHAR2(4000) DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_cs_rulefolder IS
    'This table provides the rule folder definition.';

COMMENT ON COLUMN mgmt_cs_rulefolder.rulefolder_guid IS
    'The unique Id of the rule folder.';

COMMENT ON COLUMN mgmt_cs_rulefolder.cs_guid IS
    'The unique Id of the configuration standard that contains this rule folder.';

COMMENT ON COLUMN mgmt_cs_rulefolder.rulefolder_iname IS
    'The internal name of the rule folder.';

COMMENT ON COLUMN mgmt_cs_rulefolder.rulefolder_dname IS
    'The display name of the rule folder.';

COMMENT ON COLUMN mgmt_cs_rulefolder.description IS
    'The description of the rule folder.';

COMMENT ON COLUMN mgmt_cs_rulefolder.reference_url IS
    'URL to be used for additional detailed information regarding the rule
     folder.  Intended for use only for non-Oracle provided configuration
     standards.';



Rem ****************************************************************************
Rem MGMT_CS_RULE table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_rule
(
    rule_guid               RAW(16)        DEFAULT SYS_GUID(),
    cs_guid                 RAW(16)        NOT NULL,
    rule_iname              VARCHAR2(128)  NOT NULL,
    rule_dname              VARCHAR2(128)  NOT NULL,
    importance_level        NUMBER(1)      DEFAULT 3,
    description             VARCHAR2(256)  DEFAULT ' ',
    reference_url           VARCHAR2(4000) DEFAULT NULL,
    rationale               VARCHAR2(500)  DEFAULT ' ',
    fixtext                 VARCHAR2(500)  DEFAULT ' ',
    warning                 VARCHAR2(500)  DEFAULT ' ',
    test_type               NUMBER(1)      DEFAULT NULL,
    test                    VARCHAR2(4000) DEFAULT NULL,
    policy_guid             RAW(16)	   DEFAULT NULL,
    change_advisor_type     VARCHAR2(256)  DEFAULT NULL,
    change_advisor_subtype  VARCHAR2(256)  DEFAULT NULL,
    change_advisor_reason   VARCHAR2(256)  DEFAULT NULL,
    message                 VARCHAR2(4000) DEFAULT ' ',
    clear_message           VARCHAR2(4000) DEFAULT ' ',
    severity                NUMBER(1)      DEFAULT NULL,
    simple_test_condition   NUMBER(1)      DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_cs_rule IS
    'This table provides the rule definition.';

COMMENT ON COLUMN mgmt_cs_rule.rule_guid IS
    'The unique Id of the rule.';

COMMENT ON COLUMN mgmt_cs_rule.cs_guid IS
    'The unique Id of the configuration standard that contains this rule.';

COMMENT ON COLUMN mgmt_cs_rule.rule_iname IS
    'The internal name of the rule.';

COMMENT ON COLUMN mgmt_cs_rule.rule_dname IS
    'The display name of the rule.';

COMMENT ON COLUMN mgmt_cs_rule.importance_level IS
    'Value used to indicate relative importance of this rule within the configuration
     standard.  Possible values are:
       = 0, for NOT SCORED
       = 1, for EXTREMELY LOW
       = 2, for LOW
       = 3, for NORMAL
       = 4, for HIGH
       = 5, for EXTREMELY HIGH';

COMMENT ON COLUMN mgmt_cs_rule.description IS
    'The description of the rule.';

COMMENT ON COLUMN mgmt_cs_rule.reference_url IS
    'URL to be used for additional detailed information regarding the rule.
     Intended for use only for non-Oracle provided configuration
     standards.';

COMMENT ON COLUMN mgmt_cs_rule.rationale IS
    'Explains why this rule is important; that is, it is used to report the
     possible consequences of having a violation of the rule.';

COMMENT ON COLUMN mgmt_cs_rule.fixtext IS
    'Explains how to bring a system back into compliance with this rule.';

COMMENT ON COLUMN mgmt_cs_rule.warning IS
    'Provides a cautionary note or caveat about the fule; for example, Complying with this rule
     will cause the system to reject all IP packets.';

COMMENT ON COLUMN mgmt_cs_rule.test_type IS
    'The type of rule. Possible values are:
       = 1, for 11G style rule, written in DMQL.
       = 2, for 10G policy';

COMMENT ON COLUMN mgmt_cs_rule.test IS
    'The test for the rule.  If test_type = 1, this column contains a string written using
     the DMQL language.  If test_type = 2, this column contains the name of the
     10G policy.';

COMMENT ON COLUMN mgmt_cs_rule.policy_guid IS
    'If test_type = 2 (10G policy), this column contains the guid of the 10G policy.';

COMMENT ON COLUMN mgmt_cs_rule.change_advisor_type IS
    'Change Advisor specific column.  Identified the violation type.';

COMMENT ON COLUMN mgmt_cs_rule.change_advisor_subtype IS
    'Change Advisor specific column.  Identified the violation subtype.';

COMMENT ON COLUMN mgmt_cs_rule.change_advisor_reason IS
    'Change Advisor specific column.  Identified the violation reason.';

COMMENT ON COLUMN mgmt_cs_rule.message IS
    'NLS message-id recorded along with the violation. Used for different event notifications.'; 

COMMENT ON COLUMN mgmt_cs_rule.clear_message IS
    'NLS message-id recorded along with clearing of a violation. Used for different event notifications.'; 

COMMENT ON COLUMN mgmt_cs_rule.severity IS
    'Violation Severity for events. Possible values are :
      = 1, Informational,
      = 2, Warning,
      = 3, Critical ';

COMMENT ON COLUMN mgmt_cs_rule.simple_test_condition IS
    'To determine whether all simple test expressions to be ORed or ANDed. 
     Possible values are :
      = 1, AND,
      = 2, OR ' ;

Rem ****************************************************************************
Rem MGMT_CS_KEYWORD table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_keyword
(
    keyword                 VARCHAR2(64)   NOT NULL,
    cs_guid                 RAW(16)        NOT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_cs_keyword IS
    'This table provides the keyword definition.';

COMMENT ON COLUMN mgmt_cs_keyword.keyword IS
    'Name of the keyword.';

COMMENT ON COLUMN mgmt_cs_keyword.cs_guid IS
    'The configuration standard guid.';


Rem ****************************************************************************
Rem MGMT_CS_PARAMETER table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_parameter
(
    param_guid              RAW(16)        DEFAULT SYS_GUID(),
    cs_guid                 RAW(16)        NOT NULL,
    param_iname             VARCHAR2(128)  NOT NULL,
    param_type              NUMBER(1)      DEFAULT 1,
    param_value             VARCHAR2(1024) NOT NULL,
    description             VARCHAR2(256)  DEFAULT ' ',
    prohibit_changes        NUMBER(1)      DEFAULT 0,
    num_choices             NUMBER         DEFAULT 0,
    must_match              NUMBER(1)      DEFAULT 0,
    lower_bound             NUMBER,
    upper_bound             NUMBER
)
MONITORING;

COMMENT ON TABLE mgmt_cs_parameter IS
    'This table provides the parameter definition.';

COMMENT ON COLUMN mgmt_cs_parameter.param_guid IS
    'The unique Id of the parameter.';

COMMENT ON COLUMN mgmt_cs_parameter.cs_guid IS
    'The configuration standard guid.';

COMMENT ON COLUMN mgmt_cs_parameter.param_iname IS
    'Name of the parameter.';

COMMENT ON COLUMN mgmt_cs_parameter.param_type IS
    'The type of parameter.  Possible values are:
       = 1, for NUMBER
       = 2, for STRING';

COMMENT ON COLUMN mgmt_cs_parameter.param_value IS
    'The parameter value.';

COMMENT ON COLUMN mgmt_cs_parameter.description IS
    'The description of the parameter.';

COMMENT ON COLUMN mgmt_cs_parameter.prohibit_changes IS
    'Indicates parameter can not be customized.';

COMMENT ON COLUMN mgmt_cs_parameter.must_match IS
    'Indicates parameter value must match the values specified by the choice list.';

COMMENT ON COLUMN mgmt_cs_parameter.lower_bound IS
    'Minimum legal value for the parameter value; that is, when overriding 
     the parametervalue the number must be no less than this number. Applicable
     only when param_type = 1 (NUMBER).';

COMMENT ON COLUMN mgmt_cs_parameter.upper_bound IS
    'Maxium legal value for the parameter value; that is, when overriding 
    the parametervalue the number must be no greater than this number. Applicable
    only when param_type = 1  (NUMBER).';


Rem ****************************************************************************
Rem MGMT_CS_PARAMETER_CHOICES table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_parameter_choices
(
    param_guid              RAW(16)        NOT NULL,
    choice_value            VARCHAR2(1024)     
)
MONITORING;

COMMENT ON TABLE mgmt_cs_parameter_choices IS
    'This table provides the legal or suggested values for a parameter.';

COMMENT ON COLUMN mgmt_cs_parameter_choices.param_guid IS
    'The unique Id of the parameter.';

COMMENT ON COLUMN mgmt_cs_parameter_choices.choice_value IS
    'The choice value.';


Rem ****************************************************************************
Rem MGMT_CS_REUSABLE_QUERY table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_reusable_query
(
    reusable_query_guid     RAW(16)        DEFAULT SYS_GUID(),
    cs_guid                 RAW(16)        NOT NULL,
    reusable_query_iname    VARCHAR2(128)  NOT NULL,
    description             VARCHAR2(256)  DEFAULT ' ',
    reusable_query          VARCHAR2(4000) NOT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_cs_reusable_query IS
    'This table provides the reusable query definition.';

COMMENT ON COLUMN mgmt_cs_reusable_query.cs_guid IS
    'The configuration standard guid.';

COMMENT ON COLUMN mgmt_cs_reusable_query.reusable_query_guid IS
    'The unique Id of the reusable query.';

COMMENT ON COLUMN mgmt_cs_reusable_query.reusable_query_iname IS
    'The name of the reusable query.';

COMMENT ON COLUMN mgmt_cs_reusable_query.description IS
    'The description of the reusable query.';

COMMENT ON COLUMN mgmt_cs_reusable_query.reusable_query IS
    'The reusable query expressed using DMQL.';



Rem ****************************************************************************
Rem MGMT_CS_RULE_VIOL_CTX table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_rule_viol_ctx
(
    rule_guid               RAW(16)        NOT NULL,
    column_iname            VARCHAR2(128)  NOT NULL,
    column_dname            VARCHAR2(128),
    column_type             NUMBER(1)      DEFAULT 1,
    column_position         NUMBER         DEFAULT 0,
    is_key                  NUMBER(1)      DEFAULT 1,
    is_hidden               NUMBER(1)      DEFAULT 0,
    link_template           VARCHAR2(4000) DEFAULT NULL,
    link_encode             NUMBER(1)      DEFAULT 1,
    is_link_em_page         NUMBER(1)      DEFAULT 1
)
MONITORING;

COMMENT ON TABLE mgmt_cs_rule_viol_ctx IS
    'This table defines rule violation context for all rules.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.rule_guid IS
    'The rule guid.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.column_iname IS
    'The internal name of the column.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.column_dname IS
    'The display name of the column.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.column_type IS
    'The datatype of this column, possible values are:
	= 1, Number
	= 2, Varchar2.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.column_position IS
    'The position of the column within the violation context definition.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.is_key IS
    'Indicates the column is a key column.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.is_hidden IS
    'Indicates if the column value should be displayed when viewing 
     a violation. Possible values :
        = 0, show this column when viewing the violation
	= 1, hide this coulmn when viewing the violation.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.link_template IS
    'URL template that contains references to any column name that is part
     of the violation context definition.  The actual values are substituted
     at run time to construct the URL that is associated with the column value.';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.link_encode IS
    'Indicates how the encoding should be performed.  Possible values are:
       = 1, for JSP
       = 2, for UIX';

COMMENT ON COLUMN mgmt_cs_rule_viol_ctx.is_link_em_page IS
    'Indicates if the URL is an EM page. Possible values are :
       = 0, URL to a page outside EM
       = 1, URL to EM page.';


Rem ****************************************************************************
Rem MGMT_CS_RULE_FIX_LINK table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_rule_fix_link
(
    rule_guid               RAW(16)        NOT NULL,
    display_label           VARCHAR2(256)  NOT NULL,
    link_template           VARCHAR2(4000) DEFAULT NULL,
    link_encode             NUMBER(1)      DEFAULT 1,
    is_link_em_page         NUMBER(1)      DEFAULT 1
)
MONITORING;

COMMENT ON TABLE mgmt_cs_rule_fix_link IS
    'This table defines fix links for all rules.';

COMMENT ON COLUMN mgmt_cs_rule_fix_link.rule_guid IS
    'The rule guid.';

COMMENT ON COLUMN mgmt_cs_rule_fix_link.display_label IS
    'The display label for the fix link.';

COMMENT ON COLUMN mgmt_cs_rule_fix_link.link_template IS
    'URL template that contains references to any column name that is part
     of the rule violation context definition.  The actual values are substituted
     at run time to construct the URL that is associated with the fix link.';

COMMENT ON COLUMN mgmt_cs_rule_fix_link.link_encode IS
    'Indicates how the encoding should be performed.  Possible values are:
       = 1, for JSP
       = 2, for UIX';

COMMENT ON COLUMN mgmt_cs_rule_fix_link.is_link_em_page IS
    'Indicates if the URL is an EM page. Possible values are :
       = 0, URL to a page outside EM
       = 1, URL to EM page.';


Rem ****************************************************************************
Rem MGMT_CS_RULE_SIMPLE_TEST table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_rule_simple_test
(
    rule_guid               RAW(16)         NOT NULL,
    property                VARCHAR2(4000)  NOT NULL,
    operator                NUMBER(1)       NOT NULL,
    value                   VARCHAR2(4000)  NOT NULL,
    position                NUMBER          NOT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_cs_rule_simple_test IS
    'This table keeps the property operator and value combinations.' ;

COMMENT ON COLUMN mgmt_cs_rule_simple_test.rule_guid IS
    'The rule guid, for which this simple test is written.';

COMMENT ON COLUMN mgmt_cs_rule_simple_test.property IS
    'The CMDB property which is defined to create a DMQL statement and
     this property gets values thru context classes( in CMDB )';

COMMENT ON COLUMN mgmt_cs_rule_simple_test.operator IS
    'The possible operators between properties and values, to make a condition
     in simple rule. possible operator values are:
     = 1, stands for <
     = 2, stands for >
     = 3, stands for <=
     = 4, stands for >=
     = 5, stands for =
     = 6, stands for != ';

COMMENT ON COLUMN mgmt_cs_rule_simple_test.value IS
    'Value is the value against which property needs to be tested, using given
     operator to create expression between property and value.
     eventually, all such condionts create the DMQL 
     statement for getting data from repository.';

COMMENT ON COLUMN mgmt_cs_rule_simple_test.position IS
     'Position of the expression in UI, for UI consistency.';


Rem ****************************************************************************
Rem MGMT_CS_SCHEDULED_EVAL table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_scheduled_eval
(
    cs_guid          RAW(16)        NOT NULL,
    job_id           RAW(16)        NOT NULL,
    eval_name        VARCHAR2(64)   NOT NULL,
    eval_owner       VARCHAR2(256)  NOT NULL,
    eval_description VARCHAR2(4000)
)
MONITORING;

COMMENT ON TABLE mgmt_cs_scheduled_eval IS
    'This table provides the list of all scheduled evaluations.';

COMMENT ON COLUMN mgmt_cs_scheduled_eval.cs_guid IS
    'The unique id of the configuration standard.';
    
COMMENT ON COLUMN mgmt_cs_scheduled_eval.job_id IS
    'The unique id of the evaluation job.';
    
COMMENT ON COLUMN mgmt_cs_scheduled_eval.eval_name IS
    'The name of the scheduled evaluation.';

COMMENT ON COLUMN mgmt_cs_scheduled_eval.eval_owner IS
    'The owner of the scheduled evaluation.';
  
COMMENT ON COLUMN mgmt_cs_scheduled_eval.eval_description IS
    'The description of the scheduled evaluation.';

-- Tables added by arun agarwal  -- for Rachel R. CS Evaluation work...

Rem ****************************************************************************
Rem MGMT_CS_INCLUSION table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_inclusion  
(
    cs_inclusion_guid       RAW(16)        DEFAULT SYS_GUID(),
    parent_cs_guid          RAW(16)        NOT NULL,
    included_cs_iname       VARCHAR2(128)  NOT NULL,
    included_cs_author      VARCHAR2(256)  NOT NULL,
    included_cs_version     NUMBER         NOT NULL,
    context_query           VARCHAR2(4000) DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_cs_inclusion IS
    'This table provides configuration standard inclusion definition.';

COMMENT ON COLUMN mgmt_cs_inclusion.cs_inclusion_guid IS
    'The unique Id of the configuration standard inclusion.';

COMMENT ON COLUMN mgmt_cs_inclusion.parent_cs_guid IS
    'The unique id of the configuration standard which is including other CS.';

COMMENT ON COLUMN mgmt_cs_inclusion.included_cs_iname IS
    'The internal name of the included configuration standard.';

COMMENT ON COLUMN mgmt_cs_inclusion.included_cs_author IS
    'The author of the included configuration standard.';

COMMENT ON COLUMN mgmt_cs_inclusion.included_cs_version IS
    'The version number of the included configuration standard.';

COMMENT ON COLUMN mgmt_cs_inclusion.context_query IS
    'The query, expressed using DMQL, that will be used to pass the list of 
    instances to be evaluated by the including configuration standard.';


Rem ****************************************************************************
Rem MGMT_CS_INCLUSION_PARAMETER table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_inclusion_parameter
(
    cs_inclusion_guid       RAW(16)        NOT NULL,
    param_iname             VARCHAR(128)   NOT NULL, 
    param_override_value    VARCHAR2(1024) NOT NULL,
    ref_param_iname         VARCHAR(128)   DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE  mgmt_cs_inclusion_parameter IS
    'This table keeps information for overridden parameters between standards.';
COMMENT ON COLUMN mgmt_cs_inclusion_parameter.param_iname IS
    'Parameter name, which has been overridden. Involved CSs can be found out thru
     CS inclusion guid';
COMMENT ON COLUMN mgmt_cs_inclusion_parameter.cs_inclusion_guid IS
    'An inclusion GUID which would uniquely identify the entities involved here.';
COMMENT ON COLUMN mgmt_cs_inclusion_parameter.param_override_value IS
    'New value for the parameter.';
COMMENT ON COLUMN mgmt_cs_inclusion_parameter.ref_param_iname IS
    'A parameter value may be associated with parents parameter value. if parent value
     gets updated, referenced parameters values should also be updated.';


Rem ****************************************************************************
Rem MGMT_CS_RQS_INCLUSION table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_rqs_inclusion  
(
    rqs_guid                RAW(16)        DEFAULT SYS_GUID(),
    parent_rqs_guid         RAW(16)        DEFAULT '00000000000000000000000000000000' NOT NULL,
    cs_inclusion_guid       RAW(16)        NOT NULL,
    root_cs_guid            RAW(16)        NOT NULL,
    parent_cs_guid          RAW(16)        NOT NULL,
    included_cs_guid        RAW(16)        NOT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_cs_rqs_inclusion IS
    'table for included standards to uniquely qualify their relationship path.';
COMMENT ON COLUMN mgmt_cs_rqs_inclusion.rqs_guid IS
    'a unique runtime id, for this Query Set inclusion.';
COMMENT ON COLUMN mgmt_cs_rqs_inclusion.parent_rqs_guid IS
    'Parent runtime query set id. This helps determining target context for included stds.';
COMMENT ON COLUMN mgmt_cs_rqs_inclusion.cs_inclusion_guid IS
    'inclusion relationship identifier, to get included CS context query and 
    parameter override values.';
COMMENT ON COLUMN mgmt_cs_rqs_inclusion.root_cs_guid IS
    'Root CS which leads the generation of this rqs guid.';
COMMENT ON COLUMN mgmt_cs_rqs_inclusion.included_cs_guid  IS
    'GUID of standard which is being included in this standard.';
COMMENT ON COLUMN mgmt_cs_rqs_inclusion.parent_cs_guid IS
    'GUID of parent standard which is including this standard.';


Rem ****************************************************************************
Rem MGMT_CS_RQS_HIERARCHY table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_rqs_hierarchy  
(
    child_rqs_guid          RAW(16),
    root_cs_guid            RAW(16)        NOT NULL,
    child_guid              RAW(16)        NOT NULL,
    child_type              NUMBER(1)      NOT NULL,
    child_position          NUMBER         NOT NULL,
    parent_rqs_guid         RAW(16)        DEFAULT '00000000000000000000000000000000' NOT NULL,
    parent_guid             RAW(16)        DEFAULT '00000000000000000000000000000000' NOT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_cs_rqs_hierarchy IS
    'a hierarchy table for complete included standard elements like RF and Rules.';
COMMENT ON COLUMN mgmt_cs_rqs_hierarchy.child_rqs_guid IS
    'Unique runtime id for query set. RFs and Rules will have RQS ids of query set 
     they belong to.';
COMMENT ON COLUMN mgmt_cs_rqs_hierarchy.parent_rqs_guid IS
    'RQS guid for parent counterpart in hierarchy relationship.';
COMMENT ON COLUMN mgmt_cs_rqs_hierarchy.root_cs_guid IS
    'top-level CS which leads the generation of this rqs guid.';
COMMENT ON COLUMN mgmt_cs_rqs_hierarchy.parent_guid IS
    'Guid of the parent container. This can be guid of standard or Rulefolder.';
COMMENT ON COLUMN mgmt_cs_rqs_hierarchy.child_guid IS
    'Guid of child. This can be guid of standard or Rulefolder or a Rule. This guid would never be an inclusion guid if CS is child then CS guid would be used.';
COMMENT ON COLUMN mgmt_cs_rqs_hierarchy.child_type IS
    'The type of guid stored in child_guid. Possible values are:
       = 1, for root configuration standard.
       = 2, for rule folder
       = 3, for rule
       = 4, for config standard inclusion';
COMMENT ON COLUMN mgmt_cs_rqs_hierarchy.child_position IS
    'The position of child in rqs hierarchy tree.';


-- aragarwa -- Evaluation results tables...

Rem ****************************************************************************
Rem MGMT_CS_EVAL_SUMM_RULE table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_eval_summ_rule
(
    rqs_guid                    RAW(16),
    target_guid                 RAW(16),
    rule_guid                   RAW(16),
    root_cs_guid                RAW(16)        NOT NULL,
    root_target_guid            RAW(16)        NOT NULL,
    total_violations            NUMBER         DEFAULT 0 NOT NULL,
    status                      NUMBER(1)      DEFAULT 1 NOT NULL,
    evaluation_date             DATE           NOT NULL
)
MONITORING ;

COMMENT ON TABLE mgmt_cs_eval_summ_rule IS
    'A table which keeps rollup of violation counts for each rule/target combination.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rule.rqs_guid IS
    'unique id for this query set.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rule.target_guid IS
    'The EM target guid.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rule.rule_guid IS
    'The rule id which is summerized here.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rule.root_cs_guid IS
    'CS for which  the evaluation was requested.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rule.root_target_guid IS
    'Target for which the evaluation was requested.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rule.total_violations IS
    'This column suggests total number of violations for this rule/target combination.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rule.status IS
    'This is a validity status for this violation for given rule. possible values are:
    = 0, Rule has ERROR status
    = 1, status is valid.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rule.evaluation_date IS
    'This is start time for last RQS evaluation.';


Rem ****************************************************************************
Rem MGMT_CS_EVAL_SUMM_RULEFOLDER table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_eval_summ_rulefolder
(
    rqs_guid                    RAW(16),
    target_guid                 RAW(16),
    rulefolder_guid             RAW(16),
    root_cs_guid                RAW(16)        NOT NULL,
    root_target_guid            RAW(16)        NOT NULL,
    compliant_rules             NUMBER         DEFAULT 0 NOT NULL,
    non_compliant_rules         NUMBER         DEFAULT 0 NOT NULL,
    error_rules                 NUMBER         DEFAULT 0 NOT NULL,
    unknown_rules               NUMBER         DEFAULT 0 NOT NULL,
    crit_violations             NUMBER         DEFAULT 0 NOT NULL,
    warn_violations             NUMBER         DEFAULT 0 NOT NULL,
    info_violations             NUMBER         DEFAULT 0 NOT NULL
)
MONITORING ;

COMMENT ON TABLE mgmt_cs_eval_summ_rulefolder IS
    'A table which keeps rollup of violation counts for each rulefolder/target combination.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.rqs_guid IS
    'unique id for this query set.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.target_guid IS
    'the EM target guid.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.rulefolder_guid IS
    'The rulefolder id which is summerized here.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.root_cs_guid IS
    'CS for which  the evaluation was requested.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.root_target_guid IS
    'target for which the evaluation was requested.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.crit_violations IS
    'Count of critical-level violations for this rulefolder/target combination.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.warn_violations IS
    'Count of warning-level violations for this rulefolder/target combination.'; 
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.info_violations IS
    'Count of informational-level violations for this rulefolder/target combination.';  
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.error_rules IS
    'Count of all rules with errors.'	;
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.compliant_rules IS
    'Count of all rules which are in compliance.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.non_compliant_rules IS
    'Count of all rules which are not in compliance.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rulefolder.unknown_rules IS
    'Count of all rules which are not evaluated.';



Rem ****************************************************************************
Rem MGMT_CS_EVAL_SUMM_RQS table
Rem ****************************************************************************

CREATE TABLE mgmt_cs_eval_summ_rqs
(
    rqs_guid                    RAW(16),
    root_cs_guid                RAW(16),
    root_target_guid            RAW(16),
    target_guid                 RAW(16),
    compliant_rules             NUMBER         DEFAULT 0 NOT NULL,
    non_compliant_rules         NUMBER         DEFAULT 0 NOT NULL,
    error_rules                 NUMBER         DEFAULT 0 NOT NULL,
    unknown_rules               NUMBER         DEFAULT 0 NOT NULL,
    crit_violations             NUMBER         DEFAULT 0 NOT NULL,
    warn_violations             NUMBER         DEFAULT 0 NOT NULL,
    info_violations             NUMBER         DEFAULT 0 NOT NULL,
    last_evaluation_date        DATE           DEFAULT SYSDATE,    
    compliance_score            NUMBER         DEFAULT NULL
)
MONITORING ;

COMMENT ON TABLE mgmt_cs_eval_summ_rqs IS
    'A table which keeps rollup of violation counts for each cs/target combination.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.rqs_guid IS
    'unique id for this query set.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.target_guid IS
    'the EM target guid.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.root_cs_guid IS
    'CS for which  the evaluation was requested.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.root_target_guid IS
    'target for which the evaluation was requested.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.crit_violations IS
    'Count of critical-level violations for this cs/target combination.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.warn_violations IS
    'Count of warning-level violations for this cs/target combination.'; 
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.info_violations IS
    'Count of informational-level violations for this cs/target combination.'; 
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.error_rules IS
    'Count of all rules with errors.'	;
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.compliant_rules IS
    'Count of all rules which are in compliance.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.non_compliant_rules IS
    'Count of all rules which are not in compliance.';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.last_evaluation_date IS
    'Last Date of evaluation of a configuration standard for a target.';    
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.compliance_score IS
    'This stores compliance score ';
COMMENT ON COLUMN mgmt_cs_eval_summ_rqs.unknown_rules IS
    'Count of all rules which are not evaluated.';


