Rem
Rem $Header: compliance_config_std_types.sql 25-aug-2006.09:21:22 groyal Exp $
Rem
Rem compliance_config_std_types.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      compliance_config_std_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      08/25/06 - Cleaning up unused and duplicate types
Rem    rreilly     07/13/06 - 
Rem    aragarwa    06/28/06 - Removing severity element from rule. 
Rem    rreilly     06/29/06 - added types for cs eval 
Rem    sthiruna    06/09/06 - Fix for bug 5263883 
Rem    aragarwa    06/01/06 - Adding new types for supporting export. 
Rem    aragarwa    05/01/06 - Fixing not null issue in key table 
Rem    aragarwa    04/11/06 - adding parameters type. 
Rem    aragarwa    03/02/06 - Adding types for keyword,param and reusable 
Rem                           tests. 
Rem    aragarwa    01/31/06 - Changing compliance table names. 
Rem    niramach    01/16/06 - Configuration standard types.
Rem    niramach    01/16/06 - Created
Rem

CREATE OR REPLACE TYPE MGMT_CS_GUID_ARRAY IS TABLE OF RAW(16);
/

CREATE OR REPLACE TYPE MGMT_CS_KEYWORD_ARRAY IS TABLE OF VARCHAR2(64);
/

CREATE OR REPLACE TYPE MGMT_CS_CHOICE_LIST_ARRAY IS TABLE OF VARCHAR2(1024);
/

-- aragarwa: definition object for Parameters...

CREATE OR REPLACE TYPE MGMT_CS_PARAM_DEF IS OBJECT
(
     param_name         VARCHAR2(128),
     description        VARCHAR2(256),
     param_type         NUMBER,
     value              VARCHAR2(1024),
     prohibit_changes   NUMBER,
     lower_bound        NUMBER,
     upper_bound        NUMBER,
     choice_list        MGMT_CS_CHOICE_LIST_ARRAY,
     must_match         NUMBER(1)
);
/

-- Array object for parameters definition...

CREATE OR REPLACE TYPE MGMT_CS_PARAM_ARRAY IS TABLE OF MGMT_CS_PARAM_DEF;
/

-- aragarwa: definition object for reusable queries...
CREATE OR REPLACE TYPE MGMT_CS_REUSABLE_QUERY_DEF IS OBJECT
(
 query_name         VARCHAR2(128),
 description        VARCHAR2(256),
 query              VARCHAR2(4000)
 );
/

-- Array object for reusable queries definition...
CREATE OR REPLACE TYPE MGMT_CS_REUSABLE_QUERY_ARRAY IS TABLE OF MGMT_CS_REUSABLE_QUERY_DEF;
/


-- aragarwa: Definition object for parameter overriding...
CREATE OR REPLACE TYPE MGMT_CS_PARAM_OVER_DEF IS OBJECT
(
 parameter_name         VARCHAR2(128),
 parameter_value        VARCHAR2(1024),
 parameter_reference    VARCHAR2(128)
 );
/

-- Array object for parameter overriding definition...

CREATE OR REPLACE TYPE MGMT_CS_PARAM_OVER_ARRAY IS TABLE OF MGMT_CS_PARAM_OVER_DEF;
/

-- aragarwa : definition object for Violation Context Column...

CREATE OR REPLACE TYPE MGMT_CS_VIOL_COLUMN_DEF IS OBJECT
(
 column_iname           VARCHAR2(128),
 column_dname           VARCHAR2(128),
 is_hidden              NUMBER(1),
 is_key                 NUMBER(1),
 link_value             VARCHAR2(4000),
 link_encode            NUMBER(1),
 is_empage              NUMBER(1)
 );
/

-- aragarwa : Array Object for Violation Context Column Definition.
CREATE OR REPLACE TYPE MGMT_CS_VIOL_COLUMN_ARRAY IS TABLE OF MGMT_CS_VIOL_COLUMN_DEF;
/

-- aragarwa : definition object for Fix Link details...

CREATE OR REPLACE TYPE MGMT_CS_FIX_LINK_DEF IS OBJECT
(
 display_label          VARCHAR2(256),
 link_template          VARCHAR2(4000),
 link_encode            NUMBER(1),
 is_link_em_page        NUMBER(1)
 );
/

-- aragarwa : Array table for fix link definition object.
CREATE OR REPLACE TYPE MGMT_CS_FIX_LINK_ARRAY IS TABLE OF MGMT_CS_FIX_LINK_DEF;
/

-- aragarwa : definition object for Change Advisor Tag...
CREATE OR REPLACE TYPE MGMT_CS_CHANGE_ADVISOR_DEF IS OBJECT
(
 change_advisor_type     VARCHAR2(256),
 change_advisor_subtype  VARCHAR2(256),
 change_advisor_reason   VARCHAR2(256)
 );
/

-- aragarwa : Array table for fix link definition object.
CREATE OR REPLACE TYPE MGMT_CS_CHANGE_ADVISOR_ARRAY IS TABLE OF MGMT_CS_CHANGE_ADVISOR_DEF;
/

-- aragarwa : definition object for Simple test property, operator, value expressions...

CREATE OR REPLACE TYPE MGMT_CS_SIMPLE_TEST_DEF IS OBJECT
(
 property               VARCHAR2(4000),
 operator               NUMBER(1),
 value                  VARCHAR2(4000),
 position               NUMBER
 );
/

-- aragarwa : Array Object for Simple test Definition.
CREATE OR REPLACE TYPE MGMT_CS_SIMPLE_TEST_ARRAY IS TABLE OF MGMT_CS_SIMPLE_TEST_DEF;
/


--  EXPORT
-- =======
-- aragarwa : Added these types for export support.

CREATE OR REPLACE TYPE  MGMT_CS_RULE_DEF IS OBJECT
(
    rule_guid               VARCHAR2(256),
    rule_iname              VARCHAR2(128),
    rule_dname              VARCHAR2(128),
    description             VARCHAR2(256),
    reference_url           VARCHAR2(4000),
    importance_level        NUMBER(1),
    rationale               VARCHAR2(500),
    fixtext                 VARCHAR2(500),
    warning                 VARCHAR2(500),
    fixlink_list            MGMT_CS_FIX_LINK_ARRAY,
    change_advisor_tag      MGMT_CS_CHANGE_ADVISOR_ARRAY,
    violctx_list            MGMT_CS_VIOL_COLUMN_ARRAY,
    message                 VARCHAR2(4000),
    clear_message           VARCHAR2(4000),
    test_type               NUMBER(1),
    test                    VARCHAR2(4000),
    simple_test_condition   NUMBER(1),
    simple_tests            MGMT_CS_SIMPLE_TEST_ARRAY
);
/

CREATE OR REPLACE TYPE MGMT_CS_RULEFOLDER_DEF IS OBJECT
(
    rulefolder_guid         VARCHAR2(256),
    rulefolder_iname        VARCHAR2(128),
    rulefolder_dname        VARCHAR2(128),
    description             VARCHAR2(256),
    reference_url           VARCHAR2(4000)
);
/

CREATE OR REPLACE TYPE MGMT_CS_INCLUSION_DEF IS OBJECT
(
    cs_inclusion_guid       VARCHAR2(256),
    included_cs_iname       VARCHAR2(128),
    included_cs_author      VARCHAR2(256),
    included_cs_version     NUMBER,
    context_query           VARCHAR2(4000),
    over_parameters         MGMT_CS_PARAM_OVER_ARRAY
);
/

-- aragarwa : Create Arrays of above said definitions so that these 
-- can be taken as bulk.
CREATE OR REPLACE TYPE MGMT_CS_RULE_ARRAY IS TABLE OF MGMT_CS_RULE_DEF;
/
CREATE OR REPLACE TYPE MGMT_CS_RULEFOLDER_ARRAY IS TABLE OF MGMT_CS_RULEFOLDER_DEF;
/
CREATE OR REPLACE TYPE MGMT_CS_INCLUSION_ARRAY IS TABLE OF MGMT_CS_INCLUSION_DEF;
/

CREATE OR REPLACE TYPE MGMT_CS_HIERARCHY_DEF IS OBJECT
(
    parent_guid             VARCHAR2(256),
    child_guid              VARCHAR2(256),
    child_type              NUMBER(1),
    child_position          NUMBER 
);
/

CREATE OR REPLACE TYPE MGMT_CS_HIERARCHY_ARRAY IS TABLE OF MGMT_CS_HIERARCHY_DEF;
/
-- aragarwa : Giant type which contains entire standard definition and 
-- will be used for exporting the standard from database tables to 
-- xml file.

CREATE OR REPLACE TYPE MGMT_CS_STANDARD_DEF IS OBJECT
(
    -- standard attributes
    cs_iname                 VARCHAR2(128),
    cs_dname                 VARCHAR2(128),
    target_type              VARCHAR2(128),
    author                   VARCHAR2(256),
    version                  NUMBER,
    is_locked                NUMBER(1),
    lifecycle_status         NUMBER(1),
    usage_type               NUMBER(1),
    is_hidden                NUMBER(1),
    description              VARCHAR2(256),
    keyword_list             MGMT_SHORT_STRING_TABLE,
    reference_url            VARCHAR2(4000),
    front_matter             VARCHAR2(500),
    rear_matter              VARCHAR2(500),
    notice                   VARCHAR2(500),
    param_list               MGMT_CS_PARAM_ARRAY,
    reusable_query_list      MGMT_CS_REUSABLE_QUERY_ARRAY,
    cs_guid                  VARCHAR2(256)
);
/

-- rreilly: Definition of Evaluation Column Object
CREATE TYPE MGMT_CS_EVAL_COL_DEF AS OBJECT
(
  violation_id  NUMBER,
  violation_guid RAW(16),
  key_guid       RAW(16),
  target_guid    RAW(16),
  is_target_guid NUMBER(1),
  is_key         NUMBER(1),
  col_iname      VARCHAR2(128),
  col_value      VARCHAR2(4000)
);
/

-- rreilly: Table of Evaluation Column Object
CREATE TYPE MGMT_CS_EVAL_COL_TBL AS TABLE OF MGMT_CS_EVAL_COL_DEF;
/

show errors;
