Rem
Rem $Header: compliance_evaluation_by_group.sql 29-aug-2006.14:30:32 groyal Exp $
Rem
Rem compliance_evaluation_by_group.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      compliance_evaluation_by_group.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      08/25/06 - 
Rem    sthiruna    08/22/06 - Adding Report-Specific Help. Reference bug
Rem                           5457433
Rem    sthiruna    07/17/06 - Adding Not Evaluated column for Reports 
Rem    sthiruna    06/22/06 - Replacing the hardcoded user SYSMAN to 
Rem                           mgmt_user.get_repository_owner in 
Rem                           create_report_definition and modifying the 
Rem                           delete record block with delete_report_by_title 
Rem                           API to avoid fetching of user records instead of 
Rem                           expected System records 
Rem    aragarwa    03/24/06 - Fixing details report. 
Rem    spahuja     03/02/06 - Compliance evaluation report filtered on group
Rem    spahuja     03/02/06 - Created
Rem


DECLARE

  l_target_types  MGMT_IP_TARGET_TYPES;
  l_param_values    MGMT_IP_PARAM_VALUE_LIST;
  l_report_guid     RAW(16);
  l_title           VARCHAR2(256);
  l_element_guid    RAW(16);
 
BEGIN
  l_target_types := MGMT_IP_TARGET_TYPES();
  l_target_types.extend(1);
  l_target_types(1) := 'composite';

--Delete Earlier Version of OOB System Reports  
  BEGIN
        mgmt_ip.delete_report_by_title( mgmt_user.get_repository_owner,
             'COMPLIANCE_EVALUATION_GROUP',
             1,
             0);

  EXCEPTION
    WHEN OTHERS THEN NULL;
  END;



  --Creates a definition for reporting compliance of all hosts

  l_report_guid := mgmt_ip.create_report_definition (
    p_title_nlsid => 'COMPLIANCE_EVALUATION_GROUP',
    p_description_nlsid => 'COMPLIANCE_EVALUATION_GROUP_DESC',
    p_owner => mgmt_user.get_repository_owner,
-- Might have to choose a correct category and subcategroy - satinder
    p_category_nlsid  => 'IPMSG_MONITORING_CATEGORY',
    p_sub_category_nlsid => 'IPMSG_CONFIGURATION_STANDARDS_CATEGORY',
    p_late_binding_target_types => l_target_types,
    p_late_binding_multi_targets => 0,
    p_show_table_of_contents => 0,
    p_system_report => 1,
    p_help_topic_id => 'info_pub_gc_cs_cfgstd_comp_eval_group');


l_param_values := MGMT_IP_PARAM_VALUE_LIST();
l_param_values.extend(3);


--The text to be displayed
l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
'oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage',
'LBL_COMPL_EVAL_SUMM_GRP_DESC');

--The resource bundle containing the text
l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
'oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName',
'oracle.sysman.eml.ecm.compliance.ComplianceMsg');

--Specifies the style class
l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
'oracle.sysman.eml.ip.render.elem.TextParamBean.textStyleClass',
'OraInstructionText');

--Adding instruction text to the created report definition and passing the above parameters
l_element_guid := mgmt_ip.add_element_to_report_def (
p_report_guid => l_report_guid,
p_element_name_nlsid => 'IPMSG_STYLED_TEXT',
p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
p_element_order => 1,
p_element_row => 1,
p_parameters => l_param_values,
p_targets => null);



--Summary table 
l_param_values := MGMT_IP_PARAM_VALUE_LIST();
l_param_values.extend(8);

--The SQL query passed to retrieve data
l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.sqlStatement',
  'SELECT  e.cs_author "LBL_AUTHOR",
      NVL(nem.message, e.cs_name) "LBL_STANDARDNAME",
      e.cs_version "LBL_VERSION", 
      e.target_type "LBL_TARGETTYPE",
      e.target_name "LBL_TARGETNAME", 
      e.compliance_score "LBL_COMPLIANCESCORE", 
      e.total_compliant_rules "LBL_AVERULES_COMPLIANT",
      e.total_non_compliant_rules "LBL_AVERULES_NONCOMPLAINT", 
      e.total_error_rules + e.total_unknown_rules "LBL_RULESNOTEVALUATED", 
      e.total_violations "LBL_NOOFVIOLATIONS",
      e.LAST_EVALN_TIMESTAMP "LBL_EVAL_TIMESTMP"
  FROM mgmt$cs_eval_summary_standard e, mgmt$target_flat_members M,
      (select message, message_id from mgmt_messages
      where subsystem = ''CONFIG_STD'' 
      and language_code = ??EMIP_BIND_LOCALE_LANGUAGE??
      and country_code = ??EMIP_BIND_LOCALE_COUNTRY??) nem
  WHERE
      e.target_guid = M.member_target_guid AND
      M.aggregate_target_guid =??EMIP_BIND_TARGET_GUID?? AND
      e.cs_name_nlsid = nem.message_id(+)
  ORDER BY e.cs_author,e.cs_name,e.cs_version,e.target_type,e.target_name');

l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle',
	'oracle.sysman.eml.ecm.compliance.ComplianceMsg');
l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.initialSortColumn',
		'LBL_COMPLIANCESCORE');
l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.initialSortOrder',
	'descending');
l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupStartCol1',
		'LBL_AVERULES_COMPLIANT');
l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupEndCol1',
		'LBL_RULESNOTEVALUATED');
l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupHeader1',
		'LBL_RULES_AVERAGE_HEADER');   
l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.targetTypeColumns',
                'LBL_TARGETTYPE');

--Adding a table to the created report definition and passing the above parameters
  l_element_guid := mgmt_ip.add_element_to_report_def (
    p_report_guid => l_report_guid,
    p_element_name_nlsid => 'IPMSG_USER_TABLE_FROM_SQL',
    p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
    p_header_nlsid => 'TABLESUMM',
    p_element_order => 2,
    p_element_row => 2,
    p_parameters => l_param_values,
    p_targets => null);




--Details table

  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(3);

  --The SQL query passed to retrieve data
  l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.sqlStatement',
  'SELECT  e.cs_author "LBL_AUTHOR", 
      NVL(nem.message, e.cs_name) "LBL_STANDARDNAME", 
      e.cs_version "LBL_VERSION",
      e.target_name "LBL_TARGETNAME", 
      e.target_type "LBL_TARGETTYPE", 
      NVL(rem.message, e.rule_name) "LBL_RULE_NAME", 
      e.total_violations "LBL_NOOFVIOLATIONS"
  FROM mgmt$cs_eval_summary_rule e, 
      (select message, message_id from mgmt_messages
      where subsystem = ''CONFIG_STD'' 
      and language_code = ??EMIP_BIND_LOCALE_LANGUAGE??
      and country_code = ??EMIP_BIND_LOCALE_COUNTRY??) nem,
      (select message, message_id from mgmt_messages
      where subsystem = ''CONFIG_STD'' 
      and language_code = ??EMIP_BIND_LOCALE_LANGUAGE??
      and country_code = ??EMIP_BIND_LOCALE_COUNTRY??) rem,
      mgmt$target_flat_members M
  WHERE 
      e.target_guid = M.member_target_guid AND
      M.aggregate_target_guid =??EMIP_BIND_TARGET_GUID?? AND 
      e.total_violations > 0 AND
      e.cs_name_nlsid = nem.message_id(+) AND
      e.rule_name_nlsid = rem.message_id(+)
  ORDER BY e.cs_author,e.cs_name, e.cs_version, e.target_name, e.target_type, e.rule_name');
  
  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle',
      'oracle.sysman.eml.ecm.compliance.ComplianceMsg');

  l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.targetTypeColumns',
         'LBL_TARGETTYPE');

      
  --Adding a table to the created report definition and passing the above parameters
  l_element_guid := mgmt_ip.add_element_to_report_def (
    p_report_guid => l_report_guid,
    p_element_name_nlsid => 'IPMSG_USER_TABLE_FROM_SQL',
    p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
    p_header_nlsid => 'VIOLATED_REPORTS',
    p_element_order => 3,
    p_element_row => 3,
    p_parameters => l_param_values,
    p_targets => null);


END;
/
commit;

