Rem
Rem $Header: compliance_evaluation_summ_report.sql 25-aug-2006.10:00:13 groyal Exp $
Rem
Rem compliance_evaluation_summ_report.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      compliance_evaluation_summ_report.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      08/25/06 - 
Rem    sthiruna    08/22/06 - Adding Report-specific help to Compliance
Rem                           Reports.Reference bug 5457433
Rem    sthiruna    07/17/06 - Adding 'Not Evaluated' column for Reports
Rem    aragarwa    07/06/06 - Change context class to target_type 
Rem    sthiruna    06/22/06 - Replacing the hardcoded user SYSMAN to 
Rem                           mgmt_user.get_repository_owner in 
Rem                           create_report_definition and modifying the 
Rem                           delete record block with delete_report_by_title 
Rem                           API to avoid fetching of user records instead of 
Rem                           expected System records 
Rem    spahuja     02/24/06 - Gives the summary of configuration standards
Rem                           evaluation
Rem    spahuja     02/24/06 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


DECLARE

  l_param_values  MGMT_IP_PARAM_VALUE_LIST;
  l_report_guid   RAW(16);
  l_title         VARCHAR2(256);
  l_element_guid  RAW(16);
 
BEGIN

--Delete earlier version of OOB system report
     BEGIN
          mgmt_ip.delete_report_by_title( mgmt_user.get_repository_owner,
               'COMPL_EVAL_SUMM',
               1,
               0);
  
    EXCEPTION
        WHEN OTHERS THEN NULL;
    END;


 --Creates a definition for reporting compliance of all hosts
    l_report_guid := mgmt_ip.create_report_definition (
    p_title_nlsid => 'COMPL_EVAL_SUMM',
    p_description_nlsid => 'COMPL_EVAL_SUMM_DESC',
    p_owner => mgmt_user.get_repository_owner,
    p_category_nlsid  => 'IPMSG_MONITORING_CATEGORY',
    p_sub_category_nlsid => 'IPMSG_CONFIGURATION_STANDARDS_CATEGORY',
    p_late_binding_target_types => null,
    p_late_binding_multi_targets => 0,
    p_show_table_of_contents => 0,
    p_system_report => 1,
    p_help_topic_id => 'info_pub_gc_cs_cfgstd_comp_eval_summary');



  --instruction text begin--------------------------------
  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(3);

  --The text to be displayed
  l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage',
  'LBL_COMPL_EVAL_SUMM_REPORT_DESC');
  --The resource bundle containing the text
  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName',
  'oracle.sysman.eml.ecm.compliance.ComplianceMsg');
  --Specifies the style class
  l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.TextParamBean.textStyleClass',
  'OraInstructionText');

  --Adding instruction text to the created report definition and passing the above parameters
  l_element_guid := mgmt_ip.add_element_to_report_def (
  p_report_guid => l_report_guid,
  p_element_name_nlsid => 'IPMSG_STYLED_TEXT',
  p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
  p_element_order => 1,
  p_element_row => 1,
  p_parameters => l_param_values,
  p_targets => null);
  --instruction text end--------------------------------  



  -- Prepare to display a chart
  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(4);
  l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.sqlStatement',
	'select  
	''LBL_COMPLIANCESCORE'',
	COUNT(CASE WHEN COMPLIANCE_SCORE< 21 THEN  1 END) LBL_COMPLIANCESCORELESST20,
	COUNT(CASE WHEN COMPLIANCE_SCORE >= 21 AND COMPLIANCE_SCORE<41 THEN 1 END) LBL_COMPLIANCESCOREBW21AND40,  
	COUNT(CASE WHEN COMPLIANCE_SCORE >= 41 AND COMPLIANCE_SCORE<61 THEN 1 END) LBL_COMPLIANCESCOREBW41AND60,
	COUNT(CASE WHEN COMPLIANCE_SCORE >= 61 AND COMPLIANCE_SCORE<81 THEN 1 END) LBL_COMPLIANCESCOREBW61AND80,
	COUNT(CASE WHEN COMPLIANCE_SCORE >= 81 THEN 1 END) LBL_COMPLIANCESCOREMORET80
	from mgmt$cs_eval_summary_standard');
--  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
--    'oracle.sysman.eml.ip.render.elem.yAxisLabel', 'LBL_COMPLIANCESCORE');
--   l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.ChartParamController.pieShowSlicePercentLabels','true');

  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.ChartParamController.resourceBundle',
  'oracle.sysman.eml.ecm.compliance.ComplianceMsg');

  l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.ChartParamController.translateKeyValues', 'true');
   l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
    'oracle.sysman.eml.ip.render.elem.ChartParamController.chartType','barChart');   



-- add this bar chart to the report
   l_element_guid := mgmt_ip.add_element_to_report_def (
        p_report_guid         => l_report_guid,
        p_element_name_nlsid  => 'IPMSG_USER_CHART_FROM_SQL',
        p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
        p_header_nlslid       => 'DETAILED_COMPL_EVAL_SUMM_CHART',
        p_element_order       => 2,
        p_element_row         => 2,
        p_parameters          => l_param_values,
        p_targets             => null
   );


--Prepare the summary table
  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(8);

  --The SQL query passed to retrieve data
	l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.sqlStatement',
		'SELECT e.cs_author "LBL_AUTHOR",
			NVL(nem.message, e.cs_name) "LBL_STANDARDNAME", 
			e.cs_version "LBL_VERSION", 
			c.target_type "LBL_TARGETTYPE", 
			COUNT(e.target_guid) "LBL_TARGETSTESTED", 
			ROUND(AVG(e.compliance_score)) "LBL_AVECOMPLIANCESCORE", 
			ROUND(AVG(e.total_compliant_rules)) "LBL_AVERULES_COMPLIANT", 
			ROUND(AVG(e.total_non_compliant_rules)) "LBL_AVERULES_NONCOMPLAINT", 
			ROUND(AVG(e.total_error_rules + e.total_unknown_rules)) "LBL_RULESNOTEVALUATED",
			ROUND(AVG(e.total_violations)) "LBL_AVENOOFVIOLATIONS"
		FROM mgmt$cs_config_standards c, 
			mgmt$cs_eval_summary_standard e,
			(select message, message_id from mgmt_messages
			 where subsystem = ''CONFIG_STD'' 
				and language_code = ??EMIP_BIND_LOCALE_LANGUAGE??
			 	and country_code = ??EMIP_BIND_LOCALE_COUNTRY??) nem
		WHERE e.cs_guid = c.cs_guid
			AND e.cs_name_nlsid = nem.message_id (+) 
		GROUP BY e.cs_guid, nem.message, e.cs_name, e.cs_author, e.cs_version, c.target_type
		ORDER BY e.cs_author, e.cs_name, e.cs_version, c.target_type');

	l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle',
	'oracle.sysman.eml.ecm.compliance.ComplianceMsg');

	l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.initialSortColumn',
	'LBL_AVECOMPLIANCESCORE');

	l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
	'oracle.sysman.eml.ip.render.elem.TableRender.initialSortOrder',
	'descending');

	l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
			'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupStartCol1',
			'LBL_AVERULES_COMPLIANT');

	l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupEndCol1',
		'LBL_RULESNOTEVALUATED');

	l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupHeader1',
		'LBL_RULES_AVERAGE_HEADER');

        l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
                'oracle.sysman.eml.ip.render.elem.TableRender.targetTypeColumns',
                'LBL_TARGETTYPE');
   

  --Adding a table to the created report definition and passing the above parameters
  l_element_guid := mgmt_ip.add_element_to_report_def (
    p_report_guid => l_report_guid,
    p_element_name_nlsid => 'IPMSG_USER_TABLE_FROM_SQL',
    p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
    p_header_nlsid => 'TABLESUMM',
    p_element_order => 3,
    p_element_row => 3,
    p_parameters => l_param_values,
    p_targets => null);


-- Detailed table.
  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(8);

  --The SQL query passed to retrieve data
	l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.sqlStatement',
		'SELECT cs_author "LBL_AUTHOR",
			NVL (nem.message, cs_name) "LBL_STANDARDNAME",
			cs_version "LBL_VERSION", 
			target_type "LBL_TARGETTYPE", 
			target_name "LBL_TARGETNAME", 
			compliance_score "LBL_COMPLIANCESCORE", 
			total_compliant_rules "LBL_AVERULES_COMPLIANT", 
			total_non_compliant_rules "LBL_AVERULES_NONCOMPLAINT",
			total_error_rules + total_unknown_rules "LBL_RULESNOTEVALUATED", 
			total_violations "LBL_NOOFVIOLATIONS",
			LAST_EVALN_TIMESTAMP "LBL_EVAL_TIMESTMP_HEADER"
		FROM mgmt$cs_eval_summary_standard,
			(select message, message_id from mgmt_messages
			 where subsystem = ''CONFIG_STD'' 
                                and language_code = ??EMIP_BIND_LOCALE_LANGUAGE??
                                and country_code = ??EMIP_BIND_LOCALE_COUNTRY??) nem
		WHERE cs_name_nlsid = nem.message_id (+)
		ORDER BY cs_author,cs_name,cs_version,target_type,target_name');
	
	l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle',
		'oracle.sysman.eml.ecm.compliance.ComplianceMsg');

	l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.initialSortColumn',
		'LBL_COMPLIANCESCORE');

	l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.initialSortOrder',
		'descending');
	
	l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupHeader1',
		'LBL_RULES_NUMBER_HEADER');

	l_param_values(6) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupStartCol1',
		'LBL_AVERULES_COMPLIANT');

	l_param_values(7) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.columnGroupEndCol1',
		'LBL_RULESNOTEVALUATED');
   
	l_param_values(8) := MGMT_IP_PARAM_VALUE_RECORD(
		'oracle.sysman.eml.ip.render.elem.TableRender.targetTypeColumns',
		'LBL_TARGETTYPE');
	

  --Adding a table to the created report definition and passing the above parameters
  l_element_guid := mgmt_ip.add_element_to_report_def (
    p_report_guid => l_report_guid,
    p_element_name_nlsid => 'IPMSG_USER_TABLE_FROM_SQL',
    p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
    p_header_nlsid => 'TABLEDETAILS',
    p_element_order => 4,
    p_element_row => 4,
    p_parameters => l_param_values,
    p_targets => null);

END;
/
commit;

