Rem
Rem $Header: compliance_trend_target.sql 03-oct-2006.09:54:02 groyal Exp $
Rem
Rem compliance_trend_target.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      compliance_trend_target.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      10/03/06 - Fix ordering problem
Rem    groyal      08/29/06 - Use new metric names
Rem    sthiruna    08/22/06 - Adding Report-specific help to Compliance
Rem                           Reports.Reference bug 5457433
Rem    sthiruna    06/15/06 - Fix for bug 5307479 
Rem    spahuja     03/28/06 - changing default time period to 7 days 
Rem    spahuja     03/14/06 - Gives the compliance trend for a selected target 
Rem    spahuja     03/14/06 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


DECLARE

  l_target_types  MGMT_IP_TARGET_TYPES;
  l_param_values  MGMT_IP_PARAM_VALUE_LIST;
  l_report_guid   RAW(16);
  l_title         VARCHAR2(256);
  l_element_guid  RAW(16);

BEGIN

  l_target_types := MGMT_IP_TARGET_TYPES();
  l_target_types.extend(1);
  l_target_types(1) := 'any_type';

   -- Deleting earlier system  reports with the same title
  BEGIN
     mgmt_ip.delete_report_by_title(mgmt_user.get_repository_owner,'COMPLIANCE_EVAL_TREND',1,0);
  EXCEPTION
     WHEN OTHERS THEN NULL;
  END;


    -- this report has a time period and the user can customize it
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(3);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodOption',
      'true');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodUserCust',
      'true');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
      '0:1');





  --Creates a definition for reporting compliance of all hosts
  l_report_guid := mgmt_ip.create_report_definition (
    p_title_nlsid => 'COMPLIANCE_EVAL_TREND',
    p_description_nlsid => 'COMPLIANCE_EVAL_TREND_DESC',
    p_owner => mgmt_user.get_repository_owner,
    p_category_nlsid  => 'IPMSG_MONITORING_CATEGORY',
    p_sub_category_nlsid => 'IPMSG_CONFIGURATION_STANDARDS_CATEGORY',
    p_late_binding_target_types => l_target_types,
    p_late_binding_multi_targets => 0,
    p_show_table_of_contents => 0,
    p_system_report => 1,
    p_parameters => l_param_values,
    p_help_topic_id => 'info_pub_gc_cs_cfgstd_comp_trend_target');



  --instruction text begin--------------------------------
  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(3);

  --The text to be displayed
  l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage',
  'LBL_COMPL_EVAL_TREND_REPORT_DESC');
  --The resource bundle containing the text
  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName',
  'oracle.sysman.eml.ecm.compliance.ComplianceMsg');
  --Specifies the style class
  l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.TextParamBean.textStyleClass',
  'OraInstructionText');

  --Adding instruction text to the created report definition and passing the above parameters
  l_element_guid := mgmt_ip.add_element_to_report_def (
  p_report_guid => l_report_guid,
  p_element_name_nlsid => 'IPMSG_STYLED_TEXT',
  p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
  p_element_order => 1,
  p_element_row => 1,
  p_parameters => l_param_values,
  p_targets => null);
  --instruction text end--------------------------------  



  -- Compliance Score Chart --
  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(4);
  l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.sqlStatement',
  'SELECT 
      c.cs_name as config_std,
      v.rollup_timestamp as time,
      v.average as compliance_score
    FROM
      mgmt$metric_hourly v,
      mgmt$cs_config_standards c
    WHERE
      v.rollup_timestamp > mgmt_view_util.adjust_tz(
          ??EMIP_BIND_START_DATE?? , 
          ??EMIP_BIND_TIMEZONE_REGION?? , 
          (SELECT timezone_region FROM mgmt$target 
          WHERE target_type = ''oracle_emrep'')) AND 
      v.rollup_timestamp < mgmt_view_util.adjust_tz(
          ??EMIP_BIND_END_DATE??, 
          ??EMIP_BIND_TIMEZONE_REGION?? , 
          (SELECT timezone_region FROM mgmt$target 
          WHERE target_type = ''oracle_emrep'')) AND  
      v.target_type = ''oracle_emrep'' AND
      v.metric_name = ''CS_EVAL_SUMM_STANDARD'' AND
      v.metric_column = ''COMPLIANCE_SCORE'' AND
      v.key_value3 = ??EMIP_BIND_TARGET_GUID?? AND
      v.key_value = c.cs_guid   
    ORDER BY time ASC');
  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.ChartParamController.width',
  '400');
  l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.ChartParamController.height',
  '200');
  l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.ChartParamController.chartType',
  'timeSeriesChart');


  l_element_guid := mgmt_ip.add_element_to_report_def (
        p_report_guid         => l_report_guid,
        p_element_name_nlsid  => 'IPMSG_USER_CHART_FROM_SQL',
        p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
        p_header_nlslid       => 'COMPL_EVAL_TREND_CHART',
        p_element_order       => 2,
        p_element_row         => 2,
        p_parameters          => l_param_values,
        p_targets             => null
 );


     --Violation Count Chart--

  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(4);
  l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.sqlStatement',
  'SELECT 
      c.cs_name as config_std,
      v.rollup_timestamp as time,
      ROUND(v.average) as violation_count
    FROM
      mgmt$metric_hourly v,
      mgmt$cs_config_standards c
    WHERE
      v.rollup_timestamp > mgmt_view_util.adjust_tz(
          ??EMIP_BIND_START_DATE?? , 
          ??EMIP_BIND_TIMEZONE_REGION?? , 
          (SELECT timezone_region FROM mgmt$target 
          WHERE target_type = ''oracle_emrep'')) AND 
      v.rollup_timestamp < mgmt_view_util.adjust_tz(
          ??EMIP_BIND_END_DATE??, 
          ??EMIP_BIND_TIMEZONE_REGION?? , 
          (SELECT timezone_region FROM mgmt$target 
          WHERE target_type = ''oracle_emrep'')) AND  
      v.target_type = ''oracle_emrep'' AND
      v.metric_name = ''CS_EVAL_SUMM_STANDARD'' AND
      v.metric_column = ''VIOLATION_COUNT'' AND 
      v.key_value3 = ??EMIP_BIND_TARGET_GUID?? AND
      v.key_value = c.cs_guid 	
    ORDER BY time ASC');
  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.ChartParamController.width',
  '400');
  l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.ChartParamController.height',
  '200');
  l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.ChartParamController.chartType',
  'timeSeriesChart');


  l_element_guid := mgmt_ip.add_element_to_report_def (
        p_report_guid         => l_report_guid,
        p_element_name_nlsid  => 'IPMSG_USER_CHART_FROM_SQL',
        p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
        p_header_nlslid       => 'COMPL_VIOL_COUNT_CHART',
        p_element_order       => 3,
        p_element_row         => 2,
        p_parameters          => l_param_values,
        p_targets             => null
 );
                                                                             


END;
/
commit;

  

