Rem
Rem $Header: configuration_standard_lib.sql 03-oct-2006.09:55:35 groyal Exp $
Rem
Rem configuration_standard_lib.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      configuration_standard_lib.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      10/03/06 - Fix ordering problem
Rem    sthiruna    08/22/06 - Adding Report-specific help to Compliance
Rem                           Reports.Reference bug 5457433
Rem    aragarwa    07/06/06 - Change context class to target_type 
Rem    sthiruna    06/22/06 - Replacing the hardcoded user SYSMAN to 
Rem                           mgmt_user.get_repository_owner in 
Rem                           create_report_definition and modifying the 
Rem                           delete record block with delete_report_by_title 
Rem                           API to avoid fetching of user records instead of 
Rem                           expected System records 
Rem    spahuja     02/28/06 - Configuration standard library
Rem    spahuja     02/28/06 - Created
Rem


SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


DECLARE

  l_target_types  MGMT_IP_TARGET_TYPES;
  l_param_values    MGMT_IP_PARAM_VALUE_LIST;
  l_report_guid     RAW(16);
  l_title           VARCHAR2(256);
  l_element_guid    RAW(16);
 
BEGIN
  l_target_types := MGMT_IP_TARGET_TYPES();
  l_target_types.extend(1);
  l_target_types(1) := 'composite';

--Delete earlier version of OOB system report
  BEGIN
      mgmt_ip.delete_report_by_title( mgmt_user.get_repository_owner,
           'CONFIGURATION_STD_LIB',
           1,
           0);
  EXCEPTION
      WHEN OTHERS THEN NULL;
  END;
  
  
--Creates a definition for reporting compliance of all hosts
  
  l_report_guid := mgmt_ip.create_report_definition (
  p_title_nlsid => 'CONFIGURATION_STD_LIB',
  p_description_nlsid => 'CONFIGURATION_STD_LIB_DESC',
  p_owner => mgmt_user.get_repository_owner,
-- Might have to choose a correct category and subcategroy - satinder
  p_category_nlsid  => 'IPMSG_MONITORING_CATEGORY',
  p_sub_category_nlsid => 'IPMSG_CONFIGURATION_STANDARDS_CATEGORY',
  p_late_binding_target_types => null,
  p_late_binding_multi_targets => 0,
  p_show_table_of_contents => 0,
  p_system_report => 1,
  p_help_topic_id => 'info_pub_gc_cs_cfgstd_library');


  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
  l_param_values.extend(3);

  --The SQL query passed to retrieve data
  l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
  'oracle.sysman.eml.ip.render.elem.sqlStatement',
  'select c.cs_author "LBL_AUTHOR",
                NVL(nem.message, c.cs_name) "LBL_STANDARDNAME", 
                c.cs_version "LBL_VERSION" , 
                c.keywords "LBL_KEYWORDS", 
                c.target_type "LBL_TARGETTYPE" , 
                NVL(dem.message, c.description) "LBL_DESC"
  from mgmt$cs_config_standards c,
  (select message, message_id from mgmt_messages
                where subsystem = ''CONFIG_STD'' 
                and language_code = ??EMIP_BIND_LOCALE_LANGUAGE??
                and country_code = ??EMIP_BIND_LOCALE_COUNTRY??) nem,
  (select message, message_id from mgmt_messages
                where subsystem = ''CONFIG_STD'' 
                and language_code = ??EMIP_BIND_LOCALE_LANGUAGE??
                and country_code = ??EMIP_BIND_LOCALE_COUNTRY??) dem
  where
                c.cs_name_nlsid = nem.message_id(+) AND
                c.description_nlsid=dem.message_id(+)
  order by c.CS_author, nem.message, c.cs_name, c.cs_version, c.keywords, c.target_type');
  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle',
      'oracle.sysman.eml.ecm.compliance.ComplianceMsg');
  l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
        'oracle.sysman.eml.ip.render.elem.TableRender.targetTypeColumns',
         'LBL_TARGETTYPE');

--Adding a table to the created report definition and passing the above parameters
  l_element_guid := mgmt_ip.add_element_to_report_def (
    p_report_guid => l_report_guid,
    p_element_name_nlsid => 'IPMSG_USER_TABLE_FROM_SQL',
    p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
    p_header_nlsid => 'CONFIG_STD_LIB_TABLE',
    p_element_order => 1,
    p_element_row => 1,
    p_parameters => l_param_values,
    p_targets => null);


END;
/
commit;


