Rem drv: <migrate type="data_upgrade" version="10.2.0.3.0"/>
Rem
Rem $Header: credentials_data_upgrade.sql 25-oct-2006.10:51:45 sradhakr Exp $
Rem
Rem credentials_data_upgrade.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credentials_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sradhakr    10/13/06 - upgrade file added for credential data upgrade -
Rem                           to include default host credentials - came with
Rem                           Bug 5382567
Rem    sradhakr    10/13/06 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-- Add target meta ver update callback to all targets Bug#5382567
BEGIN
  MGMT_TARGET.add_metaver_catprop_callback(
    p_callback_name => 'EM_CREDENTIAL.handle_target_metaver_update',
    p_target_type   => ' ');
EXCEPTION
  WHEN OTHERS THEN
    -- Ignore duplicate registrations
    dbms_output.put_line( 'EXCEPTION registering meta ver update callback for all targets other than host and db'|| SQLCODE );
    NULL;
END;
/
BEGIN
  FOR crec IN (SELECT target_name,target_type,target_guid
  		FROM   MGMT_TARGETS t WHERE EXISTS
		  (SELECT target_type_meta_ver FROM MGMT_CREDENTIAL_SETS cs1
                  WHERE t.target_type = cs1.target_type)
	          AND
		  t.type_meta_ver NOT IN
		 (SELECT target_type_meta_ver  FROM MGMT_CREDENTIAL_SETS cs2
                  WHERE t.target_type = cs2.target_type))
  LOOP
    EM_CREDENTIAL.add_host_credential_info(crec.target_name, crec.target_type, crec.target_guid);
  END LOOP;
END;
/ 
