Rem
Rem $Header: ecm_hw_oob_report.sql 08-sep-2005.01:23:35 niramach Exp $
Rem
Rem ecm_hw_oob_report.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_hw_oob_report.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Out of the box ecm hw reports that ship with EM
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem      niramach  06/17/06  - Fix for bug 5331253 
Rem      niramach  06/17/06  -  Creation
Rem

SET DEFINE OFF
BEGIN

  DECLARE 
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;
    l_target_types  MGMT_IP_TARGET_TYPES;    
    l_report_guid   RAW(16);
    l_element_guid  RAW(16);

BEGIN  

    --Delete earlier version of OOB system report
    BEGIN
      mgmt_ip.delete_report_by_title(mgmt_user.get_repository_owner,
        'ENTHW_CONFIG',
        1,
        0);    
    EXCEPTION
      WHEN OTHERS THEN NULL;
    END;

    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                   => 'ENTHW_CONFIG',
      p_description_nlsid             => 'ENT_HARDWARE_DESC',
      p_owner                         => mgmt_user.get_repository_owner,
      p_category_nlsid                => 'IPMSG_DEPLOYMENT_AND_CONFIGURATION_CATEGORY',
      p_sub_category_nlsid            => 'HW_SUBCAT',
      p_late_binding_target_types     =>  null,
      p_late_binding_multi_targets    =>  0,
      p_show_table_of_contents        =>  0,
      p_system_report                 =>  1 
        );
 
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'SELECT VENDOR_NAME, COUNT(VENDOR_NAME) from mgmt$os_hw_summary  GROUP BY VENDOR_NAME');
      
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
             'oracle.sysman.eml.ip.render.elem.ChartParamController.pieShowSlicePercentLabels',
            'true');
      
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_USER_CHART_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => 'HARDWARE_TITLE',
      p_element_order       => 1,
      p_element_row         => 1,
      p_parameters          => l_param_values,
      p_targets             => null
        );
    
    commit;
      
 --table
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'select system_config || '' '' || MA as "HW_SNAPSHOT_COMPONENT_NAME", 
              count(*) as "HC_TARGET_NAME" from mgmt$os_hw_summary group by system_config,MA');

   l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle', 'oracle.sysman.eml.ecm.resources.HCResourceBundle');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_USER_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => 'HARDWARE_CONFIG_SUMMARY',
      p_element_order       => 2,
      p_element_row         => 2,
      p_parameters          => l_param_values,
      p_targets             => null
        );

    COMMIT;  


--table 2
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'SELECT UNIQUE SYSTEM_CONFIG || '' '' || ma as "HW_SNAPSHOT_COMPONENT_NAME"
            , host_name as "HC_TARGET_NAME" , 
            OS_SUMMARY as "OS_SUMMARY.OS" 
        FROM mgmt$os_hw_summary');

   l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle', 'oracle.sysman.eml.ecm.resources.HCResourceBundle');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_USER_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => 'HARDWARE_CONFIG_DETAILS',
      p_element_order       => 3,
      p_element_row         => 3,
      p_parameters          => l_param_values,
      p_targets             => null
        );

    COMMIT;  
    
    -- Group Level HArdware Reports..
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(1);
    l_target_types(1) := 'composite';
   
   --Delete earlier version of OOB system report 
    BEGIN    
      mgmt_ip.delete_report_by_title(mgmt_user.get_repository_owner,
        'TARGETHW_CONFIG',
        1,
        0);    
    EXCEPTION
      WHEN OTHERS THEN NULL;
    END;

    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                   => 'TARGETHW_CONFIG',
      p_description_nlsid             => 'TARGET_HARDWARE_DESC',
      p_owner                         => mgmt_user.get_repository_owner,
      p_category_nlsid                => 'IPMSG_DEPLOYMENT_AND_CONFIGURATION_CATEGORY',
      p_sub_category_nlsid            => 'HW_SUBCAT',
      p_late_binding_target_types     =>  l_target_types,
      p_late_binding_multi_targets    =>  0,
      p_show_table_of_contents        =>  0,
      p_system_report                 =>  1
        );
 
    
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
            'SELECT v1.VENDOR_NAME , 
         COUNT(v1.VENDOR_NAME)  from 
        mgmt$os_hw_summary v1, 
          (
                    select unique
                      t.host_name as hname
                    FROM
                      mgmt$target t,
                      (
                          SELECT UNIQUE m.member_target_guid as mguid
                          FROM
                            mgmt$target_flat_members m
                          WHERE
                            m.AGGREGATE_TARGET_GUID = ??EMIP_BIND_TARGET_GUID??
                        UNION
                          SELECT UNIQUE t.target_guid as mguid
                          FROM  mgmt$target t
                          WHERE 
                           t.TARGET_GUID = ??EMIP_BIND_TARGET_GUID??
                      ) lt1
                    WHERE
                      lt1.mguid = t.target_guid
            ) hosts
      where hosts.hname = v1.host_name
      GROUP BY v1.VENDOR_NAME');

      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
             'oracle.sysman.eml.ip.render.elem.ChartParamController.pieShowSlicePercentLabels',
            'true');         
      
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_USER_CHART_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => 'HARDWARE_TITLE',
      p_element_order       => 1,
      p_element_row         => 1,
      p_parameters          => l_param_values,
      p_targets             => null
        );
    
    commit;
      
 --table
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'select system_config || '' '' || ma as "HW_SNAPSHOT_COMPONENT_NAME", 
              count(*)  as "HC_TARGET_NAME"
     from mgmt$os_hw_summary v1, 
    (
              select unique
                t.host_name as hname
              FROM
                mgmt$target t,
                (
                    SELECT UNIQUE m.member_target_guid as mguid
                    FROM
                      mgmt$target_flat_members m
                    WHERE
			m.AGGREGATE_TARGET_GUID = ??EMIP_BIND_TARGET_GUID??
                  UNION
                    SELECT UNIQUE t.target_guid as mguid
                    FROM  mgmt$target t
                    WHERE 
                     t.TARGET_GUID = ??EMIP_BIND_TARGET_GUID??
                ) lt1
              WHERE
                lt1.mguid = t.target_guid
      ) hosts
where hosts.hname = v1.host_name
group by system_config,MA');


    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle', 'oracle.sysman.eml.ecm.resources.HCResourceBundle');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_USER_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => 'HARDWARE_CONFIG_SUMMARY',
      p_element_order       => 2,
      p_element_row         => 2,
      p_parameters          => l_param_values,
      p_targets             => null
        );

    COMMIT;  


--table 2
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
           'SELECT UNIQUE SYSTEM_CONFIG || '' '' || ma as "HW_SNAPSHOT_COMPONENT_NAME",  
                  host_name as "HC_TARGET_NAME" ,  
                    OS_SUMMARY as "OS_SUMMARY.OS"
FROM mgmt$os_hw_summary v1,
    (
              select unique
                t.host_name as hname
              FROM
                mgmt$target t,
                (
                    SELECT UNIQUE m.member_target_guid as mguid
                    FROM
                      mgmt$target_flat_members m
                    WHERE
                     m.AGGREGATE_TARGET_GUID = ??EMIP_BIND_TARGET_GUID??
                  UNION
                    SELECT UNIQUE t.target_guid as mguid
                    FROM  mgmt$target t
                    WHERE 
                     t.TARGET_GUID = ??EMIP_BIND_TARGET_GUID??
                ) lt1
              WHERE
                lt1.mguid = t.target_guid
      ) hosts
where hosts.hname = v1.host_name');

   l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle', 'oracle.sysman.eml.ecm.resources.HCResourceBundle');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_USER_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => 'HARDWARE_CONFIG_DETAILS',
      p_element_order       => 3,
      p_element_row         => 3,
      p_parameters          => l_param_values,
      p_targets             => null
        );

    COMMIT;  
    
  END;

END;

/

SET DEFINE ON
