Rem drv: <migrate type="pre_data_upgrade" version="10.2.0.3"/>
Rem
Rem $Header: gensvc_post_creation.sql 22-sep-2005.12:31:59 mfidanbo Exp $
Rem
Rem gensvc_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      gensvc_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mfidanbo    09/22/05 - add test_response metric manually 
Rem    rmarripa    07/12/05 - Created
Rem

DECLARE
  l_metric_col_list MGMT_METRIC_COLUMN_ARRAY :=  MGMT_METRIC_COLUMN_ARRAY();

BEGIN
    -- Register the availability metric for test-based services
    -- aggregate services do not need this metric.
    l_metric_col_list := MGMT_METRIC_COLUMN_ARRAY();
  
    l_metric_col_list.extend(1);
    l_metric_col_list(l_metric_col_list.count) := 
    MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'transaction_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Transaction Name',
        p_is_key => 1);

    l_metric_col_list.extend(1);
    l_metric_col_list(l_metric_col_list.count) := 
    MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_EVENT,
        p_column_label => '[Test Response] Status',
        p_column_label_nlsid => 'test_response_status',
        p_is_key => 0,
        p_short_name => 'Status',
        p_short_name_nlsid => 'test_response_status_short');

    begin

      mgmt_metric.create_metric(p_target_type => MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE,
                                p_metric_name => MGMT_GLOBAL.G_AVAIL_TEST_METRIC_NAME,
                                p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                                p_metric_label => MGMT_GLOBAL.G_AVAIL_TEST_METRIC_NAME,
                                p_metric_label_nlsid => 'test_response',
                                p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_SEVEVAL_PLSQL,
                                p_source =>      MGMT_SEVERITY_HELPER.G_OR_AVAIL_EVAL_PROC_NAME,
                                p_type_meta_ver => '1.0',
                                p_metric_column_list => l_metric_col_list,
                                p_is_repository => 1,
                                p_remote     => 0,
                                p_keys_from_mult_colls => 1);
    exception when dup_val_on_index then
      null;
    end;

    begin

      mgmt_metric.create_metric(p_target_type => MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                                p_metric_name => MGMT_GLOBAL.G_AVAIL_TEST_METRIC_NAME,
                                p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                                p_metric_label => MGMT_GLOBAL.G_AVAIL_TEST_METRIC_NAME,
                                p_metric_label_nlsid => 'test_response',
                                p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_SEVEVAL_PLSQL,
                                p_source =>      MGMT_SEVERITY_HELPER.G_OR_AVAIL_EVAL_PROC_NAME,
                                p_type_meta_ver => '1.0',
                                p_metric_column_list => l_metric_col_list,
                                p_is_repository => 1,
                                p_remote     => 0,
                                p_keys_from_mult_colls => 1);
    exception when dup_val_on_index then
      null;
    end;
END;

/
show errors;
