Rem
Rem $Header: webapp_oob_samples.sql 09-oct-2006.03:56:01 gsambamu Exp $
Rem
Rem webapp_oob_samples.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      webapp_oob_samples.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsambamu    10/09/06 - Backport gsambamu_bug-5516168 from main
Rem    gsambamu    09/27/06 - Bug Fix 5516168: Modified the report owner to be
Rem                           the REP OWNER
Rem    yxie        04/10/06 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

DECLARE
i_parameters MGMT_IP_PARAM_VALUE_LIST ;
p_parameters MGMT_IP_PARAM_VALUE_LIST ;
p_parameters1 MGMT_IP_PARAM_VALUE_LIST ;
p_parameters2 MGMT_IP_PARAM_VALUE_LIST ;
p_parameters3 MGMT_IP_PARAM_VALUE_LIST ;
p_parameters4 MGMT_IP_PARAM_VALUE_LIST ;
l_target_types MGMT_IP_TARGET_TYPES := MGMT_IP_TARGET_TYPES();
s_target_types MGMT_IP_TARGET_TYPES := MGMT_IP_TARGET_TYPES();
l_param_values MGMT_IP_PARAM_VALUE_LIST ;
l_repository_owner VARCHAR2(256) := MGMT_USER.GET_REPOSITORY_OWNER;

l_report_definition_guid RAW(16);
l_elem_guid RAW(16);
target_guid RAW(16);
target_name VARCHAR2(256);

-- For upgrade of Transaction Performance (keytypes)
param_value NUMBER;
rep_guid MGMT_IP_REPORT_ELEM_PARAMS.REPORT_GUID%TYPE;
elem_guid MGMT_IP_REPORT_ELEM_PARAMS.ELEMENT_GUID%TYPE;
param_type MGMT_IP_REPORT_ELEM_PARAMS.PARAM%TYPE;

CURSOR fetchparam_cur IS 
	SELECT report_guid, element_guid FROM MGMT_IP_REPORT_ELEM_PARAMS 
	WHERE param = 'oracle.sysman.eml.ip.render.elem.tp.keyType';

BEGIN

----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Performance Reports
----------------------------------------------------------------------------------------------------------------------------

l_target_types := MGMT_IP_TARGET_TYPES();
l_target_types.extend(2);
l_target_types(1) := 'website';
l_target_types(2) := 'formsapp';

s_target_types := MGMT_IP_TARGET_TYPES();
s_target_types.extend(4);
s_target_types(1) := 'website';
s_target_types(2) := 'generic_service';
s_target_types(3) := 'aggregate_service';
s_target_types(4) := 'formsapp';
----------------------------------------------------------------------------------------------------------------------------
--- For Service Alerts Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_SERVICES_ALERTS', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;


l_param_values := MGMT_IP_PARAM_VALUE_LIST();
l_param_values.extend(3);
-- this report has a time period 
l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodOption',
      'true');

-- the user can customize the time period for this report
l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodUserCust',
      'true');

-- default time period to last 24 hours
l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
      '0:0');

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_SERVICES_ALERTS', 'IPMSG_SERVICES_ALERTS', 
                                                             l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_ALERTS_ELEMENT', s_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','IPMSG_WEBAPP_ALERTS_REPORT');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(7) := new mgmt_ip_param_value_record('AlertValue','2');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');

p_parameters1 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters1.extend(8);
p_parameters1(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters1(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters1(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters1(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters1(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters1(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters1(7) := new mgmt_ip_param_value_record('AlertValue','3');
p_parameters1(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_ALERTS_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_PERF_ALERTS_TEXT');

l_elem_guid := MGMT_IP.add_element_to_report_def(p_report_guid => l_report_definition_guid, 
                                                 p_element_name_nlsid => 'IPMSG_WEBAPP_ALERTS_ELEMENT', 
                                                  p_element_type_nlsid => 'IPMSG_SERVICE_TARGET_TYPES', 
                                                 p_header_nlslid => '', 
                                                 p_element_order=>3, 
                                                 p_element_row=>3, 
                                                 p_parameters=>p_parameters1, 
																								 p_targets=>null, 
																								 p_header_nlsid=>'IPMSG_USAGE_ALERTS_TEXT');




p_parameters2 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters2.extend(8);
p_parameters2(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters2(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters2(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters2(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters2(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters2(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters2(7) := new mgmt_ip_param_value_record('AlertValue','4');
p_parameters2(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_ALERTS_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 4, 4, 
                                                 p_parameters2, null,  p_header_nlsid =>'IPMSG_SYS_ALERTS_TEXT');



p_parameters3 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters3.extend(8);
p_parameters3(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters3(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters3(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters3(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters3(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters3(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters3(7) := new mgmt_ip_param_value_record('AlertValue','6');
p_parameters3(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_ALERTS_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 5, 5, 
                                                 p_parameters3, null,  p_header_nlsid =>'IPMSG_ALLTEST_ALERTS_TEXT');




p_parameters4 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters4.extend(8);
p_parameters4(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters4(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters4(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters4(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters4(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters4(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters4(7) := new mgmt_ip_param_value_record('AlertValue','5');
p_parameters4(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');


l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_ALERTS_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 6, 6, 
                                                 p_parameters4, null,  p_header_nlsid =>'IPMSG_ALLKEYTEST_ALERTS_TEXT');



----------------------------------------------------------------------------------------------------------------------------
--- For Service Performance and Usage Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_SERVICE_PERFUSAGE_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_SERVICE_PERFUSAGE_TEXT', 
                                                              'IPMSG_SERVICE_PERFUSAGE_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_AVLPERFUSAGE_TEXT', s_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','IPMSG_WEBAPP_PERFUSAGE_REPORT');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('PUValue','1');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_METRICDTL_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                2,2,
                                                 p_parameters, null, '');

p_parameters1 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters1.extend(8);
p_parameters1(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters1(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters1(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters1(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters1(5) := new mgmt_ip_param_value_record('PUValue','2');
p_parameters1(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters1(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters1(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_METRICDTL_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                3,2,
                                                 p_parameters1, null, '');




----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Slowest 5 Pages by Domain  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_SLOWEST_BYCAT_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_SLOWEST_BYCAT_TEXT', 
                                                              'IPMSG_WEBAPP_SLOWEST_BYCAT_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_PAGEPERF_ELEMENT', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','IPMSG_WEBAPP_SLOWEST_BYCAT_REPORT');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('AxisValue','1');
p_parameters(6) := new mgmt_ip_param_value_record('PageTypeValue','2');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_BYDOM_TEXT');




p_parameters1 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters1.extend(9);
p_parameters1(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters1(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters1(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters1(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters1(5) := new mgmt_ip_param_value_record('AxisValue','2');
p_parameters1(6) := new mgmt_ip_param_value_record('PageTypeValue','2');
p_parameters1(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters1(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters1(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 3,3,
                                                 p_parameters1, null,  p_header_nlsid =>'IPMSG_BYREG_TEXT');




p_parameters2 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters2.extend(9);
p_parameters2(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters2(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters2(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters2(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters2(5) := new mgmt_ip_param_value_record('AxisValue','4');
p_parameters2(6) := new mgmt_ip_param_value_record('PageTypeValue','2');
p_parameters2(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters2(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters2(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 4,1,
                                                 p_parameters2, null,  p_header_nlsid =>'IPMSG_BYWEBCACHE_TEXT');

p_parameters3 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters3.extend(9);
p_parameters3(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters3(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters3(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters3(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters3(5) := new mgmt_ip_param_value_record('AxisValue','3');
p_parameters3(6) := new mgmt_ip_param_value_record('PageTypeValue','2');
p_parameters3(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters3(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters3(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                5,1,
                                                 p_parameters3, null,  p_header_nlsid =>'IPMSG_BYVISITOR_TEXT');





----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 5 Most Popular Pages by Domain  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_TOP5PAGE_BYCAT_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_TOP5PAGE_BYCAT_TEXT', 
                                                              'IPMSG_WEBAPP_TOP5PAGE_BYCAT_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_PAGEPERF_ELEMENT', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','IPMSG_WEBAPP_TOP5PAGE_BYCAT_REPORT');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('AxisValue','1');
p_parameters(6) := new mgmt_ip_param_value_record('PageTypeValue','1');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_BYDOM_TEXT');

p_parameters1 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters1.extend(9);
p_parameters1(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters1(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters1(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters1(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters1(5) := new mgmt_ip_param_value_record('AxisValue','2');
p_parameters1(6) := new mgmt_ip_param_value_record('PageTypeValue','1');
p_parameters1(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters1(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters1(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 3,3,
                                                 p_parameters1, null,  p_header_nlsid =>'IPMSG_BYREG_TEXT');

p_parameters2 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters2.extend(9);
p_parameters2(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters2(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters2(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters2(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters2(5) := new mgmt_ip_param_value_record('AxisValue','4');
p_parameters2(6) := new mgmt_ip_param_value_record('PageTypeValue','1');
p_parameters2(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters2(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters2(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 4,4,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_BYWEBCACHE_TEXT');

p_parameters3 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters3.extend(9);
p_parameters3(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters3(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters3(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters3(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters3(5) := new mgmt_ip_param_value_record('AxisValue','3');
p_parameters3(6) := new mgmt_ip_param_value_record('PageTypeValue','1');
p_parameters3(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters3(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters3(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 5,5,
                                                 p_parameters3, null,  p_header_nlsid =>'IPMSG_BYVISITOR_TEXT');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 10 Most Popular URLs  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_TOP10MOST_POPULARURLS_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_TOP10MOST_POPULARURLS_TEXT', 
                                                              'IPMSG_WEBAPP_TOP10MOST_POPULARURLS_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_PAGEPERF_ELEMENT', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','TOP_N_MOST_POPULAR_URL_SUMMARY');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','3');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
--parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Top 10 Most Popular Pages');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_TOP10MOST_POPULARPAGES_TEXT');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 10 Slowest Pages  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_TOP10SLOWEST_PAGES_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_TOP10SLOWEST_PAGES_TEXT', 
                                                              'IPMSG_WEBAPP_TOP10SLOWEST_PAGES_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_PAGEPERF_ELEMENT', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','TOP_N_SLOWEST_PAGES_SUMMARY');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','1');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_WEBAPP_TOP10SLOWEST_PAGES_TEXT');


----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 5 Most Active Regions  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_TOP5ACTVREG_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_TOP5ACTVREG_TEXT', 
                                                              'IPMSG_WEBAPP_TOP5ACTVREG_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_PAGEPERF_ELEMENT', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','TOP_N_ACTIVE_REG_SUMMARY');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','5');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null,  p_header_nlsid =>'');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_WEBAPP_TOP5ACTVREG_TEXT');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 5 Slowest Visitor Regions  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_TOP5SLOWESTREG_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_TOP5SLOWESTREG_TEXT', 
                                                              'IPMSG_WEBAPP_TOP5SLOWESTREG_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_PAGEPERF_ELEMENT', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','IPMSG_WEBAPP_TOP5SLOWESTREG_REPORT');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','4');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_WEBAPP_TOP5SLOWESTREG_TEXT');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Page Watch List  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_PAGEWATCHLIST_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_PAGEWATCHLIST_TEXT', 
                                                              'IPMSG_WEBAPP_PAGEWATCHLIST_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY', 
                                                             'IPMSG_WEBAPP_PAGEPERF_ELEMENT', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','URL_WATCH_LIST_SUMMARY');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','2');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_PAGEPERF_ELEMENT', 
                                                 'IPMSG_SERVICE_TARGET_TYPES', '', 
                                                2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_PAGEWATCHLIST_TEXT');


--- Change the Report Owner for other reports to REP OWNER

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_TRANSPERF_SUMMARY_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_TRANSPERF_SUMMARY_TEXT',
                                                             'IPMSG_TRNSPERF_SUMMARY_BEACON_REPORT',
                                                             l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_TRANSPERF_TEXT', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);

i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','BEACON_PERF_SUMMARY');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.tp.viewBy','1');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
--p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Transaction Performance Summary: By Beacon');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_TRANS_PERFSUMMARY_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2, 2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_WEBAPP_TRANSPERF_SUMMARY_TEXT');



BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_TRANSPERF_SUMMARY_BYTRNS_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_TRANSPERF_SUMMARY_BYTRNS_TEXT',
                                                              'IPMSG_TRANSPERF_GRPBYTRNS_REPORT',
                                                             l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_TRANSPERF_TEXT', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','TRANSACTION_PERF_SUMMARY');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.tp.viewBy','2');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
--p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Transaction Performance Summary: By Transaction');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_TRANS_PERFSUMMARY_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2, 2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_WEBAPP_TRANSPERF_SUMMARY_BYTRNS_TEXT');



BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_TRANS_DETAILS_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_TRANS_DETAILS_TEXT',
                                                              'IPMSG_WEBAPP_TRANS_DETAILS_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_TRANSPERF_TEXT', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);

i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','IPMSG_WEBAPP_TRANS_DETAILS_REPORT');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(4);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_TRANSPERF_DETL_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_TRNSPERF_DETAILS_TEXT');



BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_URLPERF_INOC4J_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_URLPERF_INOC4J_TEXT',
                                                              'IPMSG_WEBAPP_URLPERFDET_DSPUSEGRAPH_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','IPMSG_WEBAPP_URLPERF_INOC4J_REPORT');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(4);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_URL_PERF_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_DRKDWNOF_ULTPROSS_TEXT');



BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_SLOWESTURL_REQUEST_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_SLOWESTURL_REQUEST_TEXT',
                                                              'IPMSG_WEBAPP_SLOWESTURL_REQUEST_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);

i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','SLOWEST_URL_SUMMARY_TOTAL_TIME');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','uri');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','10');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_URLPERF_TEXT');


BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_SLOWESTURL_RQSTBYEJB_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_SLOWESTURL_RQSTBYEJB_TEXT',
                                                              'IPMSG_WEBAPP_SLOWESTURL_RQSTBYEJB_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);
i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','SLOWEST_URL_SUMMARY_EJB');i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','ejb');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','10');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_URLPERF_TEXT');



BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_SLOWESTURL_RQSTBYJSP_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_SLOWESTURL_RQSTBYJSP_TEXT',
                                                              'IPMSG_WEBAPP_SLOWESTURL_RQSTBYJSP_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);
i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','SLOWEST_URL_SUMMARY_JSP');i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','jsp');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','10');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_URLPERF_TEXT');



BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_SLOWESTURL_RQSTBYSERVLET_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_SLOWESTURL_RQSTBYSERVLET_TEXT',
                                                              'IPMSG_WEBAPP_SLOWESTURL_RQSTBYSERVLET_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);

i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','SLOWEST_URL_SUMMARY_SERVLET');i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','servlet');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','10');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_URLPERF_TEXT');



BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_SLOWESTURL_RQSTBYJDBC_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_SLOWESTURL_RQSTBYJDBC_TEXT',
                                                              'IPMSG_WEBAPP_SLOWESTURL_RQSTBYJDBC_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);

i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','SLOWEST_URL_SUMMARY_JDBC');i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','jdbc');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','10');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_URLPERF_TEXT');


BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'IPMSG_WEBAPP_SLOWESTURL_RQSTBYHITS_TEXT', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('IPMSG_WEBAPP_SLOWESTURL_RQSTBYHITS_TEXT',
                                                              'IPMSG_WEBAPP_SLOWESTURL_RQSTBYHITS_TEXT', l_repository_owner, 'IPMSG_MONITORING_CATEGORY',
                                                             'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC', l_target_types,
                                                             0, 0,
                                                             1, '',
                                                             0, '',
                                                             'BLAF', 1,
                                                             'EM', '',
                                                             '10.2', l_param_values,
                                                             0, 0, null);

i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(4);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','SLOWEST_URL_SUMMARY_HITS');i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName','oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');i_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');
p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','hits');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','10');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT',
                                                 'IPMSG_ANY_TARGET_TYPE', '',
                                                 1, 1,
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC',
                                                 'IPMSG_SERVICE_TARGET_TYPES', '',
                                                 2,2,
                                                 p_parameters, null,  p_header_nlsid =>'IPMSG_URLPERF_TEXT');


COMMIT;
END;
/
