Rem PLEASE DO NOT PUT ANY HEADERS HERE AS IT IS INVOKED FROM license_data_upgrade.sql
Rem $Header: license_post_creation.sql 18-dec-2006.20:13:40 paachary Exp $
Rem
Rem license_post_creation.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      For NEW customers this file will be called through license/license_post_creation.sql
Rem      For UPGRADE to 10.2.0.3 this will be called from license_data_upgrade.sql
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    12/14/06 - Added New Licensing Pack Information For 10.2.0.3
Rem    ckannusa    12/19/06 - Modify SOA Pack Abbreviation Name
Rem    ckannusa    09/14/06 - add SOA Mgmt Pack License
Rem    yxie        06/23/06 - Add SML for oracle_forms
Rem    yxie        07/20/06 - Backport yxie_forms_license_fix from main
Rem    bram        06/01/06 - ASM Changes
Rem    bram        05/26/06 - Add Callback for formsapp
Rem    yxie        05/17/06 - add formsapp and oracle_forms 
Rem    yxie        07/17/06 - XbranchMerge yxie_formsapp_license from main 
Rem    bram        05/26/06 - Add Callback for formsapp
Rem    yxie        05/17/06 - add formsapp and oracle_forms 
Rem    acgopala    04/05/06 - bug-5118309
Rem    acgopala    04/05/06 - Created
Rem    acgopala    04/05/06 - bug-5118309
Rem    acgopala    04/05/06 - Created
Rem

BEGIN

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oc4jjvm'
    );
em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'osm_instance',
        p_target_type         => 'osm_instance'
    );
    em_license.del_licensable_target_types
    (
        p_pack_target_type    => 'rac_database',
        p_target_type         => 'osm_instance'
    );
    em_license.del_licensable_target_types
    (
        p_pack_target_type    => 'oracle_database',
        p_target_type         => 'osm_instance'
    );
    --Remove Callback entries for ASM
    mgmt_assoc.del_assoc_addition_callback
    (
        p_procedure_name=> 'em_license.asm_license_assoc_create',
        p_source_target_type=> MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Deployment Procedure Manager</li><li>Patching</li></p>',
        p_pack_abbr          => 'PV'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_diag'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Database Diagnostics Pack',
        p_pack_description   => 'Oracle Diagnostics Pack 10g for database offers a complete, cost-effective, and easy to use solution for managing the performance of Oracle Database environments by providing unique functionality such as automatic identification of performance bottlenecks, guided problem resolution, and comprehensive system monitoring.<p><li> Performance Monitoring (Database and Host)</li> <li> ADDM (Automated Database Diagnostic Monitor)</li> <li> Automatic Workload Repository </li> <li> Event Notifications:  Notification Methods, Rules and Schedules <li> Event history/metric history (Database and Host)</li> <li> Blackouts</li></p>',
        p_pack_abbr          => 'DD'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_tuning'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Database Tuning Pack',
        p_pack_description   => 'Oracle Tuning Pack 10g offers a set of new, groundbreaking technologies that automate the entire application tuning process, thereby significantly lowering database management costs while enhancing performance and reliability.<p><li>SQL Access Advisor</li><li>SQL Tuning Advisor</li><li>SQL Tuning Sets</li><li>Reorganize Objects</li></p>',
        p_pack_abbr          => 'DT'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_config'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Database Configuration Pack',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software configuration, software and hardware inventory tracking, patching, cloning and policy management.<p><li>Database and Host Configuration</li><li>Deployments</li><li>Patch Database and View Patch Cache</li><li>Patch staging</li><li>Clone Database</li><li>Clone Oracle Home</li><li>Search configuration</li><li>Compare configuration</li><li>Policies</li></p>' ,
        p_pack_abbr          => 'DC'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_chgmgt'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Database Change Management Pack',
        p_pack_description   => 'Oracle Change Management Pack 10g for database offers a set of applications to capture and compare the definitions of one or more database objects.<p><li>Create Metadata Baseline: You can capture database object definitions at different points in time and create reusable baseline versions.</li><li>Compare Database Objects: You can compare two sets of database objects definitions and view the differences. Comparison sources can be two databases, two baselines or a database and a baseline. You can repeat comparsions at different points in time and create comparison versions.</li></p>' ,
        p_pack_abbr          => 'CM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'formsapp'  ,
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Service Level Management delivers functionality to actively monitor and report on availability,performance of critical applications, sites, and infrastructure components using synthetic transactions executed from remote sites (beacons.)' ,
        p_pack_abbr          => 'SLM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'oracle_forms'  ,
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Service Level Management delivers functionality to actively monitor and report on availability,performance of critical applications, sites, and infrastructure components using synthetic transactions executed from remote sites (beacons.)' ,
        p_pack_abbr          => 'SLM'  
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_forms',
        p_target_type         => 'oracle_forms'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'formsapp',
        p_target_type         => 'formsapp'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'formsapp'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_forms'
    );
    --Add Callback for formsapp
    mgmt_assoc.add_assoc_addition_callback
    (
        p_procedure_name=> 'em_license.formapp_license_assoc_create',
        p_assoc_def_name=> MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
        p_source_target_type=> MGMT_GLOBAL.G_FORMSAPP_TARGET_TYPE
    );
  
    mgmt_assoc.add_assoc_deletion_callback
    (
        p_procedure_name    => 'em_license.formapp_license_assoc_delete',
        p_assoc_def_name    =>  MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
        p_source_target_type => MGMT_GLOBAL.G_FORMSAPP_TARGET_TYPE
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'mon_bpel'  ,
        p_target_type        => 'oracle_integrationbpm'  ,
        p_pack_display_label => 'SOA Management Pack',
        p_pack_description   => 'Monitoring of BPEL Process Manager.<p><li>Real-time and historical monitoring of Performance</li><li>SOA System and Services</li><li>Manage  Domain, Process and Instances</li></p>' ,
        p_pack_abbr          => 'SOAM'
    );


    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_integrationbpm',
        p_target_type         => 'oracle_integrationbpm'
    );

    em_license.add_packs
    (
        p_pack_name     => 'mon_bpel'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_integrationbpm'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'linux_host_pack'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Linux Management Pack',
        p_pack_description   => 'The Linux Management Pack provides a rich feature set for managing Linux host systems across their lifecycle. The pack includes the following functionality for the listed Linux target types only:<p><li>Bare metal provisioning and patching of Linux operating systems</li><li>Host configuration monitoring, history, and summary</li><li>Policy management and compliance support</li><li>Real-time and historical monitoring</li><li>Host OS Administration</li><li>Corresponding CLI verbs for above features</li></p>',
        p_pack_abbr          => 'LM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'linux_host_pack'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Linux Management Pack',
        p_pack_description   => 'The Linux Management Pack provides a rich feature set for managing Linux host systems across their lifecycle. The pack includes the following functionality for the listed Linux target types only:<p><li>Bare metal provisioning and patching of Linux operating systems</li><li>Host configuration monitoring, history, and summary</li><li>Policy management and compliance support</li><li>Real-time and historical monitoring</li><li>Host OS Administration</li><li>Corresponding CLI verbs for above features</li></p>',
        p_pack_abbr          => 'LM'  
    );

    em_license.add_packs
    (
        p_pack_name     => 'linux_host_pack'
    );

    COMMIT;
END;
/
