Rem
Rem $Header: service_common_init.sql 03-apr-2006.14:00:54 eporter Exp $
Rem
Rem service_common_init.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      service_common_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    eporter     03/29/06 - remove Monitoring Config page customization 
Rem    eporter     03/10/06 - add business page customizations 
Rem    eporter     03/10/06 - Created
Rem

DECLARE
  customization_data  SMP_EMD_NVPAIR_ARRAY;
  condition_names     SMP_EMD_STRING_ARRAY;
BEGIN
  customization_data := SMP_EMD_NVPAIR_ARRAY();
  customization_data.extend;
  customization_data(1) := SMP_EMD_NVPAIR(em_service.g_svc_has_business, 'false');

  -- when setting the page customization conditions, these properties must be 
  -- specified in this order.
  condition_names := SMP_EMD_STRING_ARRAY();
  condition_names.extend;
  condition_names(1) := mgmt_global.G_TARGET;
  condition_names.extend;  
  condition_names(2) := mgmt_global.G_TYPE;

  -- add the fact that these pages support the has_business property
  em_page_custmzn.add_page_customzn_metadata(mgmt_service.G_SERVICE_HOME_PAGE, customization_data, condition_names);
  em_page_custmzn.add_page_customzn_metadata(mgmt_service.G_SERVICE_CHARTS_PAGE, customization_data, condition_names);
END;
/
show errors;
