Rem drv: <migrate type="pre_data_upgrade" version="10.2.0.3" />
Rem
Rem $Header: service_post_creation.sql 19-dec-2006.10:41:19 skkunise Exp $
Rem
Rem service_post_creation.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      service_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    skkunise    12/19/06 - 
Rem    andyao      11/06/06 - fix bug 5633338, call create_metric with p_end_type_meta_ver
Rem    pmodi       07/20/06 - Backport pmodi_bug-5252154 from main 
Rem    pmodi       07/07/06 -  Added missing callback for upgrade case
Rem    eporter     03/10/06 - register business page customizations 
Rem    skkunise    02/16/06 - Registering business metrics 
Rem    skkunise    02/16/06 - Created
Rem

BEGIN
DECLARE

PROCEDURE register_business_metric(p_target_type   IN VARCHAR2,
                                   p_type_meta_ver IN VARCHAR2)
AS 
  l_metric_col_list MGMT_METRIC_COLUMN_ARRAY :=  MGMT_METRIC_COLUMN_ARRAY();
  l_cat_array MGMT_CATEGORY_ARRAY := MGMT_CATEGORY_ARRAY();
  l_type_meta_ver MGMT_TARGETS.TYPE_META_VER%TYPE := p_type_meta_ver;
BEGIN

  -- Register business metric
  l_metric_col_list.extend(1);
  l_metric_col_list(1) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_BUSINESS_KEY_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                             p_column_label_nlsid => 'svc_business_metric_name',
                             p_short_name_nlsid => 'svc_business_metric_name',
                             p_is_key => 1);

  l_metric_col_list.extend(1);
  l_metric_col_list(2) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_BUSINESS_VALUE_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                             p_column_label_nlsid => 'svc_business_metric_value',
                             p_short_name_nlsid => 'svc_business_metric_value',
                             p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                             p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC);

  l_cat_array.extend(1);
  l_cat_array(1) := MGMT_CATEGORY_OBJ.NEW(mgmt_global.G_CATEGORY_CLASS_SERVICE,
                                          mgmt_global.G_SERVICE_CATEGORY_BUSINESS);

  BEGIN
    mgmt_metric.create_metric(p_target_type => p_target_type,
                              p_metric_name => MGMT_SERVICE.G_BUSINESS_METRIC_NAME,
                              p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                              p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                              p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC,
                              p_metric_label_nlsid => 'svc_business',
                              p_short_name_nlsid => 'svc_business',
                              p_type_meta_ver => p_type_meta_ver,
                              p_metric_column_list => l_metric_col_list,
                              p_category_list => l_cat_array,
                              p_is_transposed => 1,
                              p_is_repository => 1,
                              p_end_type_meta_ver => p_type_meta_ver,
                              p_keys_from_mult_colls => 1);
     exception when dup_val_on_index then
    null;
  END;

END register_business_metric;
  
BEGIN
  
   -- register business metrics to generic service 1.0
   register_business_metric(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '1.0');

    -- register business metrics to generic service 3.0
   register_business_metric(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '3.0');

   -- register business metrics to aggregate service
   register_business_metric(MGMT_GLOBAL.G_AGGREGATE_SERVICE_TYPE, '1.0');

   COMMIT;

END;
END;
/
show errors;


BEGIN
  mgmt_assoc.add_assoc_addition_callback(
         'EM_SERVICE.assoc_addition_callback',
         mgmt_assoc.assoc_def_depends_on);
EXCEPTION
 WHEN MGMT_GLOBAL.INVALID_PARAMS THEN
  -- Internally it raise this exception on DUP_VAL
  dbms_output.put_line( 'EXCEPTION registering EM_SERVICE.assoc_addition_callback '|| SQLCODE );
  NULL;
END;
/
show errors;

BEGIN
  mgmt_assoc.add_assoc_deletion_callback(
         'EM_SERVICE.assoc_deletion_callback',
         mgmt_assoc.assoc_def_depends_on);
EXCEPTION
 WHEN MGMT_GLOBAL.INVALID_PARAMS THEN
  -- Internally it raise this exception on DUP_VAL
  dbms_output.put_line( 'EXCEPTION registering EM_SERVICE.assoc_deletion_callback'|| SQLCODE );
  NULL;
END;
/
show errors;

@@&&EM_SQL_ROOT/core/10.2.0.3/service/service_common_init.sql
