Rem DO NOT PUT HEADERS
Rem
Rem $Header: template_types.sql 05-jul-2006.03:31:24 pratagar Exp $
Rem
Rem template_types.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      template_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pratagar    01/24/06 - for 10.2.0.3 
Rem    pratagar    01/24/06 - Created
Rem

DECLARE
    l_count NUMBER := 0;
BEGIN
    SELECT count(*)
    INTO   l_count
    FROM   all_objects
    WHERE  upper(OBJECT_NAME) = 'MGMT_MNTR_METRIC_ARRAY';

    IF (l_count > 0) THEN
        EXECUTE IMMEDIATE 'DROP TYPE mgmt_mntr_metric_array';
    END IF;

    SELECT count(*)
    INTO   l_count
    FROM   all_objects
    WHERE  upper(OBJECT_NAME) = 'MGMT_MNTR_METRIC';

    IF (l_count > 0) THEN
        EXECUTE IMMEDIATE 'DROP TYPE mgmt_mntr_metric';
    END IF;
END;
/

CREATE OR REPLACE TYPE mgmt_mntr_metric AS OBJECT
(
    metric_name   VARCHAR2(64),
    metric_column VARCHAR2(64),
    coll_name     VARCHAR2(64),
    is_enabled    NUMBER(1),
    key_val_list  MGMT_POLICY_KEY_VAL_ARRAY,
    add_or_delete NUMBER(1),
    STATIC FUNCTION NEW( 
        p_metric_name   IN VARCHAR2,
        p_metric_column IN VARCHAR2,
        p_coll_name     IN VARCHAR2,
        p_is_enabled    IN NUMBER DEFAULT 1,
        p_key_val_list  IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL,
        p_add_or_delete IN NUMBER DEFAULT 0
      ) 
    RETURN mgmt_mntr_metric
);
/

show errors

CREATE OR REPLACE TYPE MGMT_MNTR_METRIC_ARRAY IS TABLE OF MGMT_MNTR_METRIC;
/

