Rem drv: <migrate type="data_upgrade" version="10.2.0.3"/>
Rem
Rem $Header: website_data_upgrade.sql 21-nov-2006.17:42:37 yxie Exp $
Rem
Rem website_data_upgrade.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      website_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    yxie        11/21/06 - XbranchMerge yxie_bug5527422 from main
Rem    yxie        11/09/06 - XbranchMerge yxie_bug5567723 from main
Rem    yxie        11/21/06 - XbranchMerge yxie_bug5527422 from main
Rem    yxie        11/09/06 - XbranchMerge yxie_bug5567723 from main
Rem    yxie        09/28/06 - 
Rem    mfidanbo    09/22/05 - add test_response dummy collections 
Rem    chyu        07/18/05 - adding the upgrade header 
Rem    yxie        07/16/05 - yxie_bug-4482115
Rem    yxie        07/11/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

BEGIN
  FOR rec IN (SELECT DISTINCT t.target_name, t.target_type, txn.test_name
                FROM MGMT_TARGETS t, MGMT_GENSVC_AVAIL_TESTS txn
               WHERE t.target_type IN (MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                                       MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE)
                 AND t.target_guid = txn.target_guid
             )
    LOOP
    BEGIN
      em_rep_metric.add_dummy_collection(rec.target_name,
                                         rec.target_type,
                                         MGMT_GLOBAL.G_AVAIL_TEST_METRIC_NAME,
                                         MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
                                         rec.test_name);
      EXCEPTION
        WHEN NO_DATA_FOUND OR DUP_VAL_ON_INDEX OR mgmt_global.key_already_exists THEN
           -- Ingore duplicate entries
          NULL;
        WHEN OTHERS THEN -- if cannot create, then metric is not defined
          MGMT_LOG.LOG_ERROR(MGMT_GENSVC_AVAIL.MODULE_NAME, NULL,
              'Could not create the test_status collection for target: ' ||
               rec.target_name || ' and Test: '|| rec.test_name ||'. Error: ' || SQLERRM,
               v_log_level_in => MGMT_GLOBAL.G_WARN);
    END;
  END LOOP;
END;
/

show errors;


BEGIN

DELETE FROM EUME2E_ASSOCS_LOOKUP;

INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_WEBCACHE_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid, 0, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_HTTP_SERVER_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid, 0, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES('generic_apache', MGMT_WEBSITE_TARGET.supports_eum_on_guid, 0, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES('oracle_apache_cluster', MGMT_WEBSITE_TARGET.supports_eum_on_guid, 1, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid, 1, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_OC4J_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_e2e_on_guid, 0, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES('oc4j_cluster', MGMT_WEBSITE_TARGET.supports_e2e_on_guid, 1, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_e2e_on_guid, 1, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES('oracle_forms', MGMT_WEBSITE_TARGET.supports_forms_on_guid, 0, 0);


END;
/
show errors;
