Rem drv: <migrate type="schema_upgrade" version="10.2.0.4.2" condition="EM_REPOS_MODE=SYSAUX"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/10.2.0.4.2/basic/basic_schema_upgrade_db.sql /st_emcore_10.2.0.4.2db11.2/2 2009/05/04 22:17:07 jsadras Exp $
Rem
Rem basic_schema_upgrade_db.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      basic_schema_upgrade_db.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     02/27/09 - Compress mgmt_metrics for all operations
Rem    jsadras     02/27/09 - Created
Rem

BEGIN
  EXECUTE IMMEDIATE 'ALTER TABLE mgmt_metrics MOVE COMPRESS FOR ALL OPERATIONS';
EXCEPTION
 -- Currently compress does not raise errors even if tables is compressed
WHEN OTHERS THEN NULL ;
END ;
/

Rem
Rem rebuild the indexes to avoid ORA 1502
Rem

BEGIN
  FOR idx IN ( SELECT owner,index_name
                 FROM ALL_INDEXES
                WHERE owner='&&EM_REPOS_USER'
                  AND table_name='MGMT_METRICS')
  LOOP
    BEGIN
      IF idx.index_name IN ('MGMT_METRICS_PK','MGMT_METRICS_IDX_03')
      THEN
        EXECUTE IMMEDIATE 
          'ALTER INDEX '||idx.owner||'.'||idx.index_name||' REBUILD COMPRESS 3' ;
      ELSE
        EXECUTE IMMEDIATE 
          'ALTER INDEX '||idx.owner||'.'||idx.index_name||' REBUILD' ;
      END IF ;
    EXCEPTION
    WHEN OTHERS THEN NULL ;
    END ;
  END LOOP ;
END ;
/
