Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/10.2.0.4.2/statbsln/statbsln_indexes.sql /st_emcore_10.2.0.4.2db11.2/1 2009/02/14 08:33:49 jsoule Exp $
Rem
Rem statbsln_indexes.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates.All rights reserved. 
Rem
Rem    NAME
Rem      statbsln_indexes.sql - Upgrade statbsln indexes.
Rem
Rem    DESCRIPTION
Rem      Upgrade statbsln indexes to 10.2.0.5.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsoule      02/12/09 - Created
Rem

ALTER SESSION ENABLE PARALLEL DDL;

BEGIN
  EXECUTE IMMEDIATE 'CREATE INDEX mgmt_bsln_intervals_idx1 ON ' ||
                    'mgmt_bsln_intervals(bsln_guid) NOLOGGING PARALLEL';
  EXECUTE IMMEDIATE 'ALTER INDEX mgmt_bsln_intervals_idx1 LOGGING NOPARALLEL';
EXCEPTION
WHEN OTHERS THEN
  IF SQLCODE NOT IN (-1408, -955) THEN
    -- ORA-01408: such column list already indexed
    -- ORA-00955: name is already used by an existing object
    RAISE;
  END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'CREATE INDEX mgmt_bsln_statistics_idx1 ON ' ||
                    'mgmt_bsln_statistics(bsln_guid) NOLOGGING PARALLEL';
  EXECUTE IMMEDIATE 'ALTER INDEX mgmt_bsln_statistics_idx1 LOGGING NOPARALLEL';
EXCEPTION
WHEN OTHERS THEN
  IF SQLCODE NOT IN (-1408, -955) THEN
    -- ORA-01408: such column list already indexed
    -- ORA-00955: name is already used by an existing object
    RAISE;
  END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'CREATE INDEX mgmt_bsln_statistics_idx2 ON ' ||
                    'mgmt_bsln_statistics(datasource_guid) NOLOGGING PARALLEL';
  EXECUTE IMMEDIATE 'ALTER INDEX mgmt_bsln_statistics_idx2 LOGGING NOPARALLEL';
EXCEPTION
WHEN OTHERS THEN
  IF SQLCODE NOT IN (-1408, -955) THEN
    -- ORA-01408: such column list already indexed
    -- ORA-00955: name is already used by an existing object
    RAISE;
  END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'CREATE INDEX mgmt_bsln_thresholds_idx1 ON ' ||
                    'mgmt_bsln_threshold_parms(bsln_guid) NOLOGGING PARALLEL';
  EXECUTE IMMEDIATE 'ALTER INDEX mgmt_bsln_thresholds_idx1 LOGGING NOPARALLEL';
EXCEPTION
WHEN OTHERS THEN
  IF SQLCODE NOT IN (-1408, -955) THEN
    -- ORA-01408: such column list already indexed
    -- ORA-00955: name is already used by an existing object
    RAISE;
  END IF;
END;
/

BEGIN
  EXECUTE IMMEDIATE 'CREATE INDEX mgmt_bsln_thresholds_idx2 ON ' ||
                    'mgmt_bsln_threshold_parms(datasource_guid) NOLOGGING PARALLEL';
  EXECUTE IMMEDIATE 'ALTER INDEX mgmt_bsln_thresholds_idx2 LOGGING NOPARALLEL';
EXCEPTION
WHEN OTHERS THEN
  IF SQLCODE NOT IN (-1408, -955) THEN
    -- ORA-01408: such column list already indexed
    -- ORA-00955: name is already used by an existing object
    RAISE;
  END IF;
END;
/

ALTER SESSION DISABLE PARALLEL DDL;
